/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.IdentificadorLamina;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.IdentificadorLaminaBean;
import jalis.model.dao.cadastro.IdentificadorLaminaDao;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.IdentificadorLaminaVO;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import java.util.Map;
import java.util.Set;

public class IdentificadorLaminaService
extends AbstractThreadService {
    public IdentificadorLaminaService() {
        this.dao = new IdentificadorLaminaDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof IdentificadorLaminaBean)) {
            throw new Exception("O tipo passado \u00e9 inv\u00e1lido.");
        }
        IdentificadorLaminaBean identificador = (IdentificadorLaminaBean)bean;
        if (identificador.getCodigo() == null) {
            identificador.setCodigo((Integer)codigo);
        }
        ((IdentificadorLaminaDao)this.dao).insert(identificador, filialPadrao);
        String tabela = bean.getClass().getAnnotation(DataBaseTable.class).value();
        this.criarSequenciaIdentificador(tabela, identificador);
        ((IdentificadorLaminaDao)this.dao).update(identificador, filialPadrao);
    }

    protected void criarSequenciaIdentificador(String tabela, AbstractThreadBean bean) throws Exception {
        if (bean == null || !(bean instanceof IdentificadorLaminaBean)) {
            throw new Exception("Objeto NULL ou tipo incorreto.");
        }
        IdentificadorLaminaBean identificador = (IdentificadorLaminaBean)bean;
        String sequence = tabela + "_" + identificador.getFilial().getCodigo() + "_" + identificador.getCodigo() + "_sequence";
        identificador.setSequence(sequence);
        StringBuilder buf = new StringBuilder();
        buf.append(" create sequence ").append(sequence);
        buf.append("       increment 1 ");
        buf.append("        minvalue 1 ");
        buf.append("        maxvalue 9223372036854775807 ");
        buf.append("           start 1 ");
        buf.append("           cache 1 ");
        Conexao.executeUpdate(Variaveis.filialPadrao, Conexao.getStatement(), buf.toString());
        buf.setLength(0);
        buf.append(" alter table ").append(sequence);
        buf.append(" owner to thread ");
        Conexao.executeUpdate(Variaveis.filialPadrao, Conexao.getStatement(), buf.toString());
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((IdentificadorLaminaDao)this.dao).update(bean, filialPadrao);
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null && bean instanceof IdentificadorLaminaBean) {
            IdentificadorLaminaBean identificador = (IdentificadorLaminaBean)bean;
            ((IdentificadorLaminaDao)this.dao).delete(bean, filialPadrao);
            if (identificador.getSequence() != null && !Funcoes.textoVazio(identificador.getSequence())) {
                Conexao.executeUpdate(filialPadrao, Conexao.getStatement(), " drop sequence " + identificador.getSequence());
            }
        } else {
            throw new Exception("Objeto NULL ou tipo incorreto.");
        }
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(IdentificadorLaminaBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return AbstractThreadDao.load(IdentificadorLaminaVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(IdentificadorLamina.getModuloAcesso(), "Cadastro de Identificadores de L\u00e2mina");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.adicionaCampo("sigla", "Sigla", 0, "", 2, 3);
        tela.setFiltroInicial("C\u00f3digo", 0);
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((IdentificadorLaminaDao)this.dao).getBean(chaves);
    }
}

