/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.DadosExportaExames;
import jalis.laboratorio.cadastro.Filial;
import jalis.laboratorio.cadastro.configurador.DiaTituloFraseDTO;
import jalis.model.AbstractThreadBean;
import jalis.model.dao.cadastro.auxiliares.FilialDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.sql.SalvaDados;
import jalis.util.sql.SalvaDadosException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FilialService
extends AbstractThreadService {
    private final long ACESSO_PERMITIR_TRANSFERIR_FILIAIS_CNPJ_DIFERENTE = Long.parseLong("0600401306");

    public FilialService() {
        this.dao = new FilialDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    @Deprecated
    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadVO getVO(String filial, String codigo) throws Exception {
        return ((FilialDao)this.dao).getVO(codigo);
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    @Deprecated
    public Set load(String where) throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(FilialVO.class, where);
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    public AbstractThreadVO getVOFilialDestino(String cnpjFilialLogada, String filialPadrao, String codigoFilialDestino) throws ThreadDaoException {
        return ((FilialDao)this.dao).getVOFilialDestino(cnpjFilialLogada, filialPadrao, codigoFilialDestino);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, "Pesquisando filiais", bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Filial.getModuloAcesso(), "Cadastro de filiais");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltro(" true ");
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVOFilialDestino(Object owner, AbstractThreadVO bean, String titulo, String cnpjFilialLogada, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Filial.getModuloAcesso(), "Cadastro de filiais");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setExecutarAoAbrir(true);
        if (Acesso.getAcesso(this.ACESSO_PERMITIR_TRANSFERIR_FILIAIS_CNPJ_DIFERENTE)) {
            tela.setFiltro("fil_codigo <> " + Variaveis.filialPadrao);
        } else {
            tela.setFiltro(" fil_cnpj like '%" + cnpjFilialLogada + "%' and fil_codigo <> " + Variaveis.filialPadrao);
        }
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public String getCodigoResponsavelCompras(String filial) throws SQLException {
        return ((FilialDao)this.dao).getCodigoResponsavelCompras(filial);
    }

    public String getCodigoResponsavelEstoque(String filial) throws SQLException {
        return ((FilialDao)this.dao).getCodigoResponsavelEstoque(filial);
    }

    public Integer getCodigoLabExterno(int filial, Statement st) throws SQLException {
        return ((FilialDao)this.dao).getCodigoLaboratorioExterno(filial, st);
    }

    public String getProtocoloLabExterno(int filial, Statement st) throws SQLException {
        return ((FilialDao)this.dao).getProtocoloLaboratorioExterno(filial, st);
    }

    public FilialVOAux buscaFilial(String codigo) throws Exception {
        return ((FilialDao)this.dao).buscaFilial(codigo);
    }

    public ArrayList<DadosExportaExames> buscaConfigExportacaoExames(String codigo) throws SQLException {
        return ((FilialDao)this.dao).buscaConfigExportacaoExames(codigo);
    }

    public String buscaConfigIntegracaoExportaWeb(String codigo) throws SQLException {
        return ((FilialDao)this.dao).buscaConfigIntegracaoExportaWeb(codigo);
    }

    public String buscaResponsavelCertificado(String codigo) throws SQLException {
        return ((FilialDao)this.dao).buscaResponsavelCertificado(codigo);
    }

    public FilialVOAux getDadosExportaBaseWeb(Statement st, String codigoFilial) throws SQLException {
        return ((FilialDao)this.dao).getDadosExportaBaseWeb(st, codigoFilial);
    }

    public FilialVOAux getDadosExportacao(Statement st, String codigoFilial) throws SQLException {
        return ((FilialDao)this.dao).getDadosExportacao(st, codigoFilial);
    }

    public ArrayList<FilialVOAux> getListFilialVOExportaBaseWeb(String codigoFilial) throws SQLException {
        return (ArrayList)((FilialDao)this.dao).getListFilialVOExportaBaseWeb(codigoFilial);
    }

    public boolean getFilialExportaPDFWeb() throws SQLException {
        return ((FilialDao)this.dao).getFilialExportaPDFWeb();
    }

    public boolean getFilialExportaHtmlWeb() throws SQLException {
        return ((FilialDao)this.dao).getFilialExportaHtmlWeb();
    }

    public boolean isGerarPdfResultado(Statement st, String filial) throws SQLException {
        FilialVOAux filialVO = ((FilialDao)this.dao).getDadosExportaBaseWeb(st, filial);
        String codigoBase = "";
        boolean retorno = false;
        if (Funcoes.carregouVO(filialVO)) {
            codigoBase = filialVO.getTipoBase();
            boolean bl = retorno = filialVO.isWebPdf() != false && filialVO.isWebStandAlone() == false;
        }
        if (Funcoes.textoVazio(codigoBase) && Funcoes.carregouVO(filialVO = this.contemAgrupamento(st, filial))) {
            retorno = filialVO.isWebPdf() != false && filialVO.isWebStandAlone() == false;
        }
        return retorno;
    }

    public FilialVOAux contemAgrupamento(Statement st, String filial) throws SQLException {
        return ((FilialDao)this.dao).contemAgrupamento(st, filial);
    }

    public boolean updateDadosDmed(String xml) throws SQLException {
        int qtde = ((FilialDao)this.dao).updateDadosDmed(xml);
        if (this.isAtualizou(qtde)) {
            return true;
        }
        throw new SQLException("N\u00e3o foi poss\u00edvel atualizar a configura\u00e7\u00e3o do Dmed.");
    }

    private boolean isAtualizou(int qtde) {
        return qtde > 0;
    }

    public void desativarAutoCopia(String codigoFilial) throws SQLException, SalvaDadosException {
        ParametrosGerais.carregaParametros();
        String copiaBairros = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaBairro()), "filiais"), codigoFilial);
        String copiaColeta = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaColeta()), "filiais"), codigoFilial);
        String copiaDestino = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaDestino()), "filiais"), codigoFilial);
        String copiaFeriado = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaFeriado()), "filiais"), codigoFilial);
        String copiaTipoMaterial = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaTipoMaterial()), "filiais"), codigoFilial);
        String copiaUnidadeMedida = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaUnidadeMedida()), "filiais"), codigoFilial);
        String copiaMaterial = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaMaterial()), "filiais"), codigoFilial);
        String copiaEspecialidade = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaEspecialidade()), "filiais"), codigoFilial);
        String copiaMedico = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaMedico()), "filiais"), codigoFilial);
        String copiaPrioridade = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaPrioridade()), "filiais"), codigoFilial);
        String copiaTabelaPreco = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaTabelaPreco()), "filiais"), codigoFilial);
        String copiaConvenio = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaConvenio()), "filiais"), codigoFilial);
        String copiaPrincipioAtivo = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaPrincipioAtivo()), "filiais"), codigoFilial);
        String copiaMedicamento = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaMedicamento()), "filiais"), codigoFilial);
        String copiaSituacao = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaSituacao()), "filiais"), codigoFilial);
        String copiaSetor = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaSetor()), "filiais"), codigoFilial);
        String copiaMetodologia = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaMetodologia()), "filiais"), codigoFilial);
        String copiaMaterialColeta = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaMaterialColeta()), "filiais"), codigoFilial);
        String copiaRecipiente = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaRecipiente()), "filiais"), codigoFilial);
        String copiaHistorico = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaHistorico()), "filiais"), codigoFilial);
        String copiaGrupo = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaGrupo()), "filiais"), codigoFilial);
        String copiaPrazo = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaPrazo()), "filiais"), codigoFilial);
        String copiaLayout = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaLayout()), "filiais"), codigoFilial);
        String copiaInterface = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaInterface()), "filiais"), codigoFilial);
        String copiaExame = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaExame()), "filiais"), codigoFilial);
        String copiaAgrupaFatura = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaAgrupaFatura()), "filiais"), codigoFilial);
        String copiaAgrupaRequisicao = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaAgrupaRequisicao()), "filiais"), codigoFilial);
        String copiaAgrupaSituacao = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaAgrupaSituacao()), "filiais"), codigoFilial);
        String copiaBanco = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaBanco()), "filiais"), codigoFilial);
        String copiaAgencia = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaAgencia()), "filiais"), codigoFilial);
        String copiaHistoricoPadrao = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaHistoricoPadrao()), "filiais"), codigoFilial);
        String copiaContas = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaContas()), "filiais"), codigoFilial);
        String copiaPlanoConta = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaPlanoConta()), "filiais"), codigoFilial);
        String copiaCidade = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaCidade()), "filiais"), codigoFilial);
        String copiaPaciente = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaPaciente()), "filiais"), codigoFilial);
        String copiaAcaoNaoConformidade = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaAcaoNaoConformidade()), "filiais"), codigoFilial);
        String copiaAla = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaAla()), "filiais"), codigoFilial);
        String copiaBanhoMaria = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaBanhoMaria()), "filiais"), codigoFilial);
        String copiaCategoriaProdutoAlimentos = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaCategoriaProdutoAlimentos()), "filiais"), codigoFilial);
        String copiaCelulaEstoque = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaCelulaEstoque()), "filiais"), codigoFilial);
        String copiaCentroCusto = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaCentroCusto()), "filiais"), codigoFilial);
        String copiaEmbalagemProduto = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaEmbalagemProduto()), "filiais"), codigoFilial);
        String copiaEntidade = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaEntidade()), "filiais"), codigoFilial);
        String copiaEspecie = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaEspecie()), "filiais"), codigoFilial);
        String copiaFormaPagamento = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaFormaPagamento()), "filiais"), codigoFilial);
        String copiaEstante = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaEstante()), "filiais"), codigoFilial);
        String copiaGeladeira = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaGeladeira()), "filiais"), codigoFilial);
        String copiaIdentificadorLamina = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaIdentificadorLamina()), "filiais"), codigoFilial);
        String copiaLabExterno = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaLabExterno()), "filiais"), codigoFilial);
        String copiaMotivoAlteracao = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaMotivoAlteracao()), "filiais"), codigoFilial);
        String copiaMotivoContato = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaMotivoDeContato()), "filiais"), codigoFilial);
        String copiaMotivoRecoleta = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaMotivoRecoleta()), "filiais"), codigoFilial);
        String copiaMotivosCancelamentos = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaMotivoCancelamento()), "filiais"), codigoFilial);
        String copiaOrigemNaoConformidade = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaOrigemNaoConformidade()), "filiais"), codigoFilial);
        String copiaTipoNaoConformidade = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaTipoNaoConformidade()), "filiais"), codigoFilial);
        String copiaOrigemPlanoCusto = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaOrigemPlanoCusto()), "filiais"), codigoFilial);
        String copiaPais = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaPais()), "filiais"), codigoFilial);
        String copiaProcedenciaNaoConform = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaProcedenciaNaoConformidade()), "filiais"), codigoFilial);
        String copiaProdutoAlimentos = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaProdutoAlimentos()), "filiais"), codigoFilial);
        String copiaRota = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaRota()), "filiais"), codigoFilial);
        String copiaSalaAtendimento = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaSalaAtendimento()), "filiais"), codigoFilial);
        String copiaSeries = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaSeries()), "filiais"), codigoFilial);
        String copiaServico = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaServico()), "filiais"), codigoFilial);
        String copiaTaxa = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaTaxa()), "filiais"), codigoFilial);
        String copiaTipoMaterialColeta = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaTipoMaterialColeta()), "filiais"), codigoFilial);
        String copiaUnidadeSaude = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaUnidadeSaude()), "filiais"), codigoFilial);
        String copiaTermoConsentimento = this.atualizaXmlCopia(StringUtil.getValor(this.validaXML(ParametrosGerais.getCopiaTermoConsentimento()), "filiais"), codigoFilial);
        SalvaDados salvar = new SalvaDados("parametros", 2);
        salvar.adicionaCampo("par_copiaacaonaoconformidade", 0, true, false, copiaAcaoNaoConformidade);
        salvar.adicionaCampo("par_copiaagencia", 0, true, false, copiaAgencia);
        salvar.adicionaCampo("par_copiaagrupafatura", 0, true, false, copiaAgrupaFatura);
        salvar.adicionaCampo("par_copiaagruparequisicao", 0, true, false, copiaAgrupaRequisicao);
        salvar.adicionaCampo("par_copiaagrupasituacao", 0, true, false, copiaAgrupaSituacao);
        salvar.adicionaCampo("par_copiaala", 0, true, false, copiaAla);
        salvar.adicionaCampo("par_copiabairro", 0, true, false, copiaBairros);
        salvar.adicionaCampo("par_copiabanco", 0, true, false, copiaBanco);
        salvar.adicionaCampo("par_copiabanhomaria", 0, true, false, copiaBanhoMaria);
        salvar.adicionaCampo("par_copiacategoriaprodutoalimentos", 0, true, false, copiaCategoriaProdutoAlimentos);
        salvar.adicionaCampo("par_copiacelulaestoque", 0, true, false, copiaCelulaEstoque);
        salvar.adicionaCampo("par_copiacentrocusto", 0, true, false, copiaCentroCusto);
        salvar.adicionaCampo("par_copiacidade", 0, true, false, copiaCidade);
        salvar.adicionaCampo("par_copiacoleta", 0, true, false, copiaColeta);
        salvar.adicionaCampo("par_copiacontas", 0, true, false, copiaContas);
        salvar.adicionaCampo("par_copiaconvenio", 0, true, false, copiaConvenio);
        salvar.adicionaCampo("par_copiadestino", 0, true, false, copiaDestino);
        salvar.adicionaCampo("par_copiaembalagemproduto", 0, true, false, copiaEmbalagemProduto);
        salvar.adicionaCampo("par_copiaentidade", 0, true, false, copiaEntidade);
        salvar.adicionaCampo("par_copiaespecialidade", 0, true, false, copiaEspecialidade);
        salvar.adicionaCampo("par_copiaespecie", 0, true, false, copiaEspecie);
        salvar.adicionaCampo("par_copiaestante", 0, true, false, copiaEstante);
        salvar.adicionaCampo("par_copiaexame", 0, true, false, copiaExame);
        salvar.adicionaCampo("par_copiaferiado", 0, true, false, copiaFeriado);
        salvar.adicionaCampo("par_copiaformapagto", 0, true, false, copiaFormaPagamento);
        salvar.adicionaCampo("par_copiageladeira", 0, true, false, copiaGeladeira);
        salvar.adicionaCampo("par_copiagrupo", 0, true, false, copiaGrupo);
        salvar.adicionaCampo("par_copiahistorico", 0, true, false, copiaHistorico);
        salvar.adicionaCampo("par_copiahistoricopadrao", 0, true, false, copiaHistoricoPadrao);
        salvar.adicionaCampo("par_copiaidentificadorlamina", 0, true, false, copiaIdentificadorLamina);
        salvar.adicionaCampo("par_copiainterface", 0, true, false, copiaInterface);
        salvar.adicionaCampo("par_copialabexterno", 0, true, false, copiaLabExterno);
        salvar.adicionaCampo("par_copialayout", 0, true, false, copiaLayout);
        salvar.adicionaCampo("par_copiamaterial", 0, true, false, copiaMaterial);
        salvar.adicionaCampo("par_copiamaterialcoleta", 0, true, false, copiaMaterialColeta);
        salvar.adicionaCampo("par_copiamedicamento", 0, true, false, copiaMedicamento);
        salvar.adicionaCampo("par_copiamedico", 0, true, false, copiaMedico);
        salvar.adicionaCampo("par_copiametodologia", 0, true, false, copiaMetodologia);
        salvar.adicionaCampo("par_copiamotivoalteracao", 0, true, false, copiaMotivoAlteracao);
        salvar.adicionaCampo("par_copiamotivocontato", 0, true, false, copiaMotivoContato);
        salvar.adicionaCampo("par_copiamotivorecoleta", 0, true, false, copiaMotivoRecoleta);
        salvar.adicionaCampo("par_copiamotivoscancelamentos", 0, true, false, copiaMotivosCancelamentos);
        salvar.adicionaCampo("par_copiaorigemnaoconformidade", 0, true, false, copiaOrigemNaoConformidade);
        salvar.adicionaCampo("par_copiaorigemplanocusto", 0, true, false, copiaOrigemPlanoCusto);
        salvar.adicionaCampo("par_copiapaciente", 0, true, false, copiaPaciente);
        salvar.adicionaCampo("par_copiapais", 0, true, false, copiaPais);
        salvar.adicionaCampo("par_copiaplanoconta", 0, true, false, copiaPlanoConta);
        salvar.adicionaCampo("par_copiaprazo", 0, true, false, copiaPrazo);
        salvar.adicionaCampo("par_copiaprincipioativo", 0, true, false, copiaPrincipioAtivo);
        salvar.adicionaCampo("par_copiaprioridade", 0, true, false, copiaPrioridade);
        salvar.adicionaCampo("par_copiaprocedencianaoconform", 0, true, false, copiaProcedenciaNaoConform);
        salvar.adicionaCampo("par_copiaprodutoalimentos", 0, true, false, copiaProdutoAlimentos);
        salvar.adicionaCampo("par_copiarecipiente", 0, true, false, copiaRecipiente);
        salvar.adicionaCampo("par_copiarota", 0, true, false, copiaRota);
        salvar.adicionaCampo("par_copiasalaatendimento", 0, true, false, copiaSalaAtendimento);
        salvar.adicionaCampo("par_copiaseries", 0, true, false, copiaSeries);
        salvar.adicionaCampo("par_copiaservico", 0, true, false, copiaServico);
        salvar.adicionaCampo("par_copiasetor", 0, true, false, copiaSetor);
        salvar.adicionaCampo("par_copiasituacao", 0, true, false, copiaSituacao);
        salvar.adicionaCampo("par_copiatabelapreco", 0, true, false, copiaTabelaPreco);
        salvar.adicionaCampo("par_copiataxa", 0, true, false, copiaTaxa);
        salvar.adicionaCampo("par_copiatipomaterial", 0, true, false, copiaTipoMaterial);
        salvar.adicionaCampo("par_copiatipomaterialcoleta", 0, true, false, copiaTipoMaterialColeta);
        salvar.adicionaCampo("par_copiatiponaoconformidade", 0, true, false, copiaTipoNaoConformidade);
        salvar.adicionaCampo("par_copiaunidademedida", 0, true, false, copiaUnidadeMedida);
        salvar.adicionaCampo("par_copiaunidadesaude", 0, true, false, copiaUnidadeSaude);
        salvar.adicionaCampo("par_copiatermoconsentimento", 0, true, false, copiaTermoConsentimento);
        salvar.adicionaCampo("lay_codigo", 0, false, true, ParametrosGerais.getLayCodigo());
        Conexao.executeUpdate(codigoFilial, Conexao.getStatement(), salvar.getComando(), true);
    }

    private String validaXML(String xml) {
        return Funcoes.textoVazio(xml) ? "" : xml;
    }

    private String atualizaXmlCopia(String xml, String codigoFilial) {
        if (!Funcoes.textoVazio(xml)) {
            StringBuilder xmlNovo = new StringBuilder();
            String[] filiais = xml.split(",");
            for (int i = 0; i < filiais.length; ++i) {
                if (filiais[i].equalsIgnoreCase(codigoFilial)) continue;
                if (!Funcoes.textoVazio(xmlNovo.toString()) && i < filiais.length) {
                    xmlNovo.append(",");
                }
                xmlNovo.append(filiais[i]);
            }
            StringBuilder buf = new StringBuilder();
            buf.append("<filiais>");
            buf.append((CharSequence)xmlNovo);
            buf.append("</filiais>");
            return buf.toString();
        }
        return xml;
    }

    public List<DiaTituloFraseDTO> buscaFrasesDiaAgendamento(Statement st, int filial) throws SQLException {
        return ((FilialDao)this.dao).buscaDiasFraseAgendameneto(st, filial);
    }

    public List<DiaTituloFraseDTO> buscaFrasesWppDiaAgendamento(Statement st, int filial) throws SQLException {
        return ((FilialDao)this.dao).buscaDiasFraseWppAgendameneto(st, filial);
    }
}

