/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Entidade;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.EntidadeBean;
import jalis.model.dao.cadastro.EntidadeDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.service.AbstractThreadService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;

public class EntidadeService
extends AbstractThreadService {
    public EntidadeService() {
        this.dao = new EntidadeDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof EntidadeBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.delete(bean, filial);
        if (((EntidadeBean)bean).getTipo().equals("I") || ((EntidadeBean)bean).getTipo().equals("P")) {
            Statement st;
            block6: {
                st = Conexao.getStatement();
                try {
                    String base = ExportaWeb.getCodigoBaseWeb(st, filial);
                    if (Funcoes.textoVazio(base)) break block6;
                    String[] comando = new String[]{"codigoBase", base, "codigoEntidade", String.valueOf(((EntidadeBean)bean).getCodigo())};
                    DBUtil.insereExportaWeb(filial, st, "entidade", "D", comando);
                }
                catch (Exception e) {
                    try {
                        throw new Exception(e);
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((EntidadeDao)this.dao).getBean(filial, codigo);
    }

    public AbstractThreadBean get(String filial, String codigo, String tipo) throws Exception {
        return ((EntidadeDao)this.dao).getBean(filial, codigo, tipo);
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadVO getVO(String filial, String codigo) throws Exception {
        return ((EntidadeDao)this.dao).getVO(filial, codigo);
    }

    public AbstractThreadVO getVO(String filial, String codigo, String tipo) throws Exception {
        return ((EntidadeDao)this.dao).getVO(filial, codigo, tipo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        Statement st;
        block6: {
            if (!(bean instanceof EntidadeBean)) {
                throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
            }
            st = Conexao.getStatement();
            try {
                ((EntidadeBean)bean).setCodigo((Integer)codigo);
                this.dao.insert(bean, filial);
                if (!((EntidadeBean)bean).getTipo().equals("I") && !((EntidadeBean)bean).getTipo().equals("P")) break block6;
                String base = ExportaWeb.getCodigoBaseWeb(st, filial);
                EntidadeBean b = (EntidadeBean)bean;
                if (!Funcoes.textoVazio(base)) {
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoEntidade", String.valueOf(b.getCodigo()), "nomeEntidade", StringUtil.textoDB(b.getRazaoSocial()), "senhaEntidade", b.getSenhaWeb(), "cpfEntidade", StringUtil.textoDB(b.getCpfCnpj()), "tipoEntidade", b.getTipo()};
                    DBUtil.insereExportaWeb(filial, st, "entidade", "I", comando);
                }
            }
            catch (ThreadDaoException e) {
                try {
                    throw new Exception(e);
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(EntidadeBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(EntidadeVO.class, where);
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof EntidadeBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
        if (((EntidadeBean)bean).getTipo().equals("I") || ((EntidadeBean)bean).getTipo().equals("P")) {
            Statement st;
            block6: {
                st = Conexao.getStatement();
                try {
                    String base = ExportaWeb.getCodigoBaseWeb(st, filial);
                    EntidadeBean b = (EntidadeBean)bean;
                    if (Funcoes.textoVazio(base)) break block6;
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoEntidade", String.valueOf(b.getCodigo()), "nomeEntidade", StringUtil.textoDB(b.getRazaoSocial()), "senhaEntidade", b.getSenhaWeb(), "cpfEntidade", StringUtil.textoDB(b.getCpfCnpj()), "tipoEntidade", b.getTipo()};
                    DBUtil.insereExportaWeb(st, "entidade", "A", comando);
                }
                catch (Exception e) {
                    try {
                        throw new Exception(e);
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("fantasia", "Fantasia", 0, "", 2, 0);
        tela.adicionaCampo("razaoSocial", "Raz\u00e3o Social", 0, "", 2, 0);
        if (titulo.equals("Pesquisa de Cadastro")) {
            tela.adicionaCampo("cpfCnpj", "CNPJ", 0, "##.###.###/####-##", 3, 0);
        }
        tela.setFiltroInicial("Fantasia", 2);
        tela.setColunaOrdenacao("Fantasia");
        tela.setFiltro(" fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false ");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVOTipoRepresentante(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("fantasia", "Fantasia", 0, "", 2, 0);
        tela.adicionaCampo("razaoSocial", "Raz\u00e3o Social", 0, "", 2, 0);
        tela.setFiltroInicial("Fantasia", 2);
        tela.setColunaOrdenacao("Fantasia");
        tela.setFiltro(" fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false and ent_tipo = upper('" + "R" + "') ");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, String tipoEntidade) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro && tipoEntidade.equalsIgnoreCase("U")) {
            tela.setTelaCadastro(Entidade.getModuloAcesso(2), "Cadastro de Funcion\u00e1rios");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("fantasia", "Fantasia", 0, "", 2, 0);
        tela.adicionaCampo("razaoSocial", "Raz\u00e3o Social", 0, "", 2, 0);
        if (tipoEntidade.equalsIgnoreCase("F")) {
            tela.adicionaCampo("cpfCnpj", "CNPJ", 0, "##.###.###/####-##", 3, 0);
        }
        tela.setFiltroInicial("Fantasia", 2);
        tela.setColunaOrdenacao("Fantasia");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and ent_tipo = '" + tipoEntidade + "'  and ent_inativo = false");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, int tipoTelaCadastro, String tipo, boolean mostrarCadastro, String filial) {
        return this.pesquisaVO(owner, bean, titulo, tipoTelaCadastro, mostrarCadastro, false, filial, tipo);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, int tipoTelaCadastro, String tipo, boolean mostrarCadastro) {
        return this.pesquisaVO(owner, bean, titulo, tipoTelaCadastro, mostrarCadastro, tipo);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, int tipoTelaCadastro, String tipo, boolean mostrarCadastro, boolean mostrarInativo) {
        return this.pesquisaVO(owner, bean, titulo, tipoTelaCadastro, mostrarCadastro, mostrarInativo, Variaveis.filialPadrao, tipo);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, int tipoTelaCadastro, boolean mostrarCadastro, String ... tipo) {
        return this.pesquisaVO(owner, bean, titulo, tipoTelaCadastro, mostrarCadastro, false, Variaveis.filialPadrao, tipo);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, int tipoTelaCadastro, boolean mostrarCadastro, boolean mostrarInativo, String filial, String ... tipo) {
        FrmPesquisaService tela;
        block19: {
            tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
            try {
                if (mostrarCadastro) {
                    if (tipoTelaCadastro == 1) {
                        tela.setTelaCadastro(Entidade.getModuloAcesso(tipoTelaCadastro), "Cadastro de fornecedores");
                    } else if (tipoTelaCadastro == 3) {
                        tela.setTelaCadastro(Entidade.getModuloAcesso(tipoTelaCadastro), "Cadastro de coletadores");
                    } else if (tipoTelaCadastro == 5) {
                        tela.setTelaCadastro(Entidade.getModuloAcesso(tipoTelaCadastro), "Cadastro de fiscais");
                    } else if (tipoTelaCadastro == 2) {
                        tela.setTelaCadastro(Entidade.getModuloAcesso(tipoTelaCadastro), "Cadastro de funcion\u00e1rios");
                    } else if (tipoTelaCadastro == 4) {
                        tela.setTelaCadastro(Entidade.getModuloAcesso(tipoTelaCadastro), "Cadastro de representantes");
                    } else if (tipoTelaCadastro == 6) {
                        tela.setTelaCadastro(Entidade.getModuloAcesso(tipoTelaCadastro), "Cadastro de respons\u00e1veis");
                    } else if (tipoTelaCadastro == 7) {
                        tela.setTelaCadastro(Entidade.getModuloAcesso(tipoTelaCadastro), "Cadastro de empresas");
                    }
                }
            }
            catch (NullPointerException npe) {
                if (!mostrarCadastro) break block19;
                tela.setTelaCadastro(-1L, "Cadastro de Entidades");
            }
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("fantasia", "Fantasia", 0, "", 2, 0);
        tela.adicionaCampo("razaoSocial", "Raz\u00e3o Social", 0, "", 2, 0);
        if (tipoTelaCadastro == 1) {
            tela.adicionaCampo("cpfCnpj", "CNPJ", 0, "##.###.###/####-##", 3, 0);
        }
        tela.setFiltroInicial("Fantasia", 2);
        tela.setColunaOrdenacao("Fantasia");
        StringBuilder b = new StringBuilder();
        for (String s : tipo) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append("'").append(s).append("'");
        }
        tela.setFiltro("fil_codigo = " + filial + " and ent_tipo in (" + b.toString() + ")" + (!mostrarInativo ? " and ent_inativo = false" : ""));
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVOFornecedor(Object owner, AbstractThreadVO bean, String titulo, String filial, String cnpj) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("fantasia", "Fantasia", 0, "", 2, 0);
        tela.adicionaCampo("razaoSocial", "Raz\u00e3o Social", 0, "", 2, 0);
        tela.setFiltroInicial("Fantasia", 2);
        tela.setColunaOrdenacao("Fantasia");
        StringBuilder b = new StringBuilder();
        tela.setFiltro("fil_codigo = " + filial + " and ent_tipo = '" + "F" + "'  and ent_cpfcnpj = '" + cnpj + "' and ent_inativo = false");
        tela.setExecutarAoAbrir(true);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntidadeBean localizarPeloDocumento(String filial, String cpfcnpj, String tipoCadastro) {
        Statement st;
        EntidadeBean retorno;
        block4: {
            retorno = null;
            StringBuilder buf = new StringBuilder("select ent_codigo from entidade ");
            buf.append("where fil_codigo = ").append(filial).append(" and ent_cpfcnpj = '").append(cpfcnpj).append("' and ent_tipo = '").append(tipoCadastro).append("'");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                retorno = (EntidadeBean)this.get(filial, rs.getString("ent_codigo"));
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "EntidadeService: 132");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int quantosFornecedoresParaCNPJ(String filial, String cpfcnpj, String tipoCadastro) {
        Statement st;
        block4: {
            int n;
            StringBuilder buf = new StringBuilder("select count(ent_codigo) as quantidade from entidade ");
            buf.append("where fil_codigo = ").append(filial).append(" and ent_cpfcnpj = '").append(cpfcnpj).append("' and ent_tipo = '").append(tipoCadastro).append("' and ent_inativo = false");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                n = rs.getInt("quantidade");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "EntidadeService: 132");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return n;
        }
        Conexao.fecharStatement(st);
        return 0;
    }
}

