/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Destino;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.DestinoBean;
import jalis.model.bean.cadastro.TaxaDestinoBean;
import jalis.model.dao.cadastro.DestinoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.DestinoVO;
import jalis.model.vo.cadastro.TaxaDestinoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.TaxaDestinoService;
import jalis.util.ArraysUtil;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DestinoService
extends AbstractThreadService {
    private TaxaDestinoService serviceTaxaDestino = new TaxaDestinoService();

    public DestinoService() {
        this.dao = new DestinoDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        String[] codigos;
        if (!(bean instanceof DestinoBean)) {
            throw new Exception("Tipo incorreto.");
        }
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (DestinoService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
        }
        for (String filial : codigos) {
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(filial));
            ((DestinoBean)bean).setFilial(filialVO);
            this.dao.insert(bean, filial);
            DestinoBean destinoBean = (DestinoBean)bean;
            for (TaxaDestinoVO taxaDestinoVO : destinoBean.getTaxaDestinoVOsModelo()) {
                taxaDestinoVO.setFilial(filialVO);
                this.serviceTaxaDestino.insert(taxaDestinoVO, taxaDestinoVO, filial, null);
            }
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        String[] codigos;
        if (!(bean instanceof DestinoBean)) {
            throw new Exception("Tipo incorreto.");
        }
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (DestinoService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
        }
        for (String filial : codigos) {
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(filial));
            ((DestinoBean)bean).setFilial(filialVO);
            this.dao.update(bean, filial);
            DestinoBean destinoBean = (DestinoBean)bean;
            Set taxaDestinoBeans = this.serviceTaxaDestino.load(" where des_codigo = " + StringUtil.textoDBEscape(destinoBean.getCodigo()) + " and fil_codigo = " + filial);
            for (TaxaDestinoBean taxaDestinoBean : taxaDestinoBeans) {
                taxaDestinoBean.setFilial(filialVO);
                this.serviceTaxaDestino.delete(taxaDestinoBean, codigo, taxaDestinoBean.getFilial().getCodigo().toString(), filiais);
            }
            for (TaxaDestinoVO taxaDestinoVO : destinoBean.getTaxaDestinoVOsModelo()) {
                taxaDestinoVO.setFilial(filialVO);
                this.serviceTaxaDestino.insert(taxaDestinoVO, codigo, taxaDestinoVO.getFilial().getCodigo().toString(), filiais);
            }
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        String[] codigos;
        if (!(bean instanceof DestinoBean)) {
            throw new Exception("Tipo incorreto.");
        }
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (DestinoService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
        }
        for (String filial : codigos) {
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(filial));
            ((DestinoBean)bean).setFilial(filialVO);
            Set taxaDestinoBeans = this.serviceTaxaDestino.load(" where des_codigo = " + StringUtil.textoDBEscape(((DestinoBean)bean).getCodigo()) + " and fil_codigo = " + filial);
            for (TaxaDestinoBean taxaDestinoBean : taxaDestinoBeans) {
                taxaDestinoBean.setFilial(filialVO);
                this.serviceTaxaDestino.delete(taxaDestinoBean, codigo, taxaDestinoBean.getFilial().getCodigo().toString(), filiais);
            }
            this.dao.delete(bean, filialPadrao);
        }
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return this.pesquisaVO(owner, bean, titulo, Variaveis.filialPadrao, mostrarCadastro);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, String filial, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Destino.getModuloAcesso(), "Cadastro de Destino");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 0, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setService(this);
        tela.setFiltro(" fil_codigo = " + filial);
        tela.setExecutarAoAbrir(true);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(DestinoBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(DestinoVO.class, where);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", Variaveis.filialPadrao);
        chaves.put("des_codigo", codigo);
        return ((DestinoDao)this.dao).getBean(chaves);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", Variaveis.filialPadrao);
        chaves.put("des_codigo", codigo);
        return ((DestinoDao)this.dao).getVO(chaves);
    }

    @Override
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return null;
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((DestinoDao)this.dao).getBean(chaves);
    }

    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((DestinoDao)this.dao).getVO(chaves);
    }

    public DestinoBean carregarDestino(String filial, String codigoDestino, Statement st) throws SQLException {
        return ((DestinoDao)this.dao).carregarDestino(filial, codigoDestino, st);
    }
}

