/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Convenio;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.convenio.ConvenioCotaExameBean;
import jalis.model.bean.cadastro.convenio.ConvenioCotaExameSituacaoBean;
import jalis.model.bean.cadastro.convenio.ConvenioCotaUnidadeSaudeBean;
import jalis.model.dao.cadastro.ConvenioDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.service.AbstractThreadService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConvenioService
extends AbstractThreadService {
    public ConvenioService() {
        this.dao = new ConvenioDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Deprecated
    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadVO getVO(String filial, String codigo) throws Exception {
        return ((ConvenioDao)this.dao).getVO(filial, codigo);
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    @Deprecated
    public Set load(String where) throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ConvenioVO.class, where);
    }

    public Set loadCotaExame(String where) throws Exception {
        return AbstractThreadDao.load(ConvenioCotaExameBean.class, where);
    }

    public Set loadCotaUnidadeSaude(String where) throws Exception {
        return AbstractThreadDao.load(ConvenioCotaUnidadeSaudeBean.class, where);
    }

    public Set loadCotaExameSituacao(String where) throws Exception {
        return AbstractThreadDao.load(ConvenioCotaExameSituacaoBean.class, where);
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return this.pesquisaVO(owner, bean, titulo, Variaveis.filialPadrao, mostrarCadastro);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, String filial, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        try {
            if (mostrarCadastro) {
                tela.setTelaCadastro(Convenio.getModuloAcesso(), "Cadastro de Conv\u00eanios");
            }
        }
        catch (NullPointerException npe) {
            tela.setTelaCadastro(-1L, "Cadastro de Conv\u00eanios");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("fantasia", "Fantasia", 0, "", 2, 0);
        tela.setFiltroInicial("Fantasia", 2);
        tela.setColunaOrdenacao("Fantasia");
        tela.setFiltro("fil_codigo = " + filial);
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ConvenioDao)this.dao).getBean(chaves);
    }

    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ConvenioDao)this.dao).getVO(chaves);
    }

    public BigDecimal getPercentualMaximoDescontoUsuario(String filial, String codigoConvenio, String codigoUsuario) throws SQLException {
        return ((ConvenioDao)this.dao).getValorMaximoDescontoUsuario(filial, codigoConvenio, codigoUsuario);
    }

    public FaturamentoEletronico getProtocoloEletronico(String filial, String codigoConvenio) throws SQLException {
        return ((ConvenioDao)this.dao).getProtocoloEletronico(filial, codigoConvenio);
    }

    public boolean getPossuiCampoPermitirPesquisaApoio() {
        return DBUtil.campoExiste(Conexao.getStatement(), "convenios", "con_permitirpesquisaapoio");
    }

    public boolean permiteAdicionarConvenio(String codigoConvenio, String filial) {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", filial);
        chaves.put("con_codigo", codigoConvenio);
        ConvenioVO convenioVO = null;
        try {
            convenioVO = (ConvenioVO)this.getVO(chaves);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (convenioVO != null && !Funcoes.textoVazio(convenioVO.getFiliaisProibidas())) {
            String[] filiais;
            for (String s : filiais = convenioVO.getFiliaisProibidas().split(",")) {
                if (!Funcoes.isNumeric(s.trim()) || Integer.parseInt(s.trim()) != Integer.parseInt(filial.trim())) continue;
                return false;
            }
        }
        return true;
    }

    public void delete(AbstractThreadBean bean, String filial) throws ThreadDaoException {
        this.dao.delete(bean, filial);
    }

    public void insert(AbstractThreadBean bean, String filial) throws ThreadDaoException {
        this.dao.insert(bean, filial);
    }

    public boolean getConvenioUtilizaCotaExame(String filial, String codigo) throws SQLException {
        return ((ConvenioDao)this.dao).getConvenioUtilizaCotaExame(filial, codigo);
    }

    public String getTipoIntegracaoOperadoraSaude(String codigoFilial, String codigoConvenio) throws SQLException {
        ConvenioDao cfr_ignored_0 = (ConvenioDao)this.dao;
        return ConvenioDao.getTipoIntegracaoOperadoraSaude(codigoFilial, codigoConvenio);
    }

    public String getXmlDoConvenio(String codigoFilial, String codigoConvenio) throws SQLException {
        return ((ConvenioDao)this.dao).getXmlDoConvenio(codigoFilial, codigoConvenio);
    }

    public List<ConvenioCotaExameBean> retornaConvenioCotaExame(int filial, int convenio, String tipoPolitica) throws Exception {
        return ((ConvenioDao)this.dao).retornaConvenioCotaExame(filial, convenio, tipoPolitica);
    }

    public int retornaConvenioCotaExameQuantidade(Integer filial, int convenio, String tipoPolitica, String exame, Integer material) throws Exception {
        return ((ConvenioDao)this.dao).retornaConvenioCotaExameQuantidade(filial, convenio, tipoPolitica, exame, material);
    }

    public List<ConvenioCotaExameSituacaoBean> retornaConvenioCotaExameSituacao(int filial, String convenio, String tipoPolitica) throws Exception {
        return ((ConvenioDao)this.dao).retornaConvenioCotaExameSituacao(filial, convenio, tipoPolitica);
    }

    public int quantidadeRequisicaoPorPeriodoMes(int filial, int codigoConvenio, String exame, int material, boolean isConsiderarAgendamentoCota, Date data, Integer codigoRequisicao) throws Exception {
        return ((ConvenioDao)this.dao).quantidadeRequisicaoPorPeriodoMes(filial, codigoConvenio, exame, material, isConsiderarAgendamentoCota, data, codigoRequisicao);
    }

    public Date retornaDataHoraUltimoFaturamento(int filial, int codigoConvenio, String exame, int material) throws Exception {
        return ((ConvenioDao)this.dao).retornaDataHoraUltimoFaturamento(filial, codigoConvenio, exame, material);
    }

    public int quantidadeRequisicaoPorDataFaturamento(int filial, int codigoConvenio, String exame, int material, boolean isConsiderarAgendamentoCota, Date data) throws Exception {
        return ((ConvenioDao)this.dao).quantidadeRequisicaoPorDataFaturamento(filial, codigoConvenio, exame, material, isConsiderarAgendamentoCota, data);
    }

    public Boolean isConsiderarAgendamentoCota(int filial, int codigoConvenio) throws Exception {
        return ((ConvenioDao)this.dao).isConsiderarAgendamentoCota(filial, codigoConvenio);
    }

    public Double retornaPercentualConvenio(Integer filial, Integer codigoConvenio) throws SQLException {
        return ((ConvenioDao)this.dao).getPercentualPagamentoMinimo(filial, codigoConvenio);
    }

    public Integer retornaConvenioRequisicao(Integer filial, Integer requisicao, Statement st) throws SQLException {
        return ((ConvenioDao)this.dao).retornaConvenioRequisicao(filial, requisicao, st);
    }

    public Integer getCodigoLabExterno(int filial, Integer codigoConvenio, Statement st) throws SQLException {
        return ((ConvenioDao)this.dao).getCodigoLaboratorioExterno(filial, codigoConvenio, st);
    }
}

