/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro;

import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.ConvenioMatriculaBean;
import jalis.model.bean.cadastro.convenio.ConvenioBean;
import jalis.model.dao.cadastro.auxiliares.ConvenioMatriculaConvenioDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioMatriculaVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.service.AbstractThreadService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConvenioMatriculaService
extends AbstractThreadService {
    public ConvenioMatriculaService() {
        this.dao = new ConvenioMatriculaConvenioDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ConvenioBean || bean instanceof ConvenioVO) {
            ConvenioBean convenioBean = (ConvenioBean)bean;
            Set convenioMatriculaBean = this.load(" where con_codigo =" + convenioBean.getCodigo() + " and fil_codigo = " + Variaveis.filialPadrao + " order by cma_contador");
            for (ConvenioMatriculaBean b : convenioMatriculaBean) {
                this.dao.delete(b, filialPadrao);
            }
        }
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((ConvenioMatriculaConvenioDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadVO getVO(String filial, String codigo) throws Exception {
        return ((ConvenioMatriculaConvenioDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ConvenioBean) {
            ConvenioBean convenioBean = (ConvenioBean)bean;
            this.delete(convenioBean, codigo, filialPadrao, filiais);
            for (ConvenioMatriculaBean matriculaBean : convenioBean.getConvenioMatriculaBeans()) {
                this.dao.insert(matriculaBean, filialPadrao);
            }
        }
    }

    @Override
    public Set load() throws Exception {
        return this.dao.load(ConvenioMatriculaBean.class);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(ConvenioMatriculaBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.dao.loadVO(ConvenioMatriculaVO.class);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ConvenioMatriculaVO.class, where);
    }

    public Set loadVO(Integer codigoConvenio) throws Exception {
        String whereSql = " where con_codigo =" + codigoConvenio + " and fil_codigo = " + Variaveis.filialPadrao + " order by cma_contador";
        return this.dao.loadVO(ConvenioMatriculaVO.class, whereSql);
    }

    public Set loadVOProibidas(Integer codigoConvenio) throws Exception {
        String whereSql = " where con_codigo =" + codigoConvenio + " and fil_codigo = " + Variaveis.filialPadrao + " and cma_operacao = '" + "P" + "' order by cma_contador";
        return this.dao.loadVO(ConvenioMatriculaVO.class, whereSql);
    }

    public Set loadVOPermitidas(Integer codigoConvenio) throws Exception {
        String whereSql = " where con_codigo =" + codigoConvenio + " and fil_codigo = " + Variaveis.filialPadrao + " and cma_operacao = '" + "E" + "' order by cma_contador";
        return this.dao.loadVO(ConvenioMatriculaVO.class, whereSql);
    }

    public Boolean verificaMatricula(String matricula, String codConvenio, String tipo) throws Exception {
        Set matriculas = new HashSet();
        if (tipo.equals("E")) {
            matriculas = this.loadVOPermitidas(Integer.valueOf(codConvenio));
        } else if (tipo.equals("P")) {
            matriculas = this.loadVOProibidas(Integer.valueOf(codConvenio));
        }
        for (ConvenioMatriculaVO convenioMatriculaVO : matriculas) {
            String matriculaConfigurada = this.formataMatriculaConfigurada(convenioMatriculaVO);
            String matriculaInformada = this.formataMatriculaInformada(matricula);
            if (!matriculaInformada.equals(matriculaConfigurada) || !tipo.equals("E") && !tipo.equals("P")) continue;
            return true;
        }
        return tipo.equals("E");
    }

    private String formataMatriculaInformada(String matricula) {
        if (matricula.trim().length() > 3) {
            return matricula.trim().substring(0, 4);
        }
        return matricula.trim().substring(0, matricula.trim().length());
    }

    private String formataMatriculaConfigurada(ConvenioMatriculaVO convenioMatriculaVO) {
        if (convenioMatriculaVO.getMascara().trim().length() > 3) {
            return convenioMatriculaVO.getMascara().trim().substring(0, 4);
        }
        return convenioMatriculaVO.getMascara().trim().substring(0, convenioMatriculaVO.getMascara().trim().length());
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ConvenioMatriculaBean) {
            this.dao.update(bean, filialPadrao);
        }
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ConvenioMatriculaConvenioDao)this.dao).getBean(chaves);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }
}

