/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Coleta;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.ColetaBean;
import jalis.model.bean.cadastro.TaxaColetaBean;
import jalis.model.dao.cadastro.ColetaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ColetaVO;
import jalis.model.vo.cadastro.TaxaColetaVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.TaxaColetaService;
import jalis.util.ArraysUtil;
import jalis.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ColetaService
extends AbstractThreadService {
    private TaxaColetaService serviceTaxaColeta = new TaxaColetaService();

    public ColetaService() {
        this.dao = new ColetaDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        String[] codigos;
        if (!(bean instanceof ColetaBean)) {
            throw new Exception("Tipo incorreto.");
        }
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (ColetaService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
        }
        for (String filial : codigos) {
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(filial));
            ((ColetaBean)bean).setFilial(filialVO);
            this.dao.insert(bean, filial);
            ColetaBean coletaBean = (ColetaBean)bean;
            for (TaxaColetaVO taxaColetaVO : coletaBean.getTaxaColetaVOs()) {
                taxaColetaVO.setFilial(filialVO);
                this.serviceTaxaColeta.insert(taxaColetaVO, taxaColetaVO, filial, null);
            }
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        String[] codigos;
        if (!(bean instanceof ColetaBean)) {
            throw new Exception("Tipo incorreto.");
        }
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (ColetaService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
        }
        for (String filial : codigos) {
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(filial));
            ((ColetaBean)bean).setFilial(filialVO);
            this.dao.update(bean, filialPadrao);
            ColetaBean coletaBean = (ColetaBean)bean;
            Set taxaColetaBeans = this.serviceTaxaColeta.load(" where col_codigo = " + StringUtil.textoDBEscape(coletaBean.getCodigo()) + " and fil_codigo = " + filial);
            for (TaxaColetaBean taxaColetaBean : taxaColetaBeans) {
                taxaColetaBean.setFilial(filialVO);
                this.serviceTaxaColeta.delete(taxaColetaBean, codigo, taxaColetaBean.getFilial().getCodigo().toString(), filiais);
            }
            for (TaxaColetaVO taxaColetaVO : coletaBean.getTaxaColetaVOs()) {
                taxaColetaVO.setFilial(filialVO);
                this.serviceTaxaColeta.insert(taxaColetaVO, codigo, taxaColetaVO.getFilial().getCodigo().toString(), filiais);
            }
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        String[] codigos;
        if (!(bean instanceof ColetaBean)) {
            throw new Exception("Tipo incorreto.");
        }
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (ColetaService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
        }
        for (String filial : codigos) {
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(filial));
            ((ColetaBean)bean).setFilial(filialVO);
            Set taxaColetaBeans = this.serviceTaxaColeta.load(" where col_codigo = " + StringUtil.textoDBEscape(((ColetaBean)bean).getCodigo()) + " and fil_codigo = " + filial);
            for (TaxaColetaBean taxaColetaBean : taxaColetaBeans) {
                taxaColetaBean.setFilial(filialVO);
                this.serviceTaxaColeta.delete(taxaColetaBean, codigo, taxaColetaBean.getFilial().getCodigo().toString(), filiais);
            }
            this.dao.delete(bean, filialPadrao);
        }
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return this.pesquisaVO(owner, bean, titulo, Variaveis.filialPadrao, mostrarCadastro);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, String filial, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Coleta.getModuloAcesso(), "Cadastro de Coletas");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 0, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setService(this);
        tela.setFiltro(" fil_codigo = " + filial);
        tela.setExecutarAoAbrir(true);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(ColetaBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ColetaVO.class, where);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", Variaveis.filialPadrao);
        chaves.put("col_codigo", codigo);
        return ((ColetaDao)this.dao).getBean(chaves);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", Variaveis.filialPadrao);
        chaves.put("col_codigo", codigo);
        return ((ColetaDao)this.dao).getVO(chaves);
    }

    @Override
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return null;
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ColetaDao)this.dao).getBean(chaves);
    }

    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ColetaDao)this.dao).getVO(chaves);
    }
}

