/*
 * Decompiled with CFR 0.152.
 */
package jalis.service;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Set;

public abstract class AbstractThreadService {
    public static final int INSERT = 0;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    protected AbstractThreadDao dao = null;

    public abstract void insert(AbstractThreadBean var1, Object var2, String var3, String var4) throws Exception;

    public abstract void update(AbstractThreadBean var1, Object var2, String var3, String var4) throws Exception;

    public abstract void delete(AbstractThreadBean var1, Object var2, String var3, String var4) throws Exception;

    public abstract AbstractThreadBean get(String var1) throws Exception;

    public abstract AbstractThreadBean getVO(String var1) throws Exception;

    public abstract Set load() throws Exception;

    public abstract Set load(String var1) throws Exception;

    public abstract Set loadVO() throws Exception;

    public abstract Set loadVO(String var1) throws Exception;

    public AbstractThreadBean voToBean(AbstractThreadVO vo, Class classeBean) throws Exception {
        if (this.dao == null) {
            throw new Exception("Objeto DAO n\u00e3o encontrado para a classe: " + this.getClass());
        }
        return this.dao.voToBean(vo, classeBean);
    }

    public abstract AbstractThreadVO pesquisaVO(Object var1, AbstractThreadVO var2, String var3, boolean var4);

    @Deprecated
    public void gravaAutoCopia(AbstractThreadBean bean, int tipo, String filiais) throws Exception {
        this.gravaAutoCopia(bean, tipo, Variaveis.filialPadrao, filiais);
    }

    @Deprecated
    public void gravaAutoCopia(AbstractThreadBean bean, int tipo, String filialPadrao, String filiais) throws Exception {
        String[] codigos;
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos.length == 0 || AbstractThreadService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = new String[]{filialPadrao};
        }
        Field[] fields = bean.getClass().getDeclaredFields();
        FilialVO filialVO = null;
        Field fieldFilial = null;
        for (Field f : fields) {
            if (f.getType() != FilialVO.class) continue;
            fieldFilial = f;
            fieldFilial.setAccessible(true);
            filialVO = (FilialVO)fieldFilial.get(bean);
            break;
        }
        if (filialVO == null) {
            throw new Exception("Classe " + bean.getClass() + " n\u00e3o possui campo filial definido!");
        }
        if (!bean.getClass().isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + bean.getClass());
        }
        int valor = 1;
        String tabela = "";
        if (tipo == 0) {
            tabela = bean.getClass().getAnnotation(DataBaseTable.class).value();
            String[] stringArray2 = codigos;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String s = stringArray2[i];
                int v = this.dao.ultimoValorSequence(tabela + "_" + s + "_sequence");
                if (v <= valor) continue;
                valor = v;
            }
        }
        for (String filial : codigos) {
            filialVO.setCodigo(Integer.parseInt(filial));
            filialVO.setDescricao("");
            if (fieldFilial == null) {
                throw new Exception("Campo filial nulo.");
            }
            fieldFilial.set(bean, filialVO);
            if (tipo == 0) {
                this.insert(bean, valor, filial, filiais);
                continue;
            }
            if (tipo == 1) {
                this.update(bean, valor, filial, filiais);
                continue;
            }
            if (tipo != 2) continue;
            this.delete(bean, valor, filial, filiais);
        }
        Conexao.arquivaSQL();
    }

    public void gravaAutoCopiaSemCommit(AbstractThreadBean bean, int tipo, String filialPadrao, String filiais) throws Exception {
        String[] codigos;
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (AbstractThreadService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            if (codigos.length == 1 && Funcoes.textoVazio(codigos[0])) {
                codigos[0] = filialPadrao;
            } else {
                codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
            }
        }
        Field[] fields = bean.getClass().getDeclaredFields();
        FilialVO filialVO = null;
        Field fieldFilial = null;
        for (Field f : fields) {
            if (f.getType() != FilialVO.class) continue;
            fieldFilial = f;
            fieldFilial.setAccessible(true);
            filialVO = (FilialVO)fieldFilial.get(bean);
            break;
        }
        if (filialVO == null) {
            throw new Exception("Classe " + bean.getClass() + " n\u00e3o possui campo filial definido!");
        }
        if (!bean.getClass().isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + bean.getClass());
        }
        int valor = 1;
        if (tipo == 0) {
            valor = this.getSequenceAutoCopia(bean.getClass().getAnnotation(DataBaseTable.class).value(), codigos, bean);
        }
        for (String filial : codigos) {
            filialVO.setCodigo(Integer.parseInt(filial));
            filialVO.setDescricao("");
            if (fieldFilial == null) {
                throw new Exception("Campo filial nulo.");
            }
            fieldFilial.set(bean, filialVO);
            try {
                if (tipo == 0) {
                    this.insert(bean, valor, filial, filiais);
                    continue;
                }
                if (tipo == 1) {
                    this.update(bean, valor, filial, filiais);
                    continue;
                }
                if (tipo != 2) continue;
                this.delete(bean, valor, filial, filiais);
            }
            catch (Exception e) {
                if (!filial.equalsIgnoreCase(filialPadrao)) {
                    throw new Exception("N\u00e3o foi possivel " + (tipo == 0 ? "inserir" : (tipo == 1 ? "atualizar" : "remover")) + " (auto-c\u00f3pia) na filial \"" + filial + "\".\n" + e.getMessage(), e);
                }
                throw e;
            }
        }
    }

    protected int getSequenceAutoCopia(String tabela, String[] codigos, AbstractThreadBean bean) throws Exception {
        if (codigos != null) {
            int valor = 1;
            for (String s : codigos) {
                int v = this.dao.ultimoValorSequence(tabela + "_" + s + "_sequence");
                if (v <= valor) continue;
                valor = v;
            }
            return valor;
        }
        return 1;
    }

    protected static int localizaFilialCopia(String[] filiais, String filial) {
        if (filiais != null) {
            for (int i = 0; i < filiais.length; ++i) {
                if (!filiais[i].equalsIgnoreCase(filial)) continue;
                return i;
            }
        }
        return -1;
    }
}

