/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador.item;

import jalis.relatorio.gerador.Bordas;
import jalis.relatorio.gerador.item.Banda;
import jalis.relatorio.gerador.item.ItemBanda;
import jalis.relatorio.gerador.item.ItemImpressao;
import jalis.relatorio.gerador.item.ItemValor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JTextArea;

public class Texto
extends JTextArea
implements ItemBanda,
ItemValor,
Cloneable {
    private Banda dono;
    private Bordas bordas;
    private String campo;

    public Texto() {
        this.setBorder(null);
        this.setOpaque(false);
        this.setLineWrap(true);
    }

    @Override
    public void setNome(String nome) {
        this.setName(nome);
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public void setCorDaFonte(Color cor) {
        this.setForeground(cor);
    }

    @Override
    public void setFonte(Font fonte) {
        this.setFont(fonte);
    }

    @Override
    public void setDimensoes2DFloat(Rectangle2D.Float dimensoes) {
        this.setDimensoes((int)dimensoes.x, (int)dimensoes.y, (int)dimensoes.width, (int)dimensoes.height);
    }

    @Override
    public void setDimensoes(Rectangle dimensoes) {
        this.setBounds(dimensoes);
    }

    @Override
    public void setDimensoes(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    @Override
    public Point getPosicao() {
        return this.getLocation();
    }

    @Override
    public Shape getClip() {
        return new Rectangle2D.Float(this.getX(), this.getY(), this.getWidth() + 1, this.getHeight() + 1);
    }

    @Override
    public Shape getClip(float zoom) {
        return new Rectangle2D.Float((float)this.getX() * zoom, (float)this.getY() * zoom, (float)this.getWidth() * zoom + 1.0f, (float)this.getHeight() * zoom + 1.0f);
    }

    @Override
    public Banda getDono() {
        return this.dono;
    }

    @Override
    public void setDono(Banda dono) {
        this.dono = dono;
    }

    public void setTexto(String texto) {
        this.setText(texto);
    }

    @Override
    public ItemImpressao getItemImpressao(float yOffset) {
        Texto texto = new Texto();
        texto.setName(this.getName());
        texto.setBounds(this.getX(), this.getY() + (int)yOffset, this.getWidth(), this.getHeight());
        texto.setBordas(this.bordas);
        texto.setFont(this.getFont());
        texto.setForeground(this.getForeground());
        texto.setQuebrarPalavras(this.getQuebrarPalavras());
        texto.setTexto(this.getText());
        return texto;
    }

    @Override
    public void setValor(Object valor) {
        if (valor != null) {
            this.setText(valor.toString());
        }
    }

    @Override
    public String getCampoBanco() {
        return this.campo;
    }

    public void setCampoBanco(String campoBanco) {
        this.campo = campoBanco;
    }

    @Override
    public void setBordas(Bordas bordas) {
        this.bordas = bordas;
    }

    public Bordas getBordas() {
        return this.bordas;
    }

    public boolean getQuebrarPalavras() {
        return !this.getWrapStyleWord();
    }

    public void setQuebrarPalavras(boolean quebrar) {
        this.setWrapStyleWord(!quebrar);
    }

    @Override
    public void pintar(Graphics g) {
        super.paint(g);
        g.setClip(null);
        if (this.bordas != null) {
            g.setColor(Color.black);
            Rectangle r = new Rectangle(this.getBounds());
            r.setLocation(0, 0);
            this.bordas.pintar(g, r);
        }
    }

    @Override
    public void setPosicao(Point p) {
        this.setDimensoes(new Rectangle(p.x, p.y, this.getWidth(), this.getHeight()));
    }

    @Override
    public Texto clone() {
        Texto t = null;
        try {
            t = (Texto)super.clone();
            t.setName(this.getName());
            t.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            t.setBordas(this.bordas);
            t.setFont(this.getFont());
            t.setForeground(this.getForeground());
            t.setQuebrarPalavras(this.getQuebrarPalavras());
            t.setTexto(this.getText());
            t.setCampoBanco(this.campo);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }
}

