/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador.item;

import jalis.relatorio.gerador.Bordas;
import jalis.relatorio.gerador.item.Banda;
import jalis.relatorio.gerador.item.ItemBanda;
import jalis.relatorio.gerador.item.ItemImpressao;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;

public class Rotulo
implements ItemBanda,
Cloneable {
    private static final JLabel label = new JLabel();
    protected Banda dono;
    protected Bordas bordas;
    protected String nome;
    protected Rectangle dimensoes = new Rectangle();
    protected Font fonte = label.getFont();
    protected Color corDaFonte = label.getForeground();
    protected int alinhamento = label.getHorizontalAlignment();
    protected String texto = "";

    @Override
    public Banda getDono() {
        return this.dono;
    }

    @Override
    public void setDono(Banda dono) {
        this.dono = dono;
    }

    @Override
    public void setBordas(Bordas bordas) {
        this.bordas = bordas;
    }

    public Bordas getBordas() {
        return this.bordas;
    }

    @Override
    public void setNome(String name) {
        this.nome = name;
    }

    @Override
    public String getNome() {
        return this.nome;
    }

    @Override
    public void setDimensoes2DFloat(Rectangle2D.Float dimensoes) {
        this.setDimensoes((int)dimensoes.x, (int)dimensoes.y, (int)dimensoes.width, (int)dimensoes.height);
    }

    @Override
    public void setPosicao(Point p) {
        this.dimensoes = new Rectangle(p.x, p.y, this.dimensoes.width, this.dimensoes.height);
    }

    @Override
    public void setDimensoes(Rectangle dimensoes) {
        this.dimensoes = dimensoes;
    }

    public Rectangle getDimensoes() {
        return this.dimensoes;
    }

    @Override
    public void setDimensoes(int x, int y, int width, int height) {
        this.setDimensoes(new Rectangle(x, y, width, height));
    }

    @Override
    public Point getPosicao() {
        return this.dimensoes.getLocation();
    }

    @Override
    public Shape getClip() {
        return new Rectangle2D.Float(this.dimensoes.x, this.dimensoes.y, this.dimensoes.width + 1, this.dimensoes.height + 1);
    }

    @Override
    public Shape getClip(float zoom) {
        return new Rectangle2D.Float((float)this.dimensoes.x * zoom, (float)this.dimensoes.y * zoom, (float)this.dimensoes.width * zoom + 1.0f, (float)this.dimensoes.height * zoom + 1.0f);
    }

    @Override
    public void setFonte(Font fonte) {
        this.fonte = fonte;
    }

    public Font getFonte() {
        return this.fonte;
    }

    @Override
    public void setCorDaFonte(Color corDaFonte) {
        this.corDaFonte = corDaFonte;
    }

    public Color getCorDaFonte() {
        return this.corDaFonte;
    }

    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alinhamento = alinhamento;
    }

    public int getAlinhamentoHorizontal() {
        return this.alinhamento;
    }

    public void setTexto(String texto) {
        this.texto = texto;
    }

    public String getTexto() {
        return this.texto;
    }

    @Override
    public ItemImpressao getItemImpressao(float yOffset) {
        Rotulo item = new Rotulo();
        item.setNome(this.nome);
        item.setDimensoes(this.dimensoes.x, this.dimensoes.y + (int)yOffset, this.dimensoes.width, this.dimensoes.height);
        item.setBordas(this.bordas);
        item.setFonte(this.fonte);
        item.setCorDaFonte(this.corDaFonte);
        item.setAlinhamentoHorizontal(this.alinhamento);
        item.setTexto(StringUtil.getSubstring(this.texto, this.dimensoes.width - 6, label.getFontMetrics(this.fonte)));
        return item;
    }

    @Override
    public void pintar(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.fonte);
        FontMetrics fm = g2.getFontMetrics();
        g2.setColor(this.corDaFonte);
        int w = fm.stringWidth(this.texto == null ? "" : this.texto);
        int x = 3;
        if (this.alinhamento == 0) {
            x = (this.dimensoes.width - w) / 2;
        } else if (this.alinhamento == 4) {
            x = this.dimensoes.width - w - 3;
        }
        g2.drawString(this.texto, x, (this.dimensoes.height + fm.getHeight()) / 2 - fm.getDescent());
        if (this.bordas != null) {
            g2.setColor(Color.black);
            Rectangle r = new Rectangle(this.dimensoes);
            r.setLocation(0, 0);
            this.bordas.pintar(g2, r);
        }
    }

    @Override
    public Rotulo clone() {
        Rotulo r = null;
        try {
            r = (Rotulo)super.clone();
            r.setFonte(this.fonte);
            r.setCorDaFonte(this.corDaFonte);
            r.setTexto(this.getTexto());
            r.setAlinhamentoHorizontal(this.alinhamento);
            r.setTexto(this.texto);
            r.setBordas(this.bordas);
            r.setDimensoes(this.dimensoes);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return r;
    }
}

