/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador.item;

import jalis.relatorio.gerador.Bordas;
import jalis.relatorio.gerador.item.Banda;
import jalis.relatorio.gerador.item.ItemBanda;
import jalis.relatorio.gerador.item.ItemImpressao;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;

public class Label
extends JLabel
implements ItemBanda {
    private Banda dono;
    private Bordas bordas;
    private boolean quebraPalavras = false;

    @Override
    public void pintar(Graphics g) {
        super.paint(g);
        g.setClip(null);
        if (this.bordas != null) {
            g.setColor(Color.black);
            Rectangle r = new Rectangle(this.getBounds());
            r.setLocation(0, 0);
            this.bordas.pintar(g, r);
        }
    }

    @Override
    public Point getPosicao() {
        return this.getLocation();
    }

    @Override
    public Shape getClip() {
        return new Rectangle2D.Float(this.getX(), this.getY(), this.getWidth() + 1, this.getHeight() + 1);
    }

    @Override
    public Shape getClip(float zoom) {
        return new Rectangle2D.Float((float)this.getX() * zoom, (float)this.getY() * zoom, (float)this.getWidth() * zoom + 1.0f, (float)this.getHeight() * zoom + 1.0f);
    }

    @Override
    public void setDimensoes(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    @Override
    public void setNome(String nome) {
        this.setName(nome);
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public void setBordas(Bordas bordas) {
        this.bordas = bordas;
    }

    @Override
    public void setDimensoes(Rectangle dimensoes) {
        this.setBounds(dimensoes);
    }

    @Override
    public void setDimensoes2DFloat(Rectangle2D.Float dimensoes) {
        this.setDimensoes((int)dimensoes.x, (int)dimensoes.y, (int)dimensoes.width, (int)dimensoes.height);
    }

    @Override
    public void setFonte(Font fonte) {
        this.setFont(fonte);
    }

    @Override
    public void setCorDaFonte(Color cor) {
        this.setForeground(cor);
    }

    @Override
    public Banda getDono() {
        return this.dono;
    }

    @Override
    public void setDono(Banda dono) {
        this.dono = dono;
    }

    @Override
    public ItemImpressao getItemImpressao(float yOffset) {
        Label label = new Label();
        label.setName(this.getName());
        label.setBounds(this.getX(), this.getY() + (int)yOffset, this.getWidth(), this.getHeight());
        label.setBordas(this.bordas);
        label.setFont(this.getFont());
        label.setForeground(this.getForeground());
        label.setQuebrarPalavras(this.getQuebrarPalavras());
        label.setText(this.getText());
        label.setHorizontalAlignment(this.getHorizontalAlignment());
        return label;
    }

    @Override
    public ItemBanda clone() {
        Label label = null;
        try {
            label = (Label)super.clone();
            label.setName(this.getName());
            label.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            label.setBordas(this.bordas);
            label.setFont(this.getFont());
            label.setForeground(this.getForeground());
            label.setQuebrarPalavras(this.getQuebrarPalavras());
            label.setText(this.getText());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return label;
    }

    @Override
    public void setPosicao(Point p) {
        this.setDimensoes(new Rectangle(p.x, p.y, this.getWidth(), this.getHeight()));
    }

    public boolean getQuebrarPalavras() {
        return this.quebraPalavras;
    }

    public void setQuebrarPalavras(boolean quebraPalavras) {
        this.quebraPalavras = quebraPalavras;
    }
}

