/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador.item;

import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.relatorio.gerador.Bordas;
import jalis.relatorio.gerador.Escopo;
import jalis.relatorio.gerador.ExecutaExpressao;
import jalis.relatorio.gerador.Registro;
import jalis.relatorio.gerador.item.Banda;
import jalis.relatorio.gerador.item.ItemBanda;
import jalis.relatorio.gerador.item.ItemImpressao;
import jalis.relatorio.gerador.item.ItemValor;
import jalis.util.ImagemUtils;
import jalis.util.expressao.parser.Arvore;
import jalis.util.expressao.parser.ExpUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.math.RoundingMode;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.commons.codec.binary.Base64;

public class Imagem
extends JComponent
implements ItemBanda,
ItemValor,
Cloneable {
    private Banda dono;
    private String campo;
    private String expressao;
    private String condicao;
    private String imagemCondicao;
    private ImageIcon imagem;
    private boolean exibirImagem = false;
    private boolean estender;
    private int alinHori;
    private int alinVert;
    private Bordas bordas;
    private Registro reg;
    private Escopo escopo;
    private Map<String, Object> vars;

    @Override
    public void setCorDaFonte(Color cor) {
        this.setForeground(cor);
    }

    @Override
    public void setFonte(Font fonte) {
        this.setFont(fonte);
    }

    public void setDados(Registro reg, Escopo escopo, Map<String, Object> variaveis) {
        this.reg = reg;
        this.escopo = escopo;
        this.vars = variaveis;
    }

    @Override
    public void setDimensoes2DFloat(Rectangle2D.Float dimensoes) {
        this.setDimensoes((int)dimensoes.x, (int)dimensoes.y, (int)dimensoes.width, (int)dimensoes.height);
    }

    @Override
    public void setDimensoes(Rectangle dimensoes) {
        this.setBounds(dimensoes);
    }

    @Override
    public void setDimensoes(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public void setNome(String nome) {
        this.setName(nome);
    }

    @Override
    public Point getPosicao() {
        return this.getLocation();
    }

    @Override
    public Shape getClip() {
        return new Rectangle2D.Float(this.getX(), this.getY(), this.getWidth() + 1, this.getHeight() + 1);
    }

    @Override
    public Shape getClip(float zoom) {
        return new Rectangle2D.Float((float)this.getX() * zoom, (float)this.getY() * zoom, (float)this.getWidth() * zoom + 1.0f, (float)this.getHeight() * zoom + 1.0f);
    }

    public void setImagem(String imagem) {
        try {
            this.imagem = imagem != null ? new ImageIcon(new Base64().decode(imagem)) : null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Imagem: 124");
        }
    }

    public String getImagem() {
        if (this.imagem != null) {
            return new Base64().encodeAsString(ImagemUtils.imageToByte(this.imagem.getImage()));
        }
        return null;
    }

    @Override
    public void setValor(Object valor) {
        if (valor instanceof String) {
            this.setImagem((String)valor);
        }
    }

    @Override
    public String getCampoBanco() {
        return this.campo;
    }

    public void setCampoBanco(String campo) {
        this.campo = campo;
    }

    public String getExpressao() {
        return this.expressao;
    }

    public void setExpressao(String expressao) {
        this.expressao = expressao;
    }

    public String getCondicao() {
        return this.condicao;
    }

    public void setCondicao(String condicao, String imagem) {
        this.condicao = condicao;
        this.imagemCondicao = imagem;
    }

    @Override
    public Banda getDono() {
        return this.dono;
    }

    @Override
    public void setDono(Banda dono) {
        this.dono = dono;
    }

    @Override
    public void setBordas(Bordas bordas) {
        this.bordas = bordas;
    }

    public void setEstender(boolean estender) {
        this.estender = estender;
    }

    public void setAlinhamentoHorizontal(int alin) {
        this.alinHori = alin;
    }

    public void setAlinhamentoVertical(int alin) {
        this.alinVert = alin;
    }

    @Override
    public ItemImpressao getItemImpressao(float yOffset) {
        Imagem img = new Imagem();
        img.setBounds(this.getX(), this.getY() + (int)yOffset, this.getWidth(), this.getHeight());
        img.setBordas(this.bordas);
        img.setAlinhamentoHorizontal(this.alinHori);
        img.setAlinhamentoVertical(this.alinVert);
        img.setImagem(this.getImagem());
        img.setEstender(this.estender);
        return img;
    }

    public void executar(int casas, RoundingMode round) {
        try {
            Object valor = new ExecutaExpressao(this.dono.getItens(), this.reg, this.escopo, this.vars, casas, round).resolver(this.expressao);
            if (valor != null && valor instanceof String) {
                this.setValor(ExpUtil.getStringObject(valor));
            } else {
                this.setValor("");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Imagem: 316");
        }
    }

    public void executarCondicao(ItemBanda item, int casas, RoundingMode round) {
        if (this.getCondicao().trim().length() > 0) {
            Arvore valor = new ExecutaExpressao(this.dono.getItens(), this.reg, this.escopo, this.vars, casas, round).resolverCondicao(this.condicao);
            TabelaSimbolos tabela = new TabelaSimbolos();
            for (String colunas : this.reg.getColunas()) {
                Object vl = this.reg.getValor(colunas);
                tabela.setSimbolo(colunas, vl);
            }
            Execucao exe = new Execucao(this.getCondicao(), tabela, 1);
            boolean res = exe.resultadoCondicao();
            if (!res && !this.exibirImagem) {
                this.imagem = null;
            } else if (this.imagemCondicao != null && this.imagem == null) {
                this.imagem = new ImageIcon(new Base64().decode(this.imagemCondicao));
            }
        }
    }

    @Override
    public void pintar(Graphics g) {
        if (this.imagem != null) {
            Dimension d = this.getSize();
            if (this.estender) {
                g.drawImage(this.imagem.getImage(), 0, 0, d.width, d.height, null);
            } else {
                int x;
                int n = this.alinHori == 2 ? 0 : (x = this.alinHori == 4 ? d.width : (d.width - this.imagem.getIconWidth()) / 2);
                int y = this.alinVert == 1 ? 0 : (this.alinVert == 3 ? d.height : (d.height - this.imagem.getIconHeight()) / 2);
                g.drawImage(this.imagem.getImage(), x, y, this.imagem.getIconWidth(), this.imagem.getIconHeight(), null);
            }
        }
        if (this.bordas != null) {
            g.setColor(Color.black);
            Rectangle r = new Rectangle(this.getBounds());
            r.setLocation(0, 0);
            this.bordas.pintar(g, r);
        }
    }

    @Override
    public void setPosicao(Point p) {
        this.setDimensoes(new Rectangle(p.x, p.y, this.getBounds().width, this.getBounds().height));
    }

    @Override
    public Imagem clone() {
        Imagem i = null;
        try {
            i = (Imagem)super.clone();
            i.setEstender(this.estender);
            i.setImagem(new Base64().encodeAsString(ImagemUtils.imageToByte(this.imagem.getImage())));
            i.setCampoBanco(this.campo);
            i.setAlinhamentoVertical(this.alinVert);
            i.setAlinhamentoHorizontal(this.alinHori);
            i.setFonte(this.getFont());
            i.setCorDaFonte(this.getForeground());
            i.setDimensoes(this.getBounds());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return i;
    }

    public boolean isExibirImagem() {
        return this.exibirImagem;
    }

    public void setExibirImagem(boolean exibirImagem) {
        this.exibirImagem = exibirImagem;
    }
}

