/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador.item;

import jalis.relatorio.gerador.Bordas;
import jalis.relatorio.gerador.item.Banda;
import jalis.relatorio.gerador.item.ItemBanda;
import jalis.relatorio.gerador.item.ItemImpressao;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class Forma
extends JComponent
implements ItemBanda,
Cloneable {
    public static final int RETANGULO = 0;
    public static final int CIRCULO = 1;
    public static final int LINHA_HORIZONTAL = 2;
    public static final int LINHA_VERTICAL = 3;
    private Banda dono;
    private int tipo = 0;
    private int alinHori = 0;
    private int alinVert = 0;
    private int espessura = 1;

    @Override
    public void setNome(String nome) {
        this.setName(nome);
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public void setDimensoes2DFloat(Rectangle2D.Float dimensoes) {
        this.setDimensoes((int)dimensoes.x, (int)dimensoes.y, (int)dimensoes.width, (int)dimensoes.height);
    }

    @Override
    public void setDimensoes(Rectangle dimensoes) {
        this.setBounds(dimensoes);
    }

    @Override
    public void setDimensoes(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    @Override
    public Point getPosicao() {
        return this.getLocation();
    }

    @Override
    public Shape getClip() {
        return new Rectangle2D.Float(this.getX(), this.getY(), this.getWidth() + 1, this.getHeight() + 1);
    }

    @Override
    public Shape getClip(float zoom) {
        return new Rectangle2D.Float((float)this.getX() * zoom, (float)this.getY() * zoom, (float)this.getWidth() * zoom + 1.0f, (float)this.getHeight() * zoom + 1.0f);
    }

    @Override
    public void setCorDaFonte(Color cor) {
        this.setForeground(cor);
    }

    @Override
    public void setFonte(Font fonte) {
        this.setFont(fonte);
    }

    @Override
    public Banda getDono() {
        return this.dono;
    }

    @Override
    public void setDono(Banda dono) {
        this.dono = dono;
    }

    @Override
    public void setBordas(Bordas bordas) {
    }

    public void setCorLinha(Color cor) {
        this.setForeground(cor);
    }

    public void setCorPreenchimento(Color cor) {
        this.setBackground(cor);
    }

    public int getEspessura() {
        return this.espessura;
    }

    public void setEspessura(int espessura) {
        this.espessura = espessura;
    }

    public void setTipo(int tipo) {
        this.tipo = tipo;
    }

    public void setAlinhamentoHorizontal(int alin) {
        this.alinHori = alin;
    }

    public void setAlinhamentoVertical(int alin) {
        this.alinVert = alin;
    }

    @Override
    public ItemImpressao getItemImpressao(float yOffset) {
        Forma forma = new Forma();
        forma.setName(this.getName());
        forma.setBounds(this.getX(), this.getY() + (int)yOffset, this.getWidth(), this.getHeight());
        forma.setTipo(this.tipo);
        forma.setCorLinha(this.getForeground());
        forma.setCorPreenchimento(this.getBackground());
        forma.setAlinhamentoHorizontal(this.alinHori);
        forma.setAlinhamentoVertical(this.alinVert);
        forma.setEspessura(this.espessura);
        return forma;
    }

    @Override
    public void pintar(Graphics g) {
        Dimension d = this.getSize();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.getBackground());
        switch (this.tipo) {
            case 0: {
                g2d.fillRect(0, 0, d.width, d.height);
                break;
            }
            case 1: {
                g2d.fillOval(0, 0, d.width, d.height);
            }
        }
        g2d.setColor(this.getForeground());
        g2d.setStroke(new BasicStroke(this.espessura));
        switch (this.tipo) {
            case 0: {
                g2d.drawRect(0, 0, d.width, d.height);
                break;
            }
            case 1: {
                g2d.drawOval(0, 0, d.width, d.height);
                break;
            }
            case 2: {
                int y = this.alinVert == 1 ? 0 : (this.alinVert == 3 ? d.height : d.height / 2);
                g2d.drawLine(0, y, d.width, y);
                break;
            }
            case 3: {
                int x = this.alinHori == 2 ? 0 : (this.alinHori == 4 ? d.width : d.width / 2);
                g2d.drawLine(x, 0, x, d.height);
            }
        }
    }

    @Override
    public void setPosicao(Point p) {
        this.setDimensoes(new Rectangle(p.x, p.y, this.getBounds().width, this.getBounds().height));
    }

    @Override
    public Forma clone() {
        Forma f = null;
        try {
            f = (Forma)super.clone();
            f.setTipo(this.tipo);
            f.setEspessura(this.espessura);
            f.setCorLinha(this.getForeground());
            f.setCorPreenchimento(this.getBackground());
            f.setAlinhamentoVertical(this.alinVert);
            f.setAlinhamentoHorizontal(this.alinHori);
            f.setFonte(this.getFont());
            f.setCorDaFonte(this.getForeground());
            f.setDimensoes(this.getBounds());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return f;
    }
}

