/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador.item;

import jalis.relatorio.gerador.Escopo;
import jalis.relatorio.gerador.ExecutaExpressao;
import jalis.relatorio.gerador.Registro;
import jalis.relatorio.gerador.item.ExpressaoListener;
import jalis.relatorio.gerador.item.ItemImpressao;
import jalis.relatorio.gerador.item.Rotulo;
import jalis.relatorio.gerador.item.Texto;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.expressao.parser.ExpUtil;
import jalis.util.logger.ErrorLogger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class Expressao
extends Rotulo
implements ExpressaoListener {
    private Object valor;
    private String expressao;
    private String mascara;
    private Registro reg;
    private Escopo escopo;
    private Map<String, Object> vars;
    private boolean quebrarLinhas;
    private boolean quebrarPalavras;
    private int casas = 2;
    private RoundingMode round = RoundingMode.HALF_UP;
    private EventListenerList listenerList = new EventListenerList();

    public void addExpressaoListener(ExpressaoListener l) {
        this.listenerList.add(ExpressaoListener.class, l);
    }

    public void removeExpressaoListener(ExpressaoListener l) {
        this.listenerList.remove(ExpressaoListener.class, l);
    }

    public void setDados(Registro reg, Escopo escopo, Map<String, Object> variaveis, int casas, RoundingMode round) {
        this.reg = reg;
        this.escopo = escopo;
        this.vars = variaveis;
        this.casas = casas;
        this.round = round;
    }

    public void executar() {
        try {
            this.valor = new ExecutaExpressao(this.dono.getItens(), this.reg, this.escopo, this.vars, this.casas, this.round).resolver(this.expressao);
            if (this.valor != null) {
                if (this.mascara != null && this.mascara.length() > 0) {
                    if (this.valor instanceof Date) {
                        this.setTexto(Funcoes.formataData(this.mascara.replace('a', 'y').replace('h', 'k'), (Date)this.valor));
                    } else if (StringUtil.validaDouble(this.valor.toString())) {
                        String masc = StringUtil.trocarCaractere(this.mascara, ',', '.');
                        if (StringUtil.validaMascaraNumero(masc)) {
                            this.setTexto(new DecimalFormat(masc).format(Double.parseDouble(StringUtil.strDecimal(this.valor.toString()))));
                        } else {
                            this.setTexto(StringUtil.strDecimal(this.valor.toString()));
                        }
                    } else {
                        this.setTexto(ExpUtil.getStringObject(this.valor));
                    }
                } else {
                    this.setTexto(ExpUtil.getStringObject(this.valor));
                }
            } else {
                this.setTexto("");
            }
            this.fireExecutou();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Expressao: 83");
        }
    }

    public void setExpressao(String expressao) {
        this.expressao = expressao;
    }

    public String getExpressao() {
        return this.expressao;
    }

    public void setMascara(String mascara) {
        this.mascara = mascara;
    }

    public void setQuebrarLinhas(boolean quebrar) {
        this.quebrarLinhas = quebrar;
    }

    public void setQuebrarPalavras(boolean quebrar) {
        this.quebrarPalavras = quebrar;
    }

    public Object getValor() {
        return this.valor;
    }

    protected void fireExecutou() {
        for (ExpressaoListener ouvinte : (ExpressaoListener[])this.listenerList.getListeners(ExpressaoListener.class)) {
            ouvinte.executou();
        }
    }

    @Override
    public void executou() {
        this.executar();
    }

    public ItemImpressao getItemImpressao(int yOffset) {
        if (!this.quebrarLinhas) {
            return super.getItemImpressao(yOffset);
        }
        Texto text = new Texto();
        text.setName(this.getNome());
        text.setBounds(this.dimensoes.x, this.dimensoes.y + yOffset, this.dimensoes.width, this.dimensoes.height);
        text.setBordas(this.bordas);
        text.setFonte(this.fonte);
        text.setCorDaFonte(this.corDaFonte);
        text.setQuebrarPalavras(this.quebrarPalavras);
        text.setTexto(this.texto);
        return text;
    }
}

