/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador.item;

import jalis.relatorio.gerador.item.ItemValor;
import jalis.relatorio.gerador.item.Rotulo;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.expressao.parser.ExpUtil;
import java.text.DecimalFormat;
import java.util.Date;

public class CampoBanco
extends Rotulo
implements ItemValor {
    private String campo;
    private String mascara;

    @Override
    public void setValor(Object valor) {
        if (valor != null) {
            if (this.mascara != null && this.mascara.length() > 0) {
                if (valor instanceof Date) {
                    this.setTexto(Funcoes.formataData(this.mascara.replace('a', 'y').replace('h', 'k'), (Date)valor));
                } else if (StringUtil.validaDouble(valor.toString())) {
                    String masc = StringUtil.trocarCaractere(this.mascara, ',', '.');
                    if (StringUtil.validaMascaraNumero(masc)) {
                        this.setTexto(new DecimalFormat(masc).format(Double.parseDouble(StringUtil.strDecimal(valor.toString()))));
                    } else {
                        this.setTexto(StringUtil.strDecimal(valor.toString()));
                    }
                } else {
                    this.setTexto(ExpUtil.getStringObject(valor));
                }
            } else {
                this.setTexto(ExpUtil.getStringObject(valor));
            }
        }
    }

    @Override
    public String getCampoBanco() {
        return this.campo;
    }

    public void setCampoBanco(String campo) {
        this.campo = campo;
    }

    public void setMascara(String mascara) {
        this.mascara = mascara;
    }
}

