/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador.item;

import jalis.relatorio.gerador.Bordas;
import jalis.relatorio.gerador.item.Banda;
import jalis.relatorio.gerador.item.CampoBanco;
import jalis.relatorio.gerador.item.CodigoBarras;
import jalis.relatorio.gerador.item.CodigoQRCode;
import jalis.relatorio.gerador.item.Expressao;
import jalis.relatorio.gerador.item.Forma;
import jalis.relatorio.gerador.item.Imagem;
import jalis.relatorio.gerador.item.ItemBanda;
import jalis.relatorio.gerador.item.Rotulo;
import jalis.relatorio.gerador.item.Texto;
import jalis.util.StringUtil;
import jalis.util.expressao.parser.Lexico;
import jalis.util.expressao.parser.Token;
import jalis.util.logger.ErrorLogger;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BandaFactory {
    public static ItemBanda novoItemBanda(String atributos) {
        try {
            Object o = Class.forName(StringUtil.getValor(atributos, "tipoItem")).newInstance();
            if (o instanceof ItemBanda) {
                Cloneable cb;
                ItemBanda item = (ItemBanda)o;
                item.setNome(StringUtil.getValor(atributos, "nome"));
                item.setDimensoes2DFloat(StringUtil.getRetangulo2DFloat(StringUtil.getValor(atributos, "retangulo")));
                item.setFonte(StringUtil.getFonte(StringUtil.getValor(atributos, "fonte")));
                item.setCorDaFonte(StringUtil.getColor(atributos, "corDaFonte"));
                if (o instanceof Rotulo) {
                    Rotulo r = (Rotulo)o;
                    r.setAlinhamentoHorizontal(StringUtil.getInt(atributos, "alinhamentoHorizontal"));
                    r.setTexto(StringUtil.getValor(atributos, "texto"));
                    r.setBordas(new Bordas().setAtributos(StringUtil.getValor(atributos, "bordas")));
                }
                if (o instanceof CampoBanco) {
                    cb = (CampoBanco)o;
                    ((CampoBanco)cb).setCampoBanco(StringUtil.getValor(atributos, "nomeCampo"));
                    ((CampoBanco)cb).setMascara(StringUtil.getValor(atributos, "mascara"));
                }
                if (o instanceof Texto) {
                    Texto t = (Texto)o;
                    t.setQuebrarPalavras(StringUtil.getBoolean(atributos, "quebrarPalavras"));
                    t.setCampoBanco(StringUtil.getValor(atributos, "nomeCampo"));
                    t.setBordas(new Bordas().setAtributos(StringUtil.getValor(atributos, "bordas")));
                }
                if (o instanceof Imagem) {
                    Imagem i = (Imagem)o;
                    i.setAlinhamentoHorizontal(StringUtil.getInt(atributos, "alinhamentoHorizontal"));
                    i.setAlinhamentoVertical(StringUtil.getInt(atributos, "alinhamentoVertical"));
                    i.setEstender(StringUtil.getBoolean(StringUtil.getValor(atributos, "estender")));
                    i.setCampoBanco(StringUtil.getValor(atributos, "nomeCampo"));
                    i.setExpressao(StringUtil.getValor(atributos, "expressao"));
                    i.setCondicao(StringUtil.getValor(atributos, "condicao"), StringUtil.getValor(atributos, "imagem"));
                    i.setBordas(new Bordas().setAtributos(StringUtil.getValor(atributos, "bordas")));
                    i.setImagem(StringUtil.getValor(atributos, "imagem"));
                }
                if (o instanceof CodigoBarras) {
                    cb = (CodigoBarras)o;
                    ((jalis.util.barras.CodigoBarras)((Object)cb)).setPreencherZero(StringUtil.getInt(atributos, "preencherZero"));
                    ((jalis.util.barras.CodigoBarras)((Object)cb)).setFormato(StringUtil.getInt(atributos, "formato"));
                    ((CodigoBarras)cb).setCampoBanco(StringUtil.getValor(atributos, "nomeCampo"));
                    ((CodigoBarras)cb).setBordas(new Bordas().setAtributos(StringUtil.getValor(atributos, "bordas")));
                    ((jalis.util.barras.CodigoBarras)((Object)cb)).setAlinhamentoHorizontal(StringUtil.getInt(atributos, "alinhamentoHorizontal"));
                }
                if (o instanceof Expressao) {
                    Expressao exp = (Expressao)o;
                    exp.setQuebrarLinhas(StringUtil.getBoolean(atributos, "quebrarLinhas"));
                    exp.setQuebrarPalavras(StringUtil.getBoolean(atributos, "quebrarPalavras"));
                    exp.setExpressao(StringUtil.getValor(atributos, "expressao"));
                    exp.setMascara(StringUtil.getValor(atributos, "mascara"));
                }
                if (o instanceof Forma) {
                    Forma forma = (Forma)o;
                    forma.setTipo(StringUtil.getInt(atributos, "tipo"));
                    forma.setCorLinha(StringUtil.getColor(atributos, "corLinha"));
                    forma.setCorPreenchimento(StringUtil.getColor(atributos, "corPreenchimento"));
                    forma.setAlinhamentoHorizontal(StringUtil.getInt(atributos, "alinhamentoHorizontal"));
                    forma.setAlinhamentoVertical(StringUtil.getInt(atributos, "alinhamentoVertical"));
                    forma.setEspessura(StringUtil.getInt(atributos, "espessura"));
                }
                if (o instanceof CodigoQRCode) {
                    CodigoQRCode codigoQRCode = (CodigoQRCode)o;
                    codigoQRCode.setExpressao(StringUtil.getValor(atributos, "expressao"));
                    codigoQRCode.setBordas(new Bordas().setAtributos(StringUtil.getValor(atributos, "bordas")));
                }
                return item;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "BandaFactory: 101");
        }
        return null;
    }

    public static List<ItemBanda> novosItemBanda(String atributos) {
        ArrayList<ItemBanda> itens = new ArrayList<ItemBanda>();
        for (String item : StringUtil.getValores(atributos, "itemBanda")) {
            itens.add(BandaFactory.novoItemBanda(item));
        }
        return BandaFactory.ligarExpressoes(itens);
    }

    private static List<ItemBanda> ligarExpressoes(List<ItemBanda> itens) {
        HashMap<String, Expressao> exps = new HashMap<String, Expressao>();
        for (ItemBanda item : itens) {
            if (!(item instanceof Expressao)) continue;
            exps.put(item.getNome().toLowerCase(), (Expressao)item);
        }
        for (Expressao exp : exps.values()) {
            for (String ident : Token.getIdentificadores(new Lexico(exp.getExpressao(), 8))) {
                Expressao tmp = (Expressao)exps.get(ident.toLowerCase());
                if (tmp == null) continue;
                tmp.addExpressaoListener(exp);
            }
        }
        return itens;
    }

    public static Banda novaBanda(String atributos) {
        Banda banda = new Banda();
        banda.setTipo(StringUtil.getInt(atributos, "tipoBanda"));
        banda.setNome(StringUtil.getValor(atributos, "nome"));
        banda.setAltura(StringUtil.getFloat(atributos, "altura"));
        banda.setCampoChave(StringUtil.getValor(atributos, "campoChave"));
        banda.setNomeBandaFilha(StringUtil.getValor(atributos, "nomeBandaFilha"));
        banda.setNomeBandaRodapeGrupo(StringUtil.getValor(atributos, "nomeBandaRodapeGrupo"));
        banda.setItens(BandaFactory.novosItemBanda(StringUtil.getValor(atributos, "itens")));
        banda.setQuebrarPagina(StringUtil.getBoolean(atributos, "quebrarPagina"));
        if (banda.getTipo() == 2) {
            banda.setColunas(StringUtil.getInt(atributos, "colunas"));
            banda.setEntreColunas(StringUtil.getInt(atributos, "entreColunas"));
        }
        return banda;
    }

    public static Banda[] novasBandas(String atributos) {
        ArrayList<Banda> bandas = new ArrayList<Banda>();
        for (String banda : StringUtil.getValores(atributos, "banda")) {
            bandas.add(BandaFactory.novaBanda(banda));
        }
        return bandas.toArray(new Banda[bandas.size()]);
    }

    public static ArrayList<Rectangle> calcularPosicaoColunas(int qtdeColunas, int entreColunas, Rectangle dimensoesBanda) {
        ArrayList<Rectangle> posicaoColunas = new ArrayList<Rectangle>();
        if (qtdeColunas > 0) {
            Rectangle r = dimensoesBanda;
            int cadaColuna = r.width / qtdeColunas;
            for (int i = 1; i < qtdeColunas; ++i) {
                int xColuna = r.x + cadaColuna * i - entreColunas / 2;
                posicaoColunas.add(new Rectangle(xColuna, r.y, entreColunas, r.height));
            }
        }
        return posicaoColunas;
    }
}

