/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador.item;

import jalis.relatorio.gerador.item.ItemBanda;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Banda {
    public static final int CABECALHO_PAGINA = 0;
    public static final int CABECALHO_GRUPO = 1;
    public static final int DETALHE = 2;
    public static final int RODAPE_GRUPO = 3;
    public static final int SUMARIO = 4;
    public static final int RODAPE_PAGINA = 5;
    private static final Map<String, Banda> instancias = new HashMap<String, Banda>();
    private int tipo = 0;
    private String filha;
    private String rodapeGrupo;
    private String chave = "";
    private String nome = "";
    private float altura = 0.0f;
    private int entreColunas = 0;
    private int colunas = 0;
    private boolean quebrarPagina = false;
    private ArrayList<Rectangle> posicaoColunas = new ArrayList();
    private List<ItemBanda> itens = new ArrayList<ItemBanda>();

    public void setTipo(int tipo) {
        this.tipo = tipo;
    }

    public int getTipo() {
        return this.tipo;
    }

    public void setCampoChave(String campo) {
        this.chave = campo;
    }

    public String getCampoChave() {
        return this.chave;
    }

    public void setNome(String nome) {
        if (instancias.containsKey(this.nome)) {
            instancias.remove(this.nome);
        }
        this.nome = nome;
        instancias.put(nome, this);
    }

    public String getNome() {
        return this.nome;
    }

    public void setAltura(float altura) {
        this.altura = altura;
    }

    public float getAltura() {
        return this.altura;
    }

    public void setNomeBandaFilha(String filha) {
        this.filha = filha;
    }

    public String getNomeBandaFilha() {
        return this.filha;
    }

    public Banda getBandaFilha() {
        return instancias.get(this.filha);
    }

    public void setNomeBandaRodapeGrupo(String rodapeGrupo) {
        this.rodapeGrupo = rodapeGrupo;
    }

    public String getNomeBandaRodapeGrupo() {
        return this.rodapeGrupo;
    }

    public Banda getBandaRodapeGrupo() {
        return instancias.get(this.rodapeGrupo);
    }

    public void setItens(List<ItemBanda> itens) {
        this.itens = itens;
        for (ItemBanda item : itens) {
            item.setDono(this);
        }
    }

    public List<ItemBanda> getItens() {
        return this.itens;
    }

    public String toString() {
        switch (this.tipo) {
            case 0: {
                return "Cabe\u00e7alho de P\u00e1gina";
            }
            case 1: {
                return "Cabe\u00e7alho de Grupo";
            }
            case 2: {
                return "Detalhe";
            }
            case 3: {
                return "Rodap\u00e9 de Grupo";
            }
            case 4: {
                return "Sum\u00e1rio";
            }
            case 5: {
                return "Rodap\u00e9 de P\u00e1gina";
            }
        }
        return "";
    }

    public void setQuebrarPagina(boolean quebrar) {
        this.quebrarPagina = quebrar;
    }

    public boolean getQuebrarPagina() {
        return this.quebrarPagina;
    }

    public static void limparTabelaEstatica() {
        instancias.clear();
    }

    public static void removerBandaTabelaEstatica(String nomeBanda) {
        instancias.remove(nomeBanda);
    }

    public int getEntreColunas() {
        return this.entreColunas;
    }

    public void setEntreColunas(int entreColunas) {
        this.entreColunas = entreColunas;
    }

    public int getColunas() {
        return this.colunas;
    }

    public void setColunas(int colunas) {
        this.colunas = colunas;
    }

    public ArrayList<Rectangle> getPosicaoColunas() {
        return this.posicaoColunas;
    }

    public void setPosicaoColunas(ArrayList<Rectangle> posicaoColunas) {
        this.posicaoColunas = posicaoColunas;
    }
}

