/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador;

import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.relatorio.gerador.Escopo;
import jalis.relatorio.gerador.Registro;
import jalis.relatorio.gerador.Registros;
import jalis.relatorio.gerador.item.Banda;
import jalis.relatorio.gerador.item.BandaFactory;
import jalis.relatorio.gerador.item.CampoBanco;
import jalis.relatorio.gerador.item.Expressao;
import jalis.relatorio.gerador.item.Imagem;
import jalis.relatorio.gerador.item.ItemBanda;
import jalis.relatorio.gerador.item.ItemImpressao;
import jalis.relatorio.gerador.item.ItemValor;
import jalis.relatorio.gerador.item.Label;
import jalis.relatorio.gerador.item.Texto;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.expressao.parser.Sintatico;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.table.TableModel;

public class Relatorio
implements Printable,
Serializable {
    public static final float ZOOM_25 = 0.25f;
    public static final float ZOOM_50 = 0.5f;
    public static final float ZOOM_75 = 0.75f;
    public static final float ZOOM_100 = 1.0f;
    public static final float ZOOM_125 = 1.25f;
    public static final float ZOOM_150 = 1.5f;
    public static final float ZOOM_175 = 1.75f;
    public static final float ZOOM_200 = 2.0f;
    public static final float ZOOM_225 = 2.25f;
    public static final float ZOOM_250 = 2.5f;
    public static final float ZOOM_275 = 2.75f;
    public static final float ZOOM_300 = 3.0f;
    private Banda cabecalho;
    private Banda corpo;
    private Banda sumario;
    private Banda rodape;
    private List<List<ItemImpressao>> gerado;
    private List<ItemImpressao> pagina;
    private Registros dados;
    private Registro ultimoRegistro;
    private Escopo escopoRelatorio;
    private Escopo escopoPagina;
    private int qtdePaginas;
    private int pagCorrente;
    private boolean flagCabecalho;
    private HashPrintRequestAttributeSet atributosImp;
    private HashDocAttributeSet atributosDoc;
    private Map<String, Object> vars;
    private Dimension tamanho;
    private Dimension tamanhoPaginaPreview;
    private PageFormat formatoPagina;
    private int copias = 1;
    private boolean isCabecalhoRodape = false;
    private int intervaloPagIni;
    private int intervaloQtde;
    private float margemEsquerda = 0.0f;
    private float margemSuperior = 0.0f;
    private float margemDireita = 0.0f;
    private float margemInferior = 0.0f;
    private float alturaPagina = 0.0f;
    private float alturaCorpo = 0.0f;
    private float alturaLivre = 0.0f;
    private float alturaAreaImpressao = 0.0f;
    private float yCorpo = 0.0f;
    private float yAtual = 0.0f;
    private float larguraPagina;
    private int casas = 2;
    private RoundingMode round = RoundingMode.HALF_UP;

    public Relatorio(TableModel tabela) {
        this(tabela, null, 2, RoundingMode.HALF_UP);
    }

    public Relatorio(TableModel tabela, Map<String, Object> variaveis, int casas, RoundingMode round) {
        this.casas = casas;
        this.round = round;
        this.vars = this.getMinusculas(variaveis);
        this.dados = new Registros(tabela);
        this.gerado = new ArrayList<List<ItemImpressao>>();
        this.pagina = new ArrayList<ItemImpressao>();
        this.escopoRelatorio = new Escopo();
        this.escopoPagina = new Escopo();
        this.atributosImp = new HashPrintRequestAttributeSet();
        this.atributosDoc = new HashDocAttributeSet();
        this.formatoPagina = new PageFormat();
        this.tamanho = new Dimension();
        this.tamanhoPaginaPreview = new Dimension();
        Banda.limparTabelaEstatica();
    }

    public void setConfiguracao(String xml) {
        this.carregarItens(StringUtil.getValor(xml, "relatorio"));
    }

    public void setConfiguracaoeExame(String xml) {
        this.carregarItens(StringUtil.getValor(xml, "exame"));
    }

    @Deprecated
    public HashPrintRequestAttributeSet getAtributosImpressora() {
        return this.atributosImp;
    }

    @Deprecated
    public HashDocAttributeSet getAtributosDocumento() {
        return this.atributosDoc;
    }

    public PageFormat getFormatoPagina() {
        return this.formatoPagina;
    }

    public Dimension getTamanho() {
        return this.tamanho;
    }

    public Dimension getTamanhoPaginaPreview() {
        return this.tamanhoPaginaPreview;
    }

    private void carregarItens(String xml) {
        Paper paper;
        float w = StringUtil.getFloat(xml, "larguraPagina") * 10.0f;
        float h = StringUtil.getFloat(xml, "alturaPagina") * 10.0f;
        this.larguraPagina = ScreenUtil.getPixelsDeMilimetros(w);
        float alturaPaginaPixels = ScreenUtil.getPixelsDeMilimetros(h);
        String tmp = StringUtil.getValor(xml, "margens");
        float mE = StringUtil.getFloat(tmp, "esquerda") * 10.0f;
        float mD = StringUtil.getFloat(tmp, "direita") * 10.0f;
        float mS = StringUtil.getFloat(tmp, "superior") * 10.0f;
        float mI = StringUtil.getFloat(tmp, "inferior") * 10.0f;
        this.margemEsquerda = ScreenUtil.getPixelsDeMilimetros(mE);
        this.margemSuperior = ScreenUtil.getPixelsDeMilimetros(mS);
        this.margemDireita = ScreenUtil.getPixelsDeMilimetros(mD);
        this.margemInferior = ScreenUtil.getPixelsDeMilimetros(mI);
        this.alturaAreaImpressao = ScreenUtil.getPixelsDeMilimetros(h - mS - mI);
        boolean forcarRetrato = StringUtil.getBoolean(xml, "forcarRetrato");
        if (w > h && !forcarRetrato) {
            this.tamanho = new Dimension((int)ScreenUtil.getPixelsDeMilimetros(h), (int)ScreenUtil.getPixelsDeMilimetros(w));
            this.tamanhoPaginaPreview = new Dimension((int)ScreenUtil.getPixelsDeMilimetros(w), (int)ScreenUtil.getPixelsDeMilimetros(h));
            this.formatoPagina = new PageFormat();
            this.formatoPagina.setOrientation(0);
            paper = this.formatoPagina.getPaper();
            paper.setSize(this.larguraPagina, alturaPaginaPixels);
            paper.setImageableArea(0.0, 0.0, this.larguraPagina, alturaPaginaPixels);
            this.formatoPagina.setPaper(paper);
            this.atributosImp.add(OrientationRequested.LANDSCAPE);
            MediaSizeName ms = MediaSize.findMedia(h, w, 1000);
            if (ms != null) {
                this.atributosDoc.add(ms);
            } else {
                this.atributosDoc.add(MediaSize.findMedia(w + 25.0f, h, 1000));
            }
            this.atributosDoc.add(new MediaPrintableArea(mS, mE, h - mS - mI, w - mE - mD, 1000));
        } else {
            this.tamanho = new Dimension((int)ScreenUtil.getPixelsDeMilimetros(w), (int)ScreenUtil.getPixelsDeMilimetros(h));
            this.tamanhoPaginaPreview = new Dimension((int)ScreenUtil.getPixelsDeMilimetros(w), (int)ScreenUtil.getPixelsDeMilimetros(h));
            paper = new Paper();
            paper.setSize(this.larguraPagina, alturaPaginaPixels);
            paper.setImageableArea(this.margemSuperior, this.margemEsquerda, this.larguraPagina - this.margemEsquerda - this.margemDireita, alturaPaginaPixels - this.margemSuperior - this.margemInferior);
            this.formatoPagina = new PageFormat();
            this.formatoPagina.setOrientation(1);
            this.formatoPagina.setPaper(paper);
        }
        boolean obteveCorpo = false;
        for (Banda banda : BandaFactory.novasBandas(StringUtil.getValor(xml, "bandas"))) {
            if (banda.getTipo() == 0) {
                this.cabecalho = banda;
                continue;
            }
            if (!(obteveCorpo || banda.getTipo() != 1 && banda.getTipo() != 2)) {
                obteveCorpo = true;
                this.corpo = banda;
                continue;
            }
            if (banda.getTipo() == 4) {
                this.sumario = banda;
                continue;
            }
            if (banda.getTipo() != 5) continue;
            this.rodape = banda;
        }
    }

    private MediaSizeName getMediaSizeNameMaisProximo(float height, float width) {
        return MediaSizeName.ISO_A4;
    }

    public void setCopias(int copias) {
        this.copias = copias;
        if (copias > 0) {
            this.atributosImp.add(new Copies(copias));
        }
    }

    public int getCopias() {
        return this.copias;
    }

    public void setIntervaloImpressao(int pagInicial, int pagFinal) {
        if (pagInicial > 0 && pagFinal >= pagInicial) {
            this.intervaloPagIni = pagInicial - 1;
            this.intervaloQtde = pagFinal - pagInicial + 1;
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int index) {
        Graphics2D g2 = (Graphics2D)g;
        if (Funcoes.isLinux()) {
            double x = 0.0;
            double y = 0.0;
            String tmp = ParametrosLocais.getParametro("calibragemX");
            if (StringUtil.validaDouble(tmp)) {
                x = Double.parseDouble(tmp);
            }
            if (StringUtil.validaDouble(tmp = ParametrosLocais.getParametro("calibragemY"))) {
                y = Double.parseDouble(tmp);
            }
            g2.translate(x, y);
        }
        return this.pintar(g2, index);
    }

    int pintar(Graphics2D g2, int indice) {
        if (this.qtdePaginas == 0) {
            this.gerarRelatorio();
        }
        if (indice >= this.qtdePaginas || this.intervaloQtde > 0 && indice > this.intervaloQtde - 1 || this.intervaloPagIni + this.intervaloQtde > this.qtdePaginas) {
            return 1;
        }
        if (this.gerado.size() > 0) {
            this.pintarPagina(g2, indice + this.intervaloPagIni);
        }
        return 0;
    }

    public void pintarPagina(Graphics2D g2, int indice) {
        g2.translate(this.margemEsquerda, this.margemSuperior);
        for (ItemImpressao item : this.getItensDaPagina(indice)) {
            Point pt = item.getPosicao();
            g2.setClip(item.getClip());
            g2.translate(pt.x, pt.y);
            item.pintar(g2);
            g2.translate(-pt.x, -pt.y);
        }
        g2.translate(-this.margemEsquerda, -this.margemSuperior);
    }

    public List<ItemImpressao> getItensDaPagina(int pagina) {
        if (pagina > -1 && pagina < this.gerado.size()) {
            return this.gerado.get(pagina);
        }
        return new ArrayList<ItemImpressao>();
    }

    public int getQuantidadePaginas() {
        return this.qtdePaginas;
    }

    public void removerBandaCabecalhoGrupo(String nomeBanda) {
        if (this.corpo.getTipo() == 1 && this.corpo.getNome().equalsIgnoreCase(nomeBanda)) {
            Banda.removerBandaTabelaEstatica(this.corpo.getNome());
            Banda.removerBandaTabelaEstatica(this.corpo.getNomeBandaRodapeGrupo());
            this.corpo = this.corpo.getBandaFilha();
        } else {
            Banda banda;
            Banda pai = this.corpo;
            while ((banda = pai.getBandaFilha()) != null) {
                if (banda.getTipo() == 1 && banda.getNome().equalsIgnoreCase(nomeBanda)) {
                    Banda.removerBandaTabelaEstatica(banda.getNome());
                    Banda.removerBandaTabelaEstatica(banda.getNomeBandaRodapeGrupo());
                    pai.setNomeBandaFilha(banda.getNomeBandaFilha());
                    break;
                }
                pai = banda;
            }
        }
    }

    public void gerarRelatorio() {
        this.alturaPagina = (int)this.alturaAreaImpressao;
        this.alturaCorpo = this.alturaPagina - this.getAltura(this.cabecalho) - this.getAltura(this.rodape);
        if (this.getAltura(this.corpo) > this.alturaCorpo) {
            this.corpo.setAltura(this.alturaCorpo);
        }
        this.calcularPaginas(this.corpo, this.dados);
        this.escopoPagina.limpar();
        this.escopoPagina.addVariavel("quantidadePaginas", new Integer(this.qtdePaginas));
        this.escopoPagina.addVariavel("dataHoraCorrente", new Date());
        this.escopoPagina.addVariavel("paginaCorrente", new Integer(1));
        this.escopoPagina.addVariavel("usuarioLogado", Variaveis.login);
        this.escopoPagina.addVariavel("nomeUsuarioLogado", Variaveis.nomeUsuario);
        this.escopoPagina.addVariavel("codigoFilialImpressao", Variaveis.filialPadrao);
        this.escopoPagina.addVariavel("descricaoFilialImpressao", Variaveis.descricaoFilialPadrao);
        this.escopoRelatorio.limpar();
        this.escopoRelatorio.addVariavel("quantidadePaginas", new Integer(this.qtdePaginas));
        this.escopoRelatorio.addVariavel("dataHoraCorrente", new Date());
        this.escopoRelatorio.addVariavel("paginaCorrente", new Integer(1));
        this.escopoRelatorio.addVariavel("usuarioLogado", Variaveis.login);
        this.escopoRelatorio.addVariavel("nomeUsuarioLogado", Variaveis.nomeUsuario);
        this.escopoPagina.addVariavel("codigoFilialImpressao", Variaveis.filialPadrao);
        this.escopoPagina.addVariavel("descricaoFilialImpressao", Variaveis.descricaoFilialPadrao);
        this.alturaLivre = this.alturaCorpo;
        this.pagCorrente = 1;
        this.yAtual = this.yCorpo = this.getAltura(this.cabecalho);
        this.flagCabecalho = true;
        this.gerado.clear();
        this.pagina.clear();
        this.dados.primeiro();
        this.gerarRelatorio(this.corpo, this.dados);
        this.verificaQuebraPagina(this.getAltura(this.sumario), this.dados);
        this.instanciarBanda(this.sumario, this.ultimoRegistro, this.yAtual);
        this.instanciarBanda(this.rodape, this.ultimoRegistro, this.alturaPagina - this.getAltura(this.rodape));
        if (this.pagina.size() > 0) {
            this.gerado.add(new ArrayList<ItemImpressao>(this.pagina));
        }
    }

    private List<ItemBanda> desenharNovosItens(Banda banda, List<ItemBanda> itens, int coluna) {
        ArrayList<ItemBanda> itensNovos = new ArrayList<ItemBanda>();
        banda.setPosicaoColunas(BandaFactory.calcularPosicaoColunas(banda.getColunas(), banda.getEntreColunas(), new Rectangle(0, (int)this.yAtual, (int)(this.larguraPagina - this.margemDireita - this.margemEsquerda), (int)banda.getAltura())));
        for (ItemBanda item : itens) {
            ItemBanda i = item.clone();
            i.setNome(item.getNome() + "_" + String.valueOf(coluna) + "_");
            Point pos = i.getPosicao();
            int p = banda.getColunas() - coluna;
            Rectangle col = banda.getPosicaoColunas().get(p);
            i.setPosicao(new Point(pos.x + col.x + col.width, pos.y));
            i.setDono(banda);
            itensNovos.add(i);
        }
        return itensNovos;
    }

    private void gerarRelatorio(Banda banda, Registros regs) {
        block7: {
            float altura;
            block8: {
                if (banda == null) break block7;
                altura = this.getAltura(banda);
                if (banda.getTipo() != 2) break block8;
                if (this.flagCabecalho) {
                    this.instanciarBanda(this.cabecalho, regs.getRegistro(), 0.0f);
                    this.flagCabecalho = false;
                }
                while (!regs.finalRegistros()) {
                    Registro reg = regs.getRegistro();
                    this.verificaQuebraPagina(altura, regs);
                    this.instanciarBanda(banda, reg, this.yAtual);
                    if (banda.getColunas() > 1) {
                        List<ItemBanda> itensOriginais = banda.getItens();
                        for (int i = 2; i <= banda.getColunas() && !regs.finalRegistros(); ++i) {
                            this.ultimoRegistro = reg;
                            regs.proximo();
                            if (regs.finalRegistros()) continue;
                            reg = regs.getRegistro();
                            List<ItemBanda> tmp = this.desenharNovosItens(banda, itensOriginais, i);
                            this.atualizarItens(reg, this.escopoRelatorio, tmp);
                            for (ItemBanda item : tmp) {
                                this.pagina.add(item.getItemImpressao(this.yAtual));
                            }
                        }
                    }
                    this.yAtual += altura;
                    this.alturaLivre -= altura;
                    this.ultimoRegistro = reg;
                    if (regs.finalRegistros()) continue;
                    regs.proximo();
                }
                break block7;
            }
            if (banda.getTipo() != 1) break block7;
            float alturaRodape = this.getAltura(banda.getBandaRodapeGrupo());
            int contadorGrupo = 0;
            for (Registros grupo : regs.getGrupos(banda.getCampoChave())) {
                Registro reg = grupo.getRegistro();
                if (banda.getQuebrarPagina() && ++contadorGrupo > 1) {
                    this.quebrarPagina(regs);
                }
                this.escopoRelatorio = this.escopoRelatorio.abrirEscopo();
                this.verificaQuebraPagina(altura, regs);
                this.instanciarBanda(banda, reg, this.yAtual);
                this.yAtual += altura;
                this.alturaLivre -= altura;
                this.gerarRelatorio(banda.getBandaFilha(), grupo);
                this.verificaQuebraPagina(alturaRodape, regs);
                this.instanciarBanda(banda.getBandaRodapeGrupo(), this.ultimoRegistro, this.yAtual);
                this.escopoRelatorio = this.escopoRelatorio.fecharEscopo();
                this.yAtual += alturaRodape;
                this.alturaLivre -= alturaRodape;
            }
        }
    }

    private void verificaQuebraPagina(float altura, Registros reg) {
        if ((int)altura > (int)this.alturaLivre) {
            this.quebrarPagina(reg);
        }
    }

    private void quebrarPagina(Registros regs) {
        this.instanciarBanda(this.rodape, this.ultimoRegistro, this.alturaPagina - this.getAltura(this.rodape));
        this.gerado.add(new ArrayList<ItemImpressao>(this.pagina));
        this.pagina.clear();
        this.escopoPagina.limpar();
        this.escopoPagina.addVariavel("paginaCorrente", new Integer(++this.pagCorrente));
        this.escopoRelatorio.addVariavel("paginaCorrente", new Integer(this.pagCorrente));
        Registro registro = regs.getRegistro();
        if (this.pagCorrente > 1 && (registro = regs.getRegistro(this.ultimoRegistro.posicaoAtual() + 1)) == null) {
            registro = this.ultimoRegistro;
        }
        this.instanciarBanda(this.cabecalho, registro, 0.0f);
        this.yAtual = this.yCorpo;
        this.alturaLivre = this.alturaCorpo;
    }

    private void instanciarBanda(Banda banda, Registro reg, float yOffset) {
        if (banda != null && reg != null) {
            Escopo esc = this.escopoRelatorio;
            this.isCabecalhoRodape = false;
            if (banda.getTipo() == 0 || banda.getTipo() == 5) {
                esc = this.escopoPagina;
                this.isCabecalhoRodape = true;
            }
            this.atualizarItens(banda, reg, esc);
            this.adicionarDadosEscopo(banda, reg);
            for (ItemBanda item : banda.getItens()) {
                Label label;
                if (item instanceof Texto) {
                    if (((Texto)item).getText().contains("<html>")) {
                        label = new Label();
                        label.setText(((Texto)item).getText());
                        if (label.getText() == null || label.getText().trim().length() == 0) {
                            label.setText("\u00a0");
                        }
                        label.setBordas(((Texto)item).getBordas());
                        label.setBounds(((Texto)item).getBounds());
                        label.setFont(((Texto)item).getFont());
                        label.setCorDaFonte(((Texto)item).getForeground());
                        item = label;
                    }
                } else if (item instanceof CampoBanco) {
                    if (((CampoBanco)item).getTexto().contains("<html>")) {
                        label = new Label();
                        Label label2 = new Label();
                        label2.setText(((CampoBanco)item).getTexto().replace("<html>", "").replace("</html>", ""));
                        label.setText("<html>" + label2.getText() + "</html>");
                        if (label.getText() == null || label.getText().trim().length() == 0) {
                            label.setText("\u00a0");
                        }
                        label.setBordas(((CampoBanco)item).getBordas());
                        label.setBounds(((CampoBanco)item).getDimensoes());
                        label.setFont(((CampoBanco)item).getFonte());
                        label.setCorDaFonte(((CampoBanco)item).getCorDaFonte());
                        label.setDono(((CampoBanco)item).getDono());
                        label.setHorizontalAlignment(((CampoBanco)item).getAlinhamentoHorizontal());
                        item = label;
                    }
                } else if (item instanceof Expressao && ((Expressao)item).getTexto().contains("<html>")) {
                    label = new Label();
                    label.setText(((Expressao)item).getTexto());
                    if (label.getText() == null || label.getText().trim().length() == 0) {
                        label.setText("\u00a0");
                    }
                    label.setBordas(((Expressao)item).getBordas());
                    label.setBounds(((Expressao)item).getDimensoes());
                    label.setFont(((Expressao)item).getFonte());
                    label.setCorDaFonte(((Expressao)item).getCorDaFonte());
                    label.setHorizontalAlignment(((Expressao)item).getAlinhamentoHorizontal());
                    item = label;
                }
                this.pagina.add(item.getItemImpressao(yOffset));
            }
        }
    }

    private void adicionarDadosEscopo(Banda banda, Registro reg) {
        HashMap<String, Object> tabela = new HashMap<String, Object>();
        for (ItemBanda item : banda.getItens()) {
            if (!(item instanceof Expressao)) continue;
            Expressao exp = (Expressao)item;
            Object valor = exp.getValor();
            if (valor == null || valor.toString().trim().length() == 0) {
                valor = "\u00a0";
            }
            if (valor == null) continue;
            tabela.put(exp.getNome().toLowerCase(), valor);
        }
        if (banda.getTipo() == 2) {
            for (String col : reg.getColunas()) {
                Object valor = reg.getValor(col);
                if (valor == null || valor.toString().trim().length() == 0) {
                    valor = "\u00a0";
                }
                if (valor == null) continue;
                tabela.put(col, valor);
            }
        }
        if (!tabela.isEmpty()) {
            this.escopoPagina.addTabela(tabela);
            this.escopoRelatorio.addTabela(tabela);
        }
    }

    private void atualizarItens(Registro reg, Escopo escopo, List<ItemBanda> itens) {
        if (itens != null) {
            for (ItemBanda item : itens) {
                if (item instanceof Expressao) {
                    ((Expressao)item).setDados(reg, escopo, this.vars, this.casas, this.round);
                    continue;
                }
                if (!(item instanceof Imagem)) continue;
                ((Imagem)item).setDados(reg, escopo, this.vars);
            }
            for (ItemBanda item : itens) {
                if (item instanceof ItemValor) {
                    Object obj;
                    ItemValor vlr = (ItemValor)((Object)item);
                    if (item instanceof Imagem) {
                        if (((Imagem)vlr).getExpressao() != null && ((Imagem)vlr).getExpressao().length() > 0) {
                            ((Imagem)item).executar(this.casas, this.round);
                        }
                        if (!this.possuiCondicao(item)) continue;
                        ((Imagem)item).executarCondicao(item, this.casas, this.round);
                        continue;
                    }
                    if (vlr.getCampoBanco() == null || vlr.getCampoBanco().length() <= 0) continue;
                    if (reg.contemColuna(vlr.getCampoBanco())) {
                        obj = reg.getValor(vlr.getCampoBanco());
                        vlr.setValor(obj);
                        if (obj != null && obj.toString().trim().length() != 0) continue;
                        vlr.setValor("\u00a0");
                        continue;
                    }
                    if (this.vars == null) continue;
                    obj = this.vars.get(vlr.getCampoBanco());
                    vlr.setValor(obj);
                    if (obj != null && obj.toString().trim().length() != 0) continue;
                    vlr.setValor("\u00a0");
                    continue;
                }
                if (!(item instanceof Expressao)) continue;
                ((Expressao)item).executar();
            }
        }
    }

    private boolean possuiCondicao(ItemBanda item) {
        return !((Imagem)item).getCondicao().equalsIgnoreCase("null") && ((Imagem)item).getCondicao() != null && ((Imagem)item).getCondicao().length() > 0;
    }

    public static HashMap<String, String> getCamposBancoLayout(String layout, HashMap<String, String> camposDisponiveis, HashMap<String, String> camposObrigatorios) {
        HashMap<String, String> camposBanco = new HashMap<String, String>();
        HashMap<String, String> camposObrigatoriosAux = new HashMap<String, String>();
        if (camposObrigatorios != null) {
            for (String key : camposObrigatorios.keySet()) {
                String novaChave = key.toLowerCase();
                novaChave = StringUtil.removeEspacosDuplicados(novaChave.replace(" ", ""));
                camposObrigatoriosAux.put(novaChave, camposDisponiveis.get(key));
            }
        }
        for (String key : camposObrigatoriosAux.keySet()) {
            if (camposBanco.containsKey(key)) continue;
            camposBanco.put(key, (String)camposObrigatoriosAux.get(key));
        }
        HashMap<String, String> campos = new HashMap<String, String>();
        if (camposDisponiveis != null) {
            for (String key : camposDisponiveis.keySet()) {
                String novaChave = key.toLowerCase();
                novaChave = StringUtil.removeEspacosDuplicados(novaChave.replace(" ", ""));
                campos.put(novaChave, camposDisponiveis.get(key));
            }
        }
        for (Banda banda : BandaFactory.novasBandas(StringUtil.getValor(layout, "bandas"))) {
            String campoChave = banda.getCampoChave();
            if (campos.containsKey(campoChave = campoChave.toLowerCase()) && !camposBanco.containsKey(campoChave)) {
                camposBanco.put(campoChave, (String)campos.get(campoChave));
            }
            for (ItemBanda item : banda.getItens()) {
                if (item instanceof ItemValor) {
                    ItemValor vlr = (ItemValor)((Object)item);
                    String nomeCampo = vlr.getCampoBanco();
                    if (nomeCampo == null || nomeCampo.length() <= 0 || !campos.containsKey(nomeCampo = nomeCampo.toLowerCase()) || camposBanco.containsKey(nomeCampo)) continue;
                    camposBanco.put(nomeCampo, (String)campos.get(nomeCampo));
                    continue;
                }
                if (!(item instanceof Expressao)) continue;
                Sintatico s = new Sintatico();
                s.analisar(((Expressao)item).getExpressao());
                ArrayList<String> identificadores = s.getIdentificadores();
                for (String identificador : identificadores) {
                    if (!campos.containsKey(identificador = identificador.toLowerCase()) || camposBanco.containsKey(identificador)) continue;
                    camposBanco.put(identificador, (String)campos.get(identificador));
                }
            }
        }
        return camposBanco;
    }

    public static String getFieldsSelect(HashMap<String, String> campos) {
        if (campos == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        boolean isPrimeiroItem = true;
        for (String campo : campos.keySet()) {
            if (!isPrimeiroItem) {
                buf.append(", ");
            } else {
                isPrimeiroItem = false;
            }
            buf.append(campos.get(campo)).append(" as ").append(campo);
        }
        return buf.toString();
    }

    private void atualizarItens(Banda banda, Registro reg, Escopo escopo) {
        if (banda != null) {
            this.atualizarItens(reg, escopo, banda.getItens());
        }
    }

    private void calcularPaginas(Banda banda, Registros reg) {
        block5: {
            float alturaBanda;
            block6: {
                block4: {
                    if (this.qtdePaginas != 0) break block4;
                    this.qtdePaginas = 1;
                    this.alturaLivre = this.alturaCorpo;
                    reg.primeiro();
                    this.calcularPaginas(banda, reg);
                    this.verificaQuebra(this.getAltura(this.sumario));
                    break block5;
                }
                if (banda == null || reg == null) break block5;
                alturaBanda = this.getAltura(banda);
                if (banda.getTipo() != 2) break block6;
                while (!reg.finalRegistros()) {
                    this.verificaQuebra(alturaBanda);
                    this.alturaLivre -= alturaBanda;
                    reg.proximo();
                    for (int i = 2; i <= banda.getColunas(); ++i) {
                        if (reg.finalRegistros()) continue;
                        reg.proximo();
                    }
                }
                break block5;
            }
            if (banda.getTipo() != 1) break block5;
            float alturaRodape = this.getAltura(banda.getBandaRodapeGrupo());
            int contadorGrupo = 0;
            for (Registros grupo : reg.getGrupos(banda.getCampoChave())) {
                if (banda.getQuebrarPagina() && ++contadorGrupo > 1) {
                    ++this.qtdePaginas;
                    this.alturaLivre = this.alturaCorpo;
                }
                this.verificaQuebra(alturaBanda);
                this.alturaLivre -= alturaBanda;
                this.calcularPaginas(banda.getBandaFilha(), grupo);
                this.verificaQuebra(alturaRodape);
                this.alturaLivre -= alturaRodape;
            }
        }
    }

    private void verificaQuebra(float altura) {
        if ((int)altura > (int)this.alturaLivre) {
            ++this.qtdePaginas;
            this.alturaLivre = this.alturaCorpo;
        }
    }

    private float getAltura(Banda banda) {
        return banda != null ? banda.getAltura() : 0.0f;
    }

    private Map<String, Object> getMinusculas(Map<String, Object> map) {
        if (map != null) {
            HashMap<String, Object> res = new HashMap<String, Object>(map.size());
            for (String key : map.keySet()) {
                res.put(key.toLowerCase(), map.get(key));
            }
            return res;
        }
        return null;
    }

    public Banda getCabecalho() {
        return this.cabecalho;
    }
}

