/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador;

import jalis.relatorio.gerador.Registro;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;

public class Registros
implements Serializable {
    private final List<String> colunas;
    private final TableModel tabela;
    private final int posInicial;
    private final int posFinal;
    private int posCorrente;

    public Registros(TableModel tabela) {
        this.tabela = tabela;
        this.posInicial = 0;
        this.posFinal = tabela.getRowCount() - 1;
        this.posCorrente = 0;
        this.colunas = new ArrayList<String>();
        for (int i = 0; i < tabela.getColumnCount(); ++i) {
            this.colunas.add(tabela.getColumnName(i).toLowerCase());
        }
    }

    private Registros(Registros pai, int posInicial, int posFinal) {
        this.tabela = pai.tabela;
        this.colunas = pai.colunas;
        this.posInicial = posInicial;
        this.posFinal = posFinal;
        this.posCorrente = posInicial;
    }

    public boolean finalRegistros() {
        return this.posCorrente > this.posFinal;
    }

    public String[] getColunas() {
        String[] cols = new String[this.tabela.getColumnCount()];
        for (int i = 0; i < this.tabela.getColumnCount(); ++i) {
            cols[i] = this.tabela.getColumnName(i);
        }
        return cols;
    }

    public void primeiro() {
        this.posCorrente = this.posInicial;
    }

    public void proximo() {
        if (!this.finalRegistros()) {
            ++this.posCorrente;
        }
    }

    public Object getValor(String coluna) {
        int pos;
        if (!this.finalRegistros() && (pos = this.getIndice(coluna)) > -1) {
            return this.tabela.getValueAt(this.posCorrente, pos);
        }
        return null;
    }

    public Registro getRegistro() {
        if (!this.finalRegistros()) {
            return new Reg(this, this.posCorrente);
        }
        return null;
    }

    public Registro getRegistro(int posicao) {
        if (!this.finalRegistros()) {
            this.posCorrente = posicao;
            return this.getRegistro();
        }
        return null;
    }

    public List<Registros> getGrupos(String coluna) {
        ArrayList<Registros> grupos = new ArrayList<Registros>();
        int col = this.getIndice(coluna);
        if (col > -1) {
            Object atual = this.tabela.getValueAt(this.posInicial, col);
            int posIni = this.posInicial;
            int posFin = this.posInicial;
            while (posFin <= this.posFinal) {
                boolean igual = this.iguais(atual, this.tabela.getValueAt(posFin, col));
                if (!igual || posFin == this.posFinal) {
                    grupos.add(new Registros(this, posIni, igual ? posFin : posFin - 1));
                    posIni = posFin;
                    atual = this.tabela.getValueAt(posFin, col);
                }
                if (posFin >= this.posFinal && !igual) continue;
                ++posFin;
            }
        }
        return grupos;
    }

    private boolean iguais(Object a, Object b) {
        if (a != null && b != null) {
            return a.equals(b);
        }
        return a == null && b == null;
    }

    private int getIndice(String nomeColuna) {
        for (int i = 0; i < this.tabela.getColumnCount(); ++i) {
            if (!this.tabela.getColumnName(i).equalsIgnoreCase(nomeColuna)) continue;
            return i;
        }
        return -1;
    }

    private class Reg
    implements Registro {
        private final Registros regs;
        private final int pos;

        public Reg(Registros regs, int pos) {
            this.regs = regs;
            this.pos = pos;
        }

        @Override
        public List<String> getColunas() {
            return this.regs.colunas;
        }

        @Override
        public boolean contemColuna(String coluna) {
            return this.regs.colunas.contains(coluna.toLowerCase());
        }

        @Override
        public Object getValor(String coluna) {
            int col = this.regs.colunas.indexOf(coluna.toLowerCase());
            if (col > -1) {
                Object tmp = this.regs.tabela.getValueAt(this.pos, col);
                return tmp == null ? "" : tmp;
            }
            return "";
        }

        @Override
        public int tamanho() {
            return this.regs.colunas.size();
        }

        @Override
        public int posicaoAtual() {
            return this.pos;
        }
    }
}

