/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador;

import jalis.relatorio.exportacao.ExportaArquivo;
import jalis.relatorio.gerador.DialogoImpressao;
import jalis.relatorio.gerador.Imprimivel;
import jalis.relatorio.gerador.Paginas;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreVisualizacao
extends JPanel
implements ActionListener,
ChangeListener {
    private JToolBar toolBar = ComponenteFactory.novoJToolBar(Color.white, null, true, false, true);
    private JButton buttonImp = this.novoJButton("impressora");
    private JButton buttonExcel = this.novoJButton("excel");
    private JButton buttonExcelOpcao = ComponenteFactory.novoJButton("\u25bc", this, null, null);
    private JButton buttonCSV = this.novoJButton("excel");
    private JButton buttonCSVOpcao = ComponenteFactory.novoJButton("\u25bc", this, null, null);
    private JButton buttonPri = this.novoJButton("primeira");
    private JButton buttonAnt = this.novoJButton("anterior");
    private JButton buttonPro = this.novoJButton("proxima");
    private JButton buttonUlt = this.novoJButton("ultima");
    private JButton buttonZoomMais = this.novoJButton("zoomMais");
    private JButton buttonZoomMenos = this.novoJButton("zoomMenos");
    private JButton buttonFechar = ComponenteFactory.novoJButton(this, null, null, this.imagem("fechar"), this.imagem("fechar"), null, true);
    private JLabel labelPaginas = new JLabel();
    private JLabel labelZoom = new JLabel();
    private JPopupMenu menuExcel = new JPopupMenu();
    private JMenuItem itemExcelSemCabecalho = new JMenuItem("N\u00e3o exporta dados do cabe\u00e7alho");
    private JMenuItem itemExcelComCabecalho = new JMenuItem("Exportar dados do cabe\u00e7alho");
    private JPopupMenu menuCSV = new JPopupMenu();
    private JMenuItem itemCSVSemCabecalho = new JMenuItem("N\u00e3o exporta dados do cabe\u00e7alho");
    private JMenuItem itemCSVComCabecalho = new JMenuItem("Exportar dados do cabe\u00e7alho");
    private String impressoraSel = Funcoes.getImpressoraPadrao();
    private Runnable acaoFechar;
    private Paginas paginas;
    private Relatorio relatorio;
    private Imprimivel imprimivel;
    private DialogoImpressao digImp;
    private JScrollPane scroll;

    public PreVisualizacao(Imprimivel imp, Relatorio rel) {
        this.setName("PreVisualizacao");
        this.imprimivel = imp;
        this.setLayout(new BorderLayout());
        this.relatorio = rel;
        this.paginas = new Paginas(this, this.relatorio);
        this.scroll = new JScrollPane(this.paginas);
        this.scroll.getViewport().addChangeListener(this);
        this.setIncrementoScroll(50);
        this.add((Component)this.scroll, "Center");
        this.add((Component)this.toolBar, "North");
        this.toolBar.add(this.buttonImp);
        this.buttonImp.setName("buttonImp");
        this.toolBar.add(this.buttonExcel);
        this.buttonExcel.setName("buttonExcel");
        this.buttonExcel.setToolTipText("Exportar relat\u00f3rio para Excel (XLS)");
        this.buttonExcel.setFocusable(false);
        this.buttonExcel.setEnabled(true);
        this.toolBar.add(this.buttonExcelOpcao);
        this.buttonExcelOpcao.setName("btnExcelOpcao");
        this.buttonExcelOpcao.setToolTipText("Op\u00e7\u00f5es de exporta\u00e7\u00e3o Excel (XLS)");
        this.menuExcel.setName("menuExcel");
        this.menuExcel.add(this.itemExcelSemCabecalho);
        this.menuExcel.add(this.itemExcelComCabecalho);
        this.itemExcelSemCabecalho.addActionListener(this);
        this.itemExcelComCabecalho.addActionListener(this);
        this.toolBar.add(this.buttonCSV);
        this.buttonCSV.setName("buttonCSV");
        this.buttonCSV.setToolTipText("Exportar relat\u00f3rio para CSV");
        this.buttonCSV.setFocusable(false);
        this.buttonCSV.setEnabled(true);
        this.buttonCSVOpcao.setName("btnExcelOpcao");
        this.buttonCSVOpcao.setToolTipText("Op\u00e7\u00f5es de exporta\u00e7\u00e3o CSV");
        this.toolBar.add(this.buttonCSVOpcao);
        this.menuCSV.setName("menuCSV");
        this.menuCSV.add(this.itemCSVSemCabecalho);
        this.menuCSV.add(this.itemCSVComCabecalho);
        this.itemCSVSemCabecalho.addActionListener(this);
        this.itemCSVComCabecalho.addActionListener(this);
        this.toolBar.addSeparator(new Dimension(10, 10));
        this.toolBar.add(this.buttonPri);
        this.buttonPri.setName("buttonPri");
        this.toolBar.add(this.buttonAnt);
        this.buttonAnt.setName("buttonAnt");
        this.toolBar.add(this.buttonPro);
        this.buttonPro.setName("buttonPro");
        this.toolBar.add(this.buttonUlt);
        this.buttonUlt.setName("buttonUlt");
        this.toolBar.addSeparator(new Dimension(10, 10));
        this.toolBar.add(this.labelPaginas);
        this.labelPaginas.setName("labelPaginas");
        this.toolBar.addSeparator(new Dimension(10, 10));
        this.toolBar.add(this.buttonZoomMais);
        this.buttonZoomMais.setName("buttonZoomMais");
        this.toolBar.add(this.buttonZoomMenos);
        this.buttonZoomMenos.setName("buttonZoomMenos");
        this.toolBar.addSeparator(new Dimension(10, 10));
        this.toolBar.add(this.labelZoom);
        this.labelZoom.setName("labelZoom");
        this.toolBar.addSeparator(new Dimension(10, 10));
        this.toolBar.add(this.buttonFechar);
        this.buttonFechar.setName("buttonFechar");
        this.buttonImp.setEnabled(true);
        this.habilitarDesabilitar(0, this.paginas.getQuantidadePaginas(), this.paginas.getZoom());
    }

    public void setIncrementoScroll(int qtde) {
        if (this.scroll != null && this.scroll.getVerticalScrollBar() != null) {
            this.scroll.getVerticalScrollBar().setUnitIncrement(qtde);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonExcel) {
            this.exportarExcel(true);
        } else if (o == this.buttonCSV) {
            this.exportarCSV(true);
        } else if (o == this.buttonImp) {
            this.imprimir();
        } else if (o == this.buttonPri) {
            this.paginas.primeira();
        } else if (o == this.buttonPro) {
            this.paginas.proxima();
        } else if (o == this.buttonAnt) {
            this.paginas.anterior();
        } else if (o == this.buttonUlt) {
            this.paginas.ultima();
        } else if (o == this.buttonZoomMais) {
            this.paginas.aumentarZoom();
        } else if (o == this.buttonZoomMenos) {
            this.paginas.diminuirZoom();
        } else if (o == this.buttonFechar) {
            this.fechar();
        } else if (o == this.buttonExcelOpcao) {
            this.menuExcel.show(this.buttonExcelOpcao, 0, 20);
        } else if (o == this.buttonCSVOpcao) {
            this.menuCSV.show(this.buttonCSVOpcao, 0, 20);
        } else if (o == this.itemExcelSemCabecalho) {
            this.exportarExcel(false);
        } else if (o == this.itemExcelComCabecalho) {
            this.exportarExcel(true);
        } else if (o == this.itemCSVSemCabecalho) {
            this.exportarCSV(false);
        } else if (o == this.itemCSVComCabecalho) {
            this.exportarCSV(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object o = e.getSource();
        if (o == this.digImp && this.paginas != null) {
            this.paginas.selecionarPagCorrente(this.digImp.imprimirCorrente());
        } else if (null != this.paginas) {
            int pag = this.paginas.getPaginaCorrente();
            int qtde = this.paginas.getQuantidadePaginas();
            this.habilitarDesabilitar(pag, qtde, this.paginas.getZoom());
            this.atualizarLabel(pag, qtde, this.paginas.getZoom());
        }
    }

    public void setAcaoFechar(Runnable acaoFechar) {
        this.acaoFechar = acaoFechar;
    }

    public void setZoom(float zoom) {
        this.paginas.setZoom(zoom);
    }

    public void atualizarLabel(int pagCorrente, int qtdePag, float zoom) {
        this.labelPaginas.setText(pagCorrente + 1 + "/" + qtdePag);
        this.labelZoom.setText((int)(zoom * 100.0f) + "%");
    }

    public void habilitarDesabilitar(int pagCorrente, int qtdePag, float zoom) {
        this.buttonPri.setEnabled(pagCorrente > 0);
        this.buttonAnt.setEnabled(pagCorrente > 0);
        this.buttonPro.setEnabled(pagCorrente < qtdePag - 1);
        this.buttonUlt.setEnabled(pagCorrente < qtdePag - 1);
        this.buttonZoomMenos.setEnabled(zoom >= 0.5f);
        this.buttonZoomMais.setEnabled(zoom <= 2.75f);
    }

    private void fechar() {
        if (this.acaoFechar != null) {
            this.acaoFechar.run();
        }
    }

    private void imprimir() {
        this.digImp = DialogoImpressao.novaInstancia(this.getTopLevelAncestor(), "Impress\u00e3o de relat\u00f3rio", true);
        if (this.digImp != null && this.imprimivel != null && this.relatorio != null && this.paginas != null) {
            this.digImp.addChangeListener(this);
            this.digImp.setPaginasIntervalo(1, this.paginas.getQuantidadePaginas());
            this.digImp.setImpressoraSelecionada(this.impressoraSel);
            this.digImp.setVisible(true);
            if (this.digImp.ok()) {
                this.impressoraSel = this.digImp.getImpressoraSelecionada();
                this.imprimivel.setImpressora(this.impressoraSel);
                if (this.digImp.getCopias() > 0) {
                    this.relatorio.setCopias(this.digImp.getCopias());
                }
                if (this.digImp.imprimirIntervalo()) {
                    this.relatorio.setIntervaloImpressao(this.digImp.getPaginaInicial(), this.digImp.getPaginaFinal());
                } else if (this.digImp.imprimirCorrente()) {
                    int pagCor = this.paginas.getPaginaCorrente() + 1;
                    this.relatorio.setIntervaloImpressao(pagCor, pagCor);
                }
                this.imprimivel.imprimir(true);
            }
            this.paginas.selecionarPagCorrente(false);
        }
        this.digImp = null;
    }

    private void exportarExcel(boolean exportarDadosDoCabecalho) {
        this.exportarArquivo("XLS", exportarDadosDoCabecalho);
    }

    private void exportarCSV(boolean exportarDadosDoCabecalho) {
        this.exportarArquivo("CSV", exportarDadosDoCabecalho);
    }

    private void exportarArquivo(String extensao, boolean exportarDadosDoCabecalho) {
        String ext;
        JFileChooser fc = ComponenteFactory.novoJFileChooser();
        String descricao = extensao.equals("CSV") ? "Arquivo CSV" : "Microsoft Excel";
        fc.setFileFilter(ComponenteFactory.novoFileFilter(descricao, extensao.toLowerCase()));
        if (fc.showSaveDialog(this.getTopLevelAncestor()) != 0) {
            return;
        }
        String caminhoArquivo = fc.getSelectedFile().getAbsolutePath();
        if (!caminhoArquivo.endsWith(ext = "." + extensao.toLowerCase())) {
            caminhoArquivo = caminhoArquivo + ext;
        }
        try {
            ExportaArquivo exportaArquivo = ExportaArquivo.getExportadorPorExtensao(extensao);
            if (exportaArquivo.gerouArquivo(this.relatorio, caminhoArquivo, exportarDadosDoCabecalho)) {
                Funcoes.mensagem(this, "Arquivo " + extensao + " gerado com sucesso:\n" + caminhoArquivo, 5);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar o arquivo " + extensao + ".\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private JButton novoJButton(String imagem) {
        JButton button = ComponenteFactory.novoJButton(this, null, null, this.imagem(imagem + "Off"), this.imagem(imagem + "Off"), this.imagem(imagem + "Dis"), true);
        button.setBorderPainted(true);
        return button;
    }

    private Icon imagem(String nome) {
        return ImagemUtils.carregaImagemJalis("editor/" + nome + ".jpg");
    }
}

