/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador;

import jalis.relatorio.gerador.PreVisualizacao;
import jalis.relatorio.gerador.Relatorio;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JViewport;

class Paginas
extends JComponent {
    private PreVisualizacao preview;
    private Relatorio rel;
    private float zoom = 1.0f;
    private boolean selPagCorrente;
    private Color corSel = new Color(255, 220, 210);
    private static final float ZOOM_MIN = 0.25f;
    private static final float ZOOM_MAX = 3.0f;
    private static final float SCROLL_MIN = 5.0f;
    private static final float SCROLL_MAX = 23.0f;

    Paginas(PreVisualizacao preview, Relatorio rel) {
        this.preview = preview;
        this.rel = rel;
        if (rel != null && rel.getQuantidadePaginas() == 0) {
            rel.gerarRelatorio();
        }
        this.setBackground(Color.yellow);
        this.redimensionar();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.rel != null) {
            int pagCorrente = this.selPagCorrente ? this.getPaginaCorrente() : 0;
            List<Rectangle> recs = this.getRetangulos();
            Rectangle rec = g.getClipBounds();
            List<Integer> indices = this.getIndicesInterseccao(rec, recs);
            if (!indices.isEmpty()) {
                BufferedImage buf = new BufferedImage(rec.width, rec.height, 2);
                Graphics2D g2 = buf.createGraphics();
                int indice = indices.get(0);
                Rectangle recAux = recs.get(indice);
                int y = indice * recAux.height + (indice + 1) * 15 - rec.y;
                int x = recAux.x - rec.x;
                for (Integer i : indices) {
                    recAux = recs.get(i);
                    g2.setColor(this.selPagCorrente && i == pagCorrente ? this.corSel : Color.white);
                    g2.fillRect(x, y, recAux.width, recAux.height);
                    BufferedImage pag = new BufferedImage(recAux.width, recAux.height, 2);
                    Graphics2D gPag = pag.createGraphics();
                    gPag.scale(this.zoom, this.zoom);
                    this.rel.pintarPagina(gPag, i);
                    g2.drawImage((Image)pag, x, y, null);
                    g2.setColor(Color.black);
                    g2.drawRect(x, y, recAux.width, recAux.height);
                    g2.setColor(Color.darkGray);
                    g2.fillRect(x + recAux.width, y + 3, 2, recAux.height);
                    g2.fillRect(x + 3, y + recAux.height, recAux.width - 1, 3);
                    y += recAux.height + 15;
                }
                g.drawImage(buf, rec.x, rec.y, null);
            }
        }
    }

    public void selecionarPagCorrente(boolean selecionar) {
        if (this.selPagCorrente != selecionar) {
            this.selPagCorrente = selecionar;
            this.repaint();
        }
    }

    public void setZoom(float zoom) {
        if (zoom >= 0.25f && zoom <= 2.75f) {
            this.zoom = zoom;
            this.atualizarZoom();
        }
    }

    public float getZoom() {
        return this.zoom;
    }

    public void aumentarZoom() {
        if (this.zoom <= 2.75f) {
            this.zoom += 0.25f;
            this.atualizarZoom();
        }
    }

    public void diminuirZoom() {
        if (this.zoom >= 0.5f) {
            this.zoom -= 0.25f;
            this.atualizarZoom();
        }
    }

    public void primeira() {
        this.setPaginaCorrente(0);
    }

    public void ultima() {
        this.setPaginaCorrente(this.getQuantidadePaginas() - 1);
    }

    public void proxima() {
        int corrente = this.getPaginaCorrente();
        if (corrente < this.getQuantidadePaginas() - 1) {
            this.setPaginaCorrente(corrente + 1);
        }
    }

    public void anterior() {
        int corrente = this.getPaginaCorrente();
        if (corrente > 0) {
            this.setPaginaCorrente(corrente - 1);
        }
    }

    public void setPaginaCorrente(int pagina) {
        List<Rectangle> recs = this.getRetangulos();
        Rectangle recView = ((JViewport)this.getParent()).getBounds();
        if (pagina > -1 && pagina < recs.size()) {
            Rectangle r = recs.get(pagina);
            this.scrollRectToVisible(new Rectangle(recView.x, r.y - 15, recView.width, recView.height));
            this.preview.habilitarDesabilitar(pagina, this.getQuantidadePaginas(), this.zoom);
            this.preview.atualizarLabel(pagina, this.getQuantidadePaginas(), this.zoom);
        }
    }

    public int getPaginaCorrente() {
        List<Rectangle> recs = this.getRetangulos();
        Rectangle recView = ((JViewport)this.getParent()).getViewRect();
        HashMap<Integer, Rectangle> temp = new HashMap<Integer, Rectangle>();
        for (int i = 0; i < recs.size(); ++i) {
            Rectangle r = recs.get(i);
            if (!recView.intersects(r)) continue;
            temp.put(i, recView.intersection(r));
        }
        int maior = 0;
        int pag = 0;
        for (Integer i : temp.keySet()) {
            Rectangle r = (Rectangle)temp.get(i);
            if (r.height <= maior) continue;
            pag = i;
            maior = r.height;
        }
        return pag;
    }

    public int getQuantidadePaginas() {
        if (this.rel != null) {
            return this.rel.getQuantidadePaginas();
        }
        return 0;
    }

    private void atualizarZoom() {
        this.redimensionar();
        this.revalidate();
        this.repaint();
        this.preview.atualizarLabel(this.getPaginaCorrente(), this.getQuantidadePaginas(), this.zoom);
        float a = 2.75f;
        float b = 18.0f;
        this.preview.setIncrementoScroll((int)((b * (this.zoom - 0.25f) + 5.0f * a) / a));
    }

    private List<Integer> getIndicesInterseccao(Rectangle rec, List<Rectangle> recs) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < recs.size(); ++i) {
            if (!recs.get(i).intersects(rec)) continue;
            indices.add(i);
        }
        return indices;
    }

    private List<Rectangle> getRetangulos() {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        if (this.rel != null) {
            Dimension tam = this.rel.getTamanhoPaginaPreview();
            tam = new Dimension((int)((float)tam.width * this.zoom), (int)((float)tam.height * this.zoom));
            int x = (this.getWidth() - tam.width) / 2;
            int y = 15;
            for (int i = 0; i < this.rel.getQuantidadePaginas(); ++i) {
                list.add(new Rectangle(new Point(x, y), tam));
                y += tam.height + 15;
            }
        }
        return list;
    }

    private void redimensionar() {
        if (this.rel != null) {
            Dimension tam = this.rel.getTamanhoPaginaPreview();
            int qtdePag = this.rel.getQuantidadePaginas();
            int w = (int)((float)tam.width * this.zoom) + 30;
            int h = (int)((float)(tam.height * qtdePag) * this.zoom) + (qtdePag + 1) * 15;
            this.setPreferredSize(new Dimension(w, h));
        }
    }
}

