/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador;

import jalis.comum.ParametrosGerais;
import jalis.relatorio.gerador.Escopo;
import jalis.relatorio.gerador.Registro;
import jalis.relatorio.gerador.item.Expressao;
import jalis.relatorio.gerador.item.ItemBanda;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.expressao.parser.Arvore;
import jalis.util.expressao.parser.ExpUtil;
import jalis.util.expressao.parser.Interpretador;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExecutaExpressao
extends Interpretador {
    private Registro reg;
    private Escopo escopo;
    private Map<String, Object> vars;
    private List<Expressao> irmaos = new ArrayList<Expressao>();
    private int casas = 2;
    private RoundingMode round = RoundingMode.HALF_UP;

    public ExecutaExpressao(List<ItemBanda> irmaos, Registro reg, Escopo escopo, Map<String, Object> variaveis, int casas, RoundingMode round) {
        this.reg = reg;
        this.escopo = escopo;
        this.vars = variaveis;
        this.casas = casas;
        this.round = round;
        for (ItemBanda item : irmaos) {
            if (!(item instanceof Expressao)) continue;
            this.irmaos.add((Expressao)item);
        }
    }

    @Override
    public void setCampos(Object[] campos) {
    }

    @Override
    public void visitarSomatorio(Arvore.Somatorio arvore) {
        BigDecimal soma = BigDecimal.ZERO.setScale(this.casas, this.round);
        if (this.escopo != null) {
            for (Map<String, Object> tab : this.escopo.getTabelas()) {
                Object o = tab.get(arvore.campo);
                if (o == null || !StringUtil.validaNumero(o.toString())) continue;
                soma = soma.add(o == null || Funcoes.textoVazio(o.toString()) ? BigDecimal.ZERO : new BigDecimal(Funcoes.limpaDecimal(o.toString())).setScale(this.casas, this.round));
            }
        }
        soma = soma.setScale(this.casas, this.round);
        arvore.valor = soma;
    }

    @Override
    public void visitarSomatorioAvancado(Arvore.SomatorioAvancado arvore) {
        RoundingMode round = ParametrosGerais.getArredondamentoPrecoExame();
        BigDecimal soma = BigDecimal.ZERO.setScale(arvore.casas, round);
        if (this.escopo != null) {
            for (Map<String, Object> tab : this.escopo.getTabelas()) {
                Object o = tab.get(arvore.campo);
                if (o == null || !StringUtil.validaNumero(o.toString())) continue;
                soma = soma.add(o == null || Funcoes.textoVazio(o.toString()) ? BigDecimal.ZERO : new BigDecimal(Funcoes.limpaDecimal(o.toString())).setScale(arvore.casas, round));
            }
        }
        soma = soma.setScale(arvore.casas, round);
        arvore.valor = soma;
    }

    @Override
    public void visitarMedia(Arvore.Media arvore) {
        Object media = null;
        if (this.escopo != null) {
            int cont = 0;
            for (Map<String, Object> tab : this.escopo.getTabelas()) {
                Object o = tab.get(arvore.campo);
                if (o == null || !StringUtil.validaNumero(o.toString())) continue;
                media = ExpUtil.somar(media, new Float(StringUtil.strDecimal(o.toString())));
                ++cont;
            }
            media = media instanceof Number ? ExpUtil.dividir(media, new Long(cont)) : "";
        }
        arvore.valor = media;
    }

    @Override
    protected Object getValorCampo(String campo) {
        Map<String, Object> variaveis;
        campo = campo.toLowerCase();
        if (this.reg != null && this.reg.contemColuna(campo)) {
            return this.reg.getValor(campo);
        }
        if (this.escopo != null && (variaveis = this.escopo.getVariaveis()).containsKey(campo)) {
            return variaveis.get(campo);
        }
        if (this.vars != null && this.vars.containsKey(campo)) {
            return this.vars.get(campo);
        }
        for (Expressao irmao : this.irmaos) {
            if (!irmao.getNome().equalsIgnoreCase(campo)) continue;
            return irmao.getValor();
        }
        return null;
    }
}

