/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Escopo
implements Serializable {
    private List<Map<String, Object>> lista = new ArrayList<Map<String, Object>>();
    private Map<String, Object> variaveis = new HashMap<String, Object>();
    private Escopo pai = null;

    private Escopo(Escopo pai) {
        this();
        this.pai = pai;
    }

    public Escopo() {
    }

    public void addVariavel(String nome, Object valor) {
        if (nome != null && valor != null) {
            if (this.variaveis.containsKey(nome = nome.toLowerCase())) {
                this.variaveis.remove(nome);
            }
            this.variaveis.put(nome, valor);
        }
    }

    public void removeVariavel(String nome) {
        if (this.variaveis.containsKey(nome)) {
            this.variaveis.remove(nome);
        }
    }

    public Escopo abrirEscopo() {
        return new Escopo(this);
    }

    public Escopo fecharEscopo() {
        if (this.pai != null) {
            for (Map<String, Object> tab : this.getTabelas()) {
                this.pai.addTabela(tab);
            }
        }
        return this.pai;
    }

    public void limpar() {
        this.lista.clear();
    }

    public void addTabela(Map<String, Object> tabela) {
        this.lista.add(tabela);
    }

    public List<Map<String, Object>> getTabelas() {
        ArrayList<Map<String, Object>> tabs = new ArrayList<Map<String, Object>>();
        tabs.addAll(this.lista);
        tabs.add(this.getVariaveis());
        return tabs;
    }

    public List getValores(String nomeCampo) {
        ArrayList<Object> valores = new ArrayList<Object>();
        for (Map<String, Object> tab : this.getTabelas()) {
            if (!tab.containsKey(nomeCampo)) continue;
            valores.add(tab.get(nomeCampo));
        }
        return valores;
    }

    public Map<String, Object> getVariaveis() {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        Escopo parent = this;
        while (parent != null) {
            for (String chave : parent.variaveis.keySet()) {
                tmp.put(chave, parent.variaveis.get(chave));
            }
            parent = parent.pai;
        }
        return tmp;
    }
}

