/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador;

import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.print.PrintServiceLookup;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DialogoImpressao
extends JDialog
implements ActionListener,
FocusListener {
    private JComboBox comboImpressoras = new JComboBox<String>(Funcoes.getNomeImpressorasLocais());
    private JTextField textPagIni = new TTextField(5, 1);
    private JTextField textPagFin = new TTextField(5, 1);
    private JTextField textCopias = new TTextField(2, 1);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JRadioButton radioTodas = ComponenteFactory.novoJRadioButton("Todas", 'T', this, null, null);
    private JRadioButton radioIntervalo = ComponenteFactory.novoJRadioButton("Intervalo:", 'P', this, null, null);
    private JRadioButton radioCorrente = ComponenteFactory.novoJRadioButton("P\u00e1gina corrente", 'c', this, null, null);
    private JLabel labelDe = new JLabel("de");
    private JLabel labelA = new JLabel("a");
    private boolean ok;
    private EventListenerList listenerList = new EventListenerList();

    public static DialogoImpressao novaInstancia(Object pai, String titulo, boolean mostraCampos) {
        if (pai instanceof Frame) {
            return new DialogoImpressao((Frame)pai, titulo, mostraCampos);
        }
        if (pai instanceof Dialog) {
            return new DialogoImpressao((Dialog)pai, titulo, mostraCampos);
        }
        return null;
    }

    public DialogoImpressao(Frame pai, String titulo, boolean mostraCampos) {
        super(pai, titulo, true);
        this.iniciar(mostraCampos);
    }

    public DialogoImpressao(Dialog pai, String titulo, boolean mostraCampos) {
        super(pai, titulo, true);
        this.iniciar(mostraCampos);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonImprimir || o == this.buttonCancelar) {
            this.ok = o == this.buttonImprimir;
            this.dispose();
        } else if (o == this.radioTodas || o == this.radioIntervalo || o == this.radioCorrente) {
            boolean pag = o == this.radioIntervalo;
            this.labelDe.setEnabled(pag);
            this.labelA.setEnabled(pag);
            this.textPagIni.setEnabled(pag);
            this.textPagFin.setEnabled(pag);
            if (pag) {
                ScreenUtil.requisitarFoco(this.textPagIni);
            }
            this.fireStateChanged();
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public boolean imprimirTodas() {
        return this.radioTodas.isSelected();
    }

    public boolean imprimirIntervalo() {
        return this.radioIntervalo.isSelected();
    }

    public boolean imprimirCorrente() {
        return this.radioCorrente.isSelected();
    }

    public void setPaginasIntervalo(int pagIni, int pagFin) {
        if (pagIni > 0 && pagFin >= pagIni) {
            this.textPagIni.setText(String.valueOf(pagIni));
            this.textPagFin.setText(String.valueOf(pagFin));
        }
    }

    public int getPaginaInicial() {
        String num = this.textPagIni.getText();
        return num.matches("\\-?\\d+") ? Integer.parseInt(num) : 0;
    }

    public int getPaginaFinal() {
        String num = this.textPagFin.getText();
        return num.matches("\\-?\\d+") ? Integer.parseInt(num) : 0;
    }

    public int getCopias() {
        String num = this.textCopias.getText();
        return num.matches("\\-?\\d+") ? Integer.parseInt(num) : 0;
    }

    public void setImpressoraSelecionada(String nomeImpressora) {
        this.comboImpressoras.setSelectedItem(nomeImpressora);
    }

    public String getImpressoraSelecionada() {
        return (String)this.comboImpressoras.getSelectedItem();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object o = e.getSource();
        if (o instanceof JTextField) {
            ((JTextField)o).selectAll();
        }
    }

    private void iniciar(boolean mostraCampos) {
        this.selecionarImpressoraPadrao();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(2, 3, 3));
        this.getContentPane().add((Component)panel, "South");
        panel.add(this.buttonImprimir);
        panel.add(this.buttonCancelar);
        panel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panel, "Center");
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 2;
        cons.gridheight = 1;
        cons.weightx = 0.5;
        cons.weighty = 0.0;
        cons.insets = new Insets(1, 1, 1, 1);
        JPanel aux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Impressora"));
        panel.add((Component)aux, cons);
        GridBagConstraints consAux = new GridBagConstraints();
        consAux.fill = 2;
        consAux.gridx = 0;
        cons.gridy = 0;
        consAux.gridwidth = 1;
        consAux.gridheight = 1;
        consAux.weightx = 0.0;
        consAux.weighty = 0.0;
        consAux.insets = new Insets(1, 1, 1, 1);
        aux.add((Component)new JLabel("Nome:"), consAux);
        consAux.gridx = 1;
        consAux.weightx = 0.5;
        aux.add((Component)this.comboImpressoras, consAux);
        if (mostraCampos) {
            cons.gridy = 1;
            cons.gridwidth = 1;
            cons.weighty = 0.5;
            aux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("P\u00e1ginas"));
            panel.add((Component)aux, cons);
            ButtonGroup group = new ButtonGroup();
            group.add(this.radioTodas);
            group.add(this.radioIntervalo);
            group.add(this.radioCorrente);
            consAux.gridx = 0;
            consAux.weightx = 0.5;
            consAux.gridwidth = 5;
            this.radioTodas.setSelected(true);
            aux.add((Component)this.radioTodas, consAux);
            consAux.gridy = 1;
            consAux.weightx = 0.0;
            consAux.gridwidth = 1;
            aux.add((Component)this.radioIntervalo, consAux);
            consAux.gridx = 1;
            consAux.weightx = 0.5;
            this.labelDe.setHorizontalAlignment(0);
            this.labelDe.setEnabled(false);
            aux.add((Component)this.labelDe, consAux);
            consAux.gridx = 2;
            consAux.weightx = 0.0;
            this.textPagIni.setPreferredSize(new Dimension(60, 25));
            this.textPagIni.setEnabled(false);
            this.textPagIni.addFocusListener(this);
            aux.add((Component)this.textPagIni, consAux);
            consAux.gridx = 3;
            consAux.weightx = 0.5;
            this.labelA.setHorizontalAlignment(0);
            this.labelA.setEnabled(false);
            aux.add((Component)this.labelA, consAux);
            consAux.gridx = 4;
            consAux.weightx = 0.0;
            this.textPagFin.setPreferredSize(new Dimension(60, 25));
            this.textPagFin.setEnabled(false);
            this.textPagFin.addFocusListener(this);
            aux.add((Component)this.textPagFin, consAux);
            consAux.gridx = 0;
            consAux.gridy = 2;
            consAux.gridwidth = 5;
            aux.add((Component)this.radioCorrente, consAux);
            cons.gridx = 1;
            cons.weightx = 0.0;
            aux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("C\u00f3pias"));
            panel.add((Component)aux, cons);
            consAux.gridx = 0;
            consAux.gridy = 0;
            consAux.gridwidth = 1;
            consAux.weightx = 0.0;
            aux.add((Component)new JLabel("Quantidade:"), consAux);
            consAux.gridx = 1;
            consAux.weightx = 0.5;
            this.textCopias.setText("1");
            this.textCopias.setPreferredSize(new Dimension(60, 25));
            this.textCopias.addFocusListener(this);
            aux.add((Component)this.textCopias, consAux);
        }
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }

    private void selecionarImpressoraPadrao() {
        String impressoraPadrao = PrintServiceLookup.lookupDefaultPrintService().getName();
        this.comboImpressoras.setSelectedItem(impressoraPadrao);
    }

    private void fireStateChanged() {
        for (ChangeListener ouvintes : (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            ouvintes.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

