/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.gerador;

import jalis.util.StringUtil;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Bordas {
    private boolean[] bordas;

    public Bordas() {
        this(false, false, false, false);
    }

    public Bordas(Bordas bordas) {
        this(bordas.bordas[0], bordas.bordas[1], bordas.bordas[2], bordas.bordas[3]);
    }

    public Bordas(boolean esq, boolean dir, boolean sup, boolean inf) {
        this.bordas = new boolean[]{esq, dir, sup, inf};
    }

    public boolean[] getBordas() {
        return this.bordas;
    }

    public void setBordas(boolean[] bordas) {
        if (bordas != null && bordas.length == 4) {
            this.bordas = bordas;
        }
    }

    public boolean esquerda() {
        return this.bordas[0];
    }

    public boolean direita() {
        return this.bordas[1];
    }

    public boolean superior() {
        return this.bordas[2];
    }

    public boolean inferior() {
        return this.bordas[3];
    }

    public void pintar(Graphics g, Rectangle r) {
        if (g != null && r != null) {
            if (this.bordas[0]) {
                g.drawLine(r.x, r.y, r.x, r.y + r.height);
            }
            if (this.bordas[1]) {
                g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height);
            }
            if (this.bordas[2]) {
                g.drawLine(r.x, r.y, r.x + r.width, r.y);
            }
            if (this.bordas[3]) {
                g.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
            }
        }
    }

    public Bordas setAtributos(String xml) {
        this.bordas[0] = StringUtil.getBoolean(StringUtil.getValor(xml, "esquerda"));
        this.bordas[1] = StringUtil.getBoolean(StringUtil.getValor(xml, "direita"));
        this.bordas[2] = StringUtil.getBoolean(StringUtil.getValor(xml, "superior"));
        this.bordas[3] = StringUtil.getBoolean(StringUtil.getValor(xml, "inferior"));
        return this;
    }

    public String getAtributos() {
        StringBuffer atr = new StringBuffer();
        atr.append(StringUtil.getTag("esquerda", String.valueOf(this.bordas[0])));
        atr.append(StringUtil.getTag("direita", String.valueOf(this.bordas[1])));
        atr.append(StringUtil.getTag("superior", String.valueOf(this.bordas[2])));
        atr.append(StringUtil.getTag("inferior", String.valueOf(this.bordas[3])));
        return atr.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof Bordas) {
            Bordas b = (Bordas)o;
            return this.bordas[0] == b.esquerda() && this.bordas[1] == b.direita() && this.bordas[2] == b.superior() && this.bordas[3] == b.inferior();
        }
        return super.equals(o);
    }
}

