/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.exportacao;

import jalis.relatorio.exportacao.ExportaArquivo;
import jalis.relatorio.exportacao.ExportaRelatorio;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.excel.EscreverArquivoXls;
import java.util.List;
import java.util.Map;

public class ExportaXLS
extends ExportaArquivo {
    @Override
    public boolean gerouArquivo(Relatorio relatorio, String pathParaSalvarArquivo, boolean exportaDadosCabecalho) throws Exception {
        Map<Integer, List<ExportaRelatorio>> paginas = this.carregarPaginas(relatorio, exportaDadosCabecalho);
        if (!paginas.isEmpty()) {
            StringBuilder conteudoArquivoXLS = new StringBuilder();
            for (Map.Entry<Integer, List<ExportaRelatorio>> pagina : paginas.entrySet()) {
                List<ExportaRelatorio> dadosOrdenadosPorTopo = this.organizarListaPorTopo(pagina.getValue());
                List<ExportaRelatorio> ordenadosPorLinha = this.definirOrdemDasLinhas(dadosOrdenadosPorTopo);
                Integer ultimaLinha = this.getUltimaLinha(ordenadosPorLinha);
                for (int i = 1; i <= ultimaLinha; ++i) {
                    List<ExportaRelatorio> dadosNaMesmaLinha = this.ordenarDadosDaMesmaLinha(ordenadosPorLinha, i);
                    StringBuilder linhaArquivo = this.construirLinha(dadosNaMesmaLinha);
                    if (linhaArquivo.length() <= 0 || linhaArquivo.toString().matches(";*")) continue;
                    linhaArquivo.replace(linhaArquivo.length() - 1, linhaArquivo.length(), "");
                    linhaArquivo.append(System.lineSeparator());
                    conteudoArquivoXLS.append(linhaArquivo.toString());
                }
            }
            conteudoArquivoXLS.replace(conteudoArquivoXLS.length() - 1, conteudoArquivoXLS.length(), "");
            return this.salvouArquivo(conteudoArquivoXLS, pathParaSalvarArquivo);
        }
        return false;
    }

    private boolean salvouArquivo(StringBuilder conteudoArquivoXLS, String pathParaSalvarArquivo) throws Exception {
        if (conteudoArquivoXLS.length() > 0) {
            EscreverArquivoXls arquivoXls = new EscreverArquivoXls();
            int aba = arquivoXls.addAba("Planilha 1");
            String[] linhas = conteudoArquivoXLS.toString().split(System.lineSeparator());
            int numLinha = 0;
            for (String linha : linhas) {
                Object[] celulas = linha.split(";");
                arquivoXls.setLinha(aba, numLinha, celulas);
                ++numLinha;
            }
            arquivoXls.ajustarLarguraColunasAutomaticamente();
            arquivoXls.escreverArquivo(pathParaSalvarArquivo);
            return true;
        }
        return false;
    }
}

