/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.exportacao;

import jalis.relatorio.gerador.item.Expressao;
import jalis.relatorio.gerador.item.ItemImpressao;
import jalis.relatorio.gerador.item.Label;
import jalis.relatorio.gerador.item.Rotulo;
import jalis.relatorio.gerador.item.Texto;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.util.Objects;

public class ExportaRelatorio {
    private int coluna = -1;
    private int topo = -1;
    private String texto;
    private Font fonte;
    private Color corDaFonte;
    private int linha;

    private ExportaRelatorio() {
    }

    public static ExportaRelatorio converterItemImpressao(ItemImpressao item) {
        ExportaRelatorio er = new ExportaRelatorio();
        Point pt = item.getPosicao();
        if (item instanceof Rotulo) {
            Rotulo rotulo = (Rotulo)item;
            er.setTexto(ExportaRelatorio.converterSubESuperscript(rotulo.getTexto()));
            er.setFonte(rotulo.getFonte());
            er.setCorDaFonte(rotulo.getCorDaFonte());
            er.setTopo(pt.y);
            er.setColuna(pt.x);
        } else if (item instanceof Texto) {
            Texto texto = (Texto)item;
            er.setTexto(ExportaRelatorio.converterSubESuperscript(texto.getText()));
            er.setFonte(texto.getFont());
            er.setCorDaFonte(texto.getForeground());
            er.setTopo(pt.y);
            er.setColuna(pt.x);
        } else if (item instanceof Label) {
            Label label = (Label)item;
            String texto = label.getText();
            er.setTexto(ExportaRelatorio.converterSubESuperscript(label.getText()));
            er.setFonte(label.getFont());
            er.setCorDaFonte(label.getForeground());
            er.setTopo(pt.y);
            er.setColuna(pt.x);
        } else if (item instanceof Expressao) {
            Expressao expressao = (Expressao)item;
            er.setTexto(ExportaRelatorio.converterSubESuperscript(expressao.getTexto()));
            er.setFonte(expressao.getFonte());
            er.setCorDaFonte(expressao.getCorDaFonte());
            er.setTopo(pt.y);
            er.setColuna(pt.x);
        }
        return er;
    }

    private static String converterSubESuperscript(String texto) {
        if (texto.contains("<html>")) {
            texto = texto.replaceAll("<html>", "");
            texto = texto.replaceAll("</html>", "");
            texto = texto.replaceAll("</sup>", "");
            texto = texto.replaceAll("<sup>", ";");
        }
        return texto;
    }

    public int getColuna() {
        return this.coluna;
    }

    public void setColuna(int coluna) {
        this.coluna = coluna;
    }

    public int getTopo() {
        return this.topo;
    }

    public void setTopo(int linha) {
        this.topo = linha;
    }

    public String getTexto() {
        return this.texto;
    }

    public void setTexto(String texto) {
        this.texto = texto;
    }

    public Font getFonte() {
        return this.fonte;
    }

    public void setFonte(Font fonte) {
        this.fonte = fonte;
    }

    public Color getCorDaFonte() {
        return this.corDaFonte;
    }

    public void setCorDaFonte(Color corDaFonte) {
        this.corDaFonte = corDaFonte;
    }

    public int getLinha() {
        return this.linha;
    }

    public void setLinha(int linha) {
        this.linha = linha;
    }

    public int hashCode() {
        return Objects.hash(this.coluna, this.texto, this.topo);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExportaRelatorio other = (ExportaRelatorio)obj;
        return this.coluna == other.coluna && Objects.equals(this.texto, other.texto) && this.topo == other.topo;
    }

    public String toString() {
        return this.texto;
    }
}

