/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.exportacao;

import jalis.relatorio.exportacao.ExportaArquivo;
import jalis.relatorio.exportacao.ExportaRelatorio;
import jalis.relatorio.gerador.Relatorio;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;

public class ExportaCSV
extends ExportaArquivo {
    @Override
    public boolean gerouArquivo(Relatorio relatorio, String pathParaSalvarArquivo, boolean exportaDadosCabecalho) throws Exception {
        Map<Integer, List<ExportaRelatorio>> paginas = this.carregarPaginas(relatorio, exportaDadosCabecalho);
        StringBuilder conteudoArquivoCSV = new StringBuilder();
        if (!paginas.isEmpty()) {
            for (Map.Entry<Integer, List<ExportaRelatorio>> pagina : paginas.entrySet()) {
                List<ExportaRelatorio> dadosOrdenadosPorTopo = this.organizarListaPorTopo(pagina.getValue());
                List<ExportaRelatorio> ordenadosPorLinha = this.definirOrdemDasLinhas(dadosOrdenadosPorTopo);
                Integer ultimaLinha = this.getUltimaLinha(ordenadosPorLinha);
                for (int i = 1; i <= ultimaLinha; ++i) {
                    List<ExportaRelatorio> dadosNaMesmaLinha = this.ordenarDadosDaMesmaLinha(ordenadosPorLinha, i);
                    StringBuilder linhaArquivo = this.construirLinha(dadosNaMesmaLinha);
                    if (linhaArquivo.length() <= 0 || linhaArquivo.toString().matches(";*")) continue;
                    linhaArquivo.replace(linhaArquivo.length() - 1, linhaArquivo.length(), "");
                    linhaArquivo.append(System.lineSeparator());
                    conteudoArquivoCSV.append(linhaArquivo.toString());
                }
            }
            conteudoArquivoCSV.replace(conteudoArquivoCSV.length() - 1, conteudoArquivoCSV.length(), "");
            if (conteudoArquivoCSV.length() > 0) {
                Files.write(Paths.get(pathParaSalvarArquivo, new String[0]), conteudoArquivoCSV.toString().getBytes(), new OpenOption[0]);
                return true;
            }
        }
        return false;
    }
}

