/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.exportacao;

import jalis.relatorio.exportacao.ExportaCSV;
import jalis.relatorio.exportacao.ExportaRelatorio;
import jalis.relatorio.exportacao.ExportaXLS;
import jalis.relatorio.gerador.Relatorio;
import jalis.relatorio.gerador.item.Banda;
import jalis.relatorio.gerador.item.Expressao;
import jalis.relatorio.gerador.item.ItemBanda;
import jalis.relatorio.gerador.item.ItemImpressao;
import jalis.relatorio.gerador.item.Label;
import jalis.relatorio.gerador.item.Rotulo;
import jalis.relatorio.gerador.item.Texto;
import jalis.util.Funcoes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class ExportaArquivo {
    public static final String EXTENSAO_CSV = "CSV";
    public static final String EXTENSAO_XLS = "XLS";
    protected static final int TOLERANCIA_ENTRE_LINHAS = 4;
    private Banda cabecalho;

    public abstract boolean gerouArquivo(Relatorio var1, String var2, boolean var3) throws Exception;

    protected Map<Integer, List<ExportaRelatorio>> carregarPaginas(Relatorio relatorio, boolean exportaDadosCabecalho) {
        if (!exportaDadosCabecalho) {
            this.cabecalho = relatorio.getCabecalho();
        }
        HashMap<Integer, List<ExportaRelatorio>> paginas = new HashMap<Integer, List<ExportaRelatorio>>();
        for (int p = 0; p < relatorio.getQuantidadePaginas(); ++p) {
            ArrayList<ExportaRelatorio> dadosExportacao = new ArrayList<ExportaRelatorio>();
            List<ItemImpressao> itens = relatorio.getItensDaPagina(p);
            for (ItemImpressao item : itens) {
                ExportaRelatorio er;
                if (!exportaDadosCabecalho && this.itemCabecalho(item) || (er = ExportaRelatorio.converterItemImpressao(item)).getTopo() <= -1) continue;
                dadosExportacao.add(er);
            }
            paginas.put(p, dadosExportacao);
        }
        return paginas;
    }

    private boolean itemCabecalho(ItemImpressao item) {
        String nomeItem = this.getNomeItem(item);
        if (!Funcoes.textoVazio(nomeItem)) {
            for (ItemBanda ib : this.cabecalho.getItens()) {
                if (!ib.getNome().equalsIgnoreCase(nomeItem)) continue;
                return true;
            }
        }
        return false;
    }

    private String getNomeItem(ItemImpressao item) {
        if (item instanceof Rotulo) {
            Rotulo rotulo = (Rotulo)item;
            return rotulo.getNome();
        }
        if (item instanceof Texto) {
            Texto texto = (Texto)item;
            return texto.getNome();
        }
        if (item instanceof Label) {
            Label label = (Label)item;
            return label.getNome();
        }
        if (item instanceof Expressao) {
            Expressao expressao = (Expressao)item;
            return expressao.getNome();
        }
        return "";
    }

    protected List<ExportaRelatorio> organizarListaPorTopo(List<ExportaRelatorio> dadosExportacao) {
        ArrayList dadosOrdenadosPorTopo = new ArrayList(new HashSet(dadosExportacao.stream().collect(Collectors.toList())));
        return dadosOrdenadosPorTopo.stream().sorted(Comparator.comparingInt(t -> t.getTopo())).collect(Collectors.toList());
    }

    protected List<ExportaRelatorio> definirOrdemDasLinhas(List<ExportaRelatorio> dadosOrdenadosPorTopo) {
        int numeroLinha = 1;
        int topoAtual = 0;
        ArrayList<ExportaRelatorio> ordenadosPorLinha = new ArrayList<ExportaRelatorio>();
        int c = 0;
        while (c < dadosOrdenadosPorTopo.size()) {
            block4: {
                ExportaRelatorio atual;
                ExportaRelatorio er;
                topoAtual = dadosOrdenadosPorTopo.get(c).getTopo();
                int proximo = c + 1;
                while ((er = dadosOrdenadosPorTopo.get(proximo)).getTopo() - topoAtual <= 4) {
                    er.setLinha(numeroLinha);
                    ordenadosPorLinha.add(er);
                    if (proximo + 1 == dadosOrdenadosPorTopo.size()) {
                        atual = dadosOrdenadosPorTopo.get(c);
                        atual.setLinha(numeroLinha);
                        ordenadosPorLinha.add(atual);
                        c = ++proximo;
                        break block4;
                    }
                    ++proximo;
                }
                atual = dadosOrdenadosPorTopo.get(c);
                atual.setLinha(numeroLinha);
                ordenadosPorLinha.add(atual);
                if (proximo + 1 == dadosOrdenadosPorTopo.size()) {
                    ExportaRelatorio ultimoSozinho = dadosOrdenadosPorTopo.get(proximo++);
                    ultimoSozinho.setLinha(++numeroLinha);
                    ordenadosPorLinha.add(ultimoSozinho);
                }
                c = proximo;
            }
            ++numeroLinha;
        }
        return ordenadosPorLinha;
    }

    protected Integer getUltimaLinha(List<ExportaRelatorio> ordenadosPorLinha) {
        return ordenadosPorLinha.stream().map(ol -> ol.getLinha()).max(Comparator.comparingInt(l -> l)).orElse(ordenadosPorLinha.size());
    }

    protected List<ExportaRelatorio> ordenarDadosDaMesmaLinha(List<ExportaRelatorio> ordenadosPorLinha, int linhaAtual) {
        List dadosNaMesmaLinha = ordenadosPorLinha.stream().filter(l -> l.getLinha() == linhaAtual).collect(Collectors.toList());
        return dadosNaMesmaLinha.stream().sorted(Comparator.comparingInt(d -> d.getColuna())).collect(Collectors.toList());
    }

    protected StringBuilder construirLinha(List<ExportaRelatorio> dadosNaMesmaLinha) {
        StringBuilder linhaArquivo = new StringBuilder();
        for (ExportaRelatorio linha : dadosNaMesmaLinha) {
            if (Funcoes.textoVazio(linha.getTexto())) continue;
            linhaArquivo.append(linha.getTexto().replace("\u00a0", "")).append(";");
        }
        return linhaArquivo;
    }

    public static ExportaArquivo getExportadorPorExtensao(String extensao) {
        ExportaArquivo exportaArquivo = null;
        exportaArquivo = extensao.equals(EXTENSAO_CSV) ? new ExportaCSV() : new ExportaXLS();
        return exportaArquivo;
    }
}

