/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.propriedade;

import jalis.relatorio.editor.Constantes;
import jalis.relatorio.editor.ModeloArvore;
import jalis.relatorio.editor.Pagina;
import jalis.relatorio.editor.Selecao;
import jalis.relatorio.editor.SelecaoListener;
import jalis.relatorio.editor.propriedade.EditorPropriedade;
import jalis.relatorio.editor.propriedade.PropriedadeUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class TabelaPropriedades
extends AbstractTableModel
implements SelecaoListener,
ChangeListener {
    private Object[][] dados = new Object[0][2];
    private JTable tabela = new JTable();
    private Selecao selecao;
    private EditorCelula editor = new EditorCelula();

    public TabelaPropriedades() {
        this.tabela = new JTable(this);
        this.tabela.getTableHeader().setReorderingAllowed(false);
        this.tabela.setBackground(Constantes.COR_EDITOR_PROPRIEDADES);
        this.tabela.setRowHeight(20);
        this.tabela.getColumnModel().getColumn(1).setCellEditor(this.editor);
        this.tabela.setFocusable(false);
    }

    public JTable getTablePropriedade() {
        return this.tabela;
    }

    @Override
    public void itemSelecionado(ChangeEvent e) {
        if (this.selecao == null) {
            this.selecao = (Selecao)e.getSource();
        }
        this.carregarPropriedades();
        this.carregarValor();
    }

    @Override
    public void dadosAlterados(ChangeEvent e) {
        if (this.selecao == null) {
            this.selecao = (Selecao)e.getSource();
        }
        this.carregarValor();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        EditorPropriedade ed = (EditorPropriedade)e.getSource();
        Selecao sel = ed.getSelecao();
        PropriedadeUtil.setValor(sel.getItensSelecionados(), ed.getValor(), ed.getPropriedade());
        this.carregarPropriedades();
        this.carregarValor();
        if (this.selecao != null && this.selecao.getPagina() != null) {
            Pagina pag = this.selecao.getPagina();
            ModeloArvore modelo = pag.getModeloArvore();
            ((DefaultTreeModel)modelo).nodeStructureChanged((TreeNode)modelo.getRoot());
            pag.repaint();
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int coluna) {
        switch (coluna) {
            case 0: {
                return "Propriedade";
            }
            case 1: {
                return "Valor";
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int colIndex) {
        return colIndex == 1;
    }

    @Override
    public int getRowCount() {
        return this.dados.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return ((EditorPropriedade)this.dados[rowIndex][columnIndex]).getValorUsuario();
        }
        return this.dados[rowIndex][columnIndex];
    }

    private void carregarPropriedades() {
        if (this.selecao != null) {
            try {
                Object[] prop = PropriedadeUtil.getPropriedadesEmComum(this.selecao.getItensSelecionados());
                this.dados = new Object[prop.length / 2][2];
                for (int i = 0; i < this.dados.length; ++i) {
                    this.dados[i][0] = prop[i * 2];
                    Object t = ((Class)prop[i * 2 + 1]).newInstance();
                    this.dados[i][1] = t;
                    EditorPropriedade ep = (EditorPropriedade)t;
                    ep.setSelecao(this.selecao);
                    ep.setPropriedade((String)prop[i * 2]);
                    ep.addChangeListener(this);
                    ep.atualizar();
                }
                this.fireTableStructureChanged();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "TabelaPropriedade: 163");
            }
        }
    }

    private void carregarValor() {
        if (this.selecao != null) {
            Object[] itens = this.selecao.getItensSelecionados();
            for (int i = 0; i < this.dados.length; ++i) {
                EditorPropriedade ep = (EditorPropriedade)this.dados[i][1];
                ep.setValor(PropriedadeUtil.getValor(itens, (String)this.dados[i][0]));
                ep.setCamposBanco(this.selecao.getPagina().getCamposDoBanco());
                ep.setVariaveis(this.selecao.getPagina().getVariaveis());
            }
            this.fireTableDataChanged();
            this.tabela.getColumnModel().getColumn(1).setCellEditor(this.editor);
        }
    }

    private class EditorCelula
    implements TableCellEditor {
        private int linha;

        private EditorCelula() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.linha = row;
            return (Component)TabelaPropriedades.this.dados[this.linha][1];
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return ((EditorPropriedade)TabelaPropriedades.this.dados[this.linha][1]).getValorUsuario();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            TabelaPropriedades.this.listenerList.add(CellEditorListener.class, l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            TabelaPropriedades.this.listenerList.remove(CellEditorListener.class, l);
        }

        private void fireEditingStopped() {
            Object[] ouvintes = TabelaPropriedades.this.listenerList.getListenerList();
            for (int i = 0; i <= ouvintes.length - 2; i += 2) {
                if (ouvintes[i] != CellEditorListener.class) continue;
                ((CellEditorListener)ouvintes[i + 1]).editingStopped(new ChangeEvent(this));
            }
        }

        private void fireEditingCanceled() {
            Object[] ouvintes = TabelaPropriedades.this.listenerList.getListenerList();
            for (int i = 0; i <= ouvintes.length - 2; i += 2) {
                if (ouvintes[i] != CellEditorListener.class) continue;
                ((CellEditorListener)ouvintes[i + 1]).editingCanceled(new ChangeEvent(this));
            }
        }
    }
}

