/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.propriedade;

import jalis.relatorio.editor.item.Imagem;
import jalis.relatorio.editor.propriedade.Editavel;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class PropriedadeUtil {
    public static String getNomeMetodo(String prefixo, String propriedade) {
        StringBuffer str = new StringBuffer(prefixo.toLowerCase());
        boolean upper = true;
        char[] c = propriedade.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                upper = true;
                continue;
            }
            if (upper) {
                str.append(Character.toUpperCase(StringUtil.removerAcento(c[i])));
                upper = false;
                continue;
            }
            str.append(Character.toLowerCase(StringUtil.removerAcento(c[i])));
        }
        return str.toString();
    }

    public static void setValor(Object item, Object valor, String propriedade) {
        if (item != null && valor != null && propriedade != null) {
            try {
                Method metodo = PropriedadeUtil.getMetodo(item, "set", propriedade);
                if (metodo != null && metodo.getParameterTypes().length == 1) {
                    metodo.invoke(item, valor);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PropriedadeUtil: 63");
            }
        }
    }

    public static void setValor(Object[] itens, Object valor, String propriedade) {
        for (int i = 0; i < itens.length; ++i) {
            PropriedadeUtil.setValor(itens[i], valor, propriedade);
        }
    }

    public static Object getValor(Object item, String propriedade) {
        if (item != null && propriedade != null) {
            try {
                Method metodo = PropriedadeUtil.getMetodo(item, "get", propriedade);
                if (item instanceof Imagem) {
                    Imagem img = (Imagem)item;
                    if (propriedade.equals("condicao") && Funcoes.textoVazio(img.getCondicao())) {
                        return null;
                    }
                }
                if (metodo != null) {
                    return metodo.invoke(item, new Object[0]);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PropriedadeUtil: 93");
            }
        }
        return null;
    }

    public static Object getValor(Object[] itens, String propriedade) {
        Object valor = null;
        if (itens.length > 0) {
            valor = PropriedadeUtil.getValor(itens[0], propriedade);
            for (int i = 1; i < itens.length; ++i) {
                Object tmp = PropriedadeUtil.getValor(itens[i], propriedade);
                if (valor == null || tmp == null || valor.equals(tmp)) continue;
                valor = null;
                break;
            }
        }
        return valor;
    }

    public static Object[] getPropriedadesEmComum(Editavel[] itens) {
        ArrayList<Object> prop = new ArrayList<Object>();
        if (itens.length == 1) {
            return PropriedadeUtil.ordenar(itens[0].getPropriedades());
        }
        if (itens.length > 1) {
            int i;
            Object[] tmp = itens[0].getPropriedades();
            for (i = 1; i < itens.length; ++i) {
                tmp = PropriedadeUtil.getPropriedadesEmComum(tmp, itens[i].getPropriedades());
            }
            tmp = PropriedadeUtil.ordenar(tmp);
            for (i = 0; i <= tmp.length - 2; i += 2) {
                prop.add(tmp[i]);
                prop.add(tmp[i + 1]);
            }
        }
        return prop.toArray(new Object[prop.size()]);
    }

    private static Object[] getPropriedadesEmComum(Object[] a, Object[] b) {
        ArrayList<Object> comum = new ArrayList<Object>();
        block0: for (int i = 0; i <= a.length - 2; i += 2) {
            for (int j = 0; j <= b.length - 2; j += 2) {
                if (!a[i].equals(b[j]) || !a[i + 1].equals(b[j + 1])) continue;
                comum.add(a[i]);
                comum.add(a[i + 1]);
                continue block0;
            }
        }
        return comum.toArray(new Object[comum.size()]);
    }

    private static Object[] ordenar(Object[] prop) {
        for (int i = 0; i <= prop.length - 4; i += 2) {
            for (int j = i + 2; j <= prop.length - 2; j += 2) {
                String b;
                String a = prop[i] instanceof String ? (String)prop[i] : null;
                String string = b = prop[j] instanceof String ? (String)prop[j] : null;
                if (a == null || b == null || a.compareToIgnoreCase(b) <= 0) continue;
                Object o = prop[i];
                prop[i] = prop[j];
                prop[j] = o;
                o = prop[i + 1];
                prop[i + 1] = prop[j + 1];
                prop[j + 1] = o;
            }
        }
        return prop;
    }

    private static Method getMetodo(Object item, String pre, String prop) {
        String nome = PropriedadeUtil.getNomeMetodo(pre, prop);
        Method[] metodos = item.getClass().getMethods();
        for (int i = 0; i < metodos.length; ++i) {
            if (!metodos[i].getName().equals(nome)) continue;
            return metodos[i];
        }
        return null;
    }
}

