/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.propriedade;

import jalis.relatorio.editor.item.Banda;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.Editavel;
import jalis.relatorio.editor.propriedade.EditorPropriedade;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;

public class EditorBandaFilha
extends EditorPropriedade {
    private JComboBox comboBox = new JComboBox();

    public EditorBandaFilha() {
        this.add((Component)this.comboBox, "Center");
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == "ok") {
                    EditorBandaFilha.this.fireStateChanged();
                }
            }
        });
    }

    @Override
    public void setValor(Object valor) {
        if (valor instanceof String) {
            this.comboBox.setActionCommand("cancelado");
            String nome = valor.toString();
            if (nome.isEmpty()) {
                this.comboBox.setSelectedItem(null);
            } else {
                this.selecionarItem(nome);
            }
            this.comboBox.setActionCommand("ok");
        }
    }

    @Override
    public Object getValor() {
        Object item = this.comboBox.getSelectedItem();
        return item != null ? item.toString() : "";
    }

    @Override
    public Object getValorUsuario() {
        return this.getValor();
    }

    @Override
    public void atualizar() {
        if (this.selecao != null && this.selecao.getPagina() != null && this.selecao.getPagina().getModeloArvore() != null) {
            this.comboBox.removeAllItems();
            ArrayList<Editavel> tmp = new ArrayList<Editavel>();
            Editavel[] itens = this.selecao.getItensSelecionados();
            for (int i = 0; i < itens.length; ++i) {
                if (!(itens[i] instanceof Banda)) continue;
                tmp.add(itens[i]);
            }
            ItemSelecionavel[] bandas = this.selecao.getPagina().getModeloArvore().getBandas();
            for (int i = 0; i < bandas.length; ++i) {
                if (((Banda)bandas[i]).getTipo() != 1 && ((Banda)bandas[i]).getTipo() != 2 || tmp.contains(bandas[i])) continue;
                this.comboBox.addItem(bandas[i]);
            }
            this.comboBox.addItem("Nenhuma");
        }
    }

    private void selecionarItem(String nome) {
        if (this.selecao != null && this.selecao.getPagina() != null && this.selecao.getPagina().getModeloArvore() != null) {
            if (nome == "Nenhuma") {
                this.comboBox.setSelectedItem(null);
            } else {
                boolean selecionou = false;
                ItemSelecionavel[] bandas = this.selecao.getPagina().getModeloArvore().getBandas();
                for (int i = 0; i < bandas.length; ++i) {
                    if (!bandas[i].toString().equalsIgnoreCase(nome)) continue;
                    this.comboBox.setSelectedItem(bandas[i]);
                    selecionou = true;
                    break;
                }
                if (!selecionou) {
                    this.comboBox.setSelectedItem(null);
                }
            }
        }
    }
}

