/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.propriedade;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.relatorio.editor.propriedade.DocumentoExpressao;
import jalis.relatorio.gerador.Variaveis;
import jalis.util.DialogoLista;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.expressao.DialogoFuncao;
import jalis.util.expressao.DialogoFuncaoFactory;
import jalis.util.expressao.parser.ExpressaoException;
import jalis.util.expressao.parser.Sintatico;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

class DialogoExpressao
extends JDialog
implements ActionListener,
DisposeListener {
    JPanel panelCentral = new JPanel(new BorderLayout());
    JPanel panelBase = new JPanel(new BorderLayout());
    JPanel panelFerramentas = new JPanel(new FlowLayout(0, 2, 1));
    JPanel panelCampo = new JPanel(new FlowLayout(0, 2, 1));
    JPanel panelLogico = new JPanel(new FlowLayout(0, 2, 1));
    JPanel panelMatematico = new JPanel(new FlowLayout(0, 2, 1));
    JPanel panelRelacional = new JPanel(new FlowLayout(0, 2, 1));
    JPanel panelFuncao = new JPanel(new BorderLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton buttonCampoBanco = ComponenteFactory.novoJButton("Banco", '\u0000', this, null, null);
    JButton buttonVariaveis = ComponenteFactory.novoJButton("Vari\u00e1veis", '\u0000', this, null, null);
    JButton buttonCampoRelatorio = ComponenteFactory.novoJButton("Relat\u00f3rio", '\u0000', this, null, null);
    JButton buttonE = ComponenteFactory.novoJButton("E", '\u0000', this, null, null);
    JButton buttonOu = ComponenteFactory.novoJButton("Ou", '\u0000', this, null, null);
    JButton buttonMais = ComponenteFactory.novoJButton("+", '\u0000', this, null, null);
    JButton buttonMenos = ComponenteFactory.novoJButton("-", '\u0000', this, null, null);
    JButton buttonMult = ComponenteFactory.novoJButton("*", '\u0000', this, null, null);
    JButton buttonDiv = ComponenteFactory.novoJButton("/", '\u0000', this, null, null);
    JButton buttonIgual = ComponenteFactory.novoJButton("=", '\u0000', this, null, null);
    JButton buttonDif = ComponenteFactory.novoJButton("<>", '\u0000', this, null, null);
    JButton buttonMaior = ComponenteFactory.novoJButton(">", '\u0000', this, null, null);
    JButton buttonMenor = ComponenteFactory.novoJButton("<", '\u0000', this, null, null);
    JButton buttonMaiorIgual = ComponenteFactory.novoJButton(">=", '\u0000', this, null, null);
    JButton buttonMenorIgual = ComponenteFactory.novoJButton("<=", '\u0000', this, null, null);
    JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    JLabel labelErro = new JLabel();
    JTextPane textExpressao = ComponenteFactory.novoJTextPane();
    JScrollPane scrollExpressao = new JScrollPane(this.textExpressao);
    DocumentoExpressao docExpressao = new DocumentoExpressao(this.textExpressao);
    private Map<Object, Integer> funcoes = new HashMap<Object, Integer>();
    private String[] camposBanco = new String[0];
    private String[] variaveis = new String[0];
    private boolean ok = false;
    private ActionListener acaoFuncao = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogoFuncao de;
            Integer tipo = (Integer)DialogoExpressao.this.funcoes.get(e.getSource());
            if (tipo != null && (de = DialogoFuncaoFactory.criarDialogoFuncao(tipo, DialogoExpressao.this)) != null) {
                de.setCamposBanco(DialogoExpressao.this.camposBanco);
                de.setVariaveis(DialogoExpressao.this.variaveis);
                de.setVisible(true);
                if (de.ok()) {
                    DialogoExpressao.this.inserirTexto(de.getExpressao());
                }
                DialogoExpressao.this.textExpressao.requestFocus();
            }
        }
    };
    JButton buttonSe = ComponenteFactory.novoJButton("Se", '\u0000', this.acaoFuncao, null, null);
    JButton buttonCopia = ComponenteFactory.novoJButton("Copia", '\u0000', this.acaoFuncao, null, null);
    JButton buttonVazio = ComponenteFactory.novoJButton("Vazio", '\u0000', this.acaoFuncao, null, null);
    JButton buttonZero = ComponenteFactory.novoJButton("Zero", '\u0000', this.acaoFuncao, null, null);
    JButton buttonExtenso = ComponenteFactory.novoJButton("Extenso", '\u0000', this.acaoFuncao, null, null);
    JButton buttonTamanho = ComponenteFactory.novoJButton("Tamanho", '\u0000', this.acaoFuncao, null, null);
    JButton buttonNumero = ComponenteFactory.novoJButton("Numero", '\u0000', this.acaoFuncao, null, null);
    JButton buttonData = ComponenteFactory.novoJButton("Data", '\u0000', this.acaoFuncao, null, null);
    JButton buttonSomaData = ComponenteFactory.novoJButton("SomaData", '\u0000', this.acaoFuncao, null, null);
    JButton buttonSomatorio = ComponenteFactory.novoJButton("Somatorio", '\u0000', this.acaoFuncao, null, null);
    JButton buttonMedia = ComponenteFactory.novoJButton("Media", '\u0000', this.acaoFuncao, null, null);
    JButton buttonContem = ComponenteFactory.novoJButton("Contem", '\u0000', this.acaoFuncao, null, null);
    JButton buttonCaracter = ComponenteFactory.novoJButton("Caracter", '\u0000', this.acaoFuncao, null, null);
    JButton buttonSomatorioAvancado = ComponenteFactory.novoJButton("SomatorioAvancando", '\u0000', this.acaoFuncao, null, null);

    public static DialogoExpressao novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoExpressao((Frame)pai, "Editor de express\u00f5es", true);
        }
        if (pai instanceof Dialog) {
            return new DialogoExpressao((Dialog)pai, "Editor de express\u00f5es", true);
        }
        return null;
    }

    public DialogoExpressao(Frame pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        this.iniciar(pai);
        ScreenUtil.centralizar(this);
    }

    public DialogoExpressao(Dialog pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        this.iniciar(pai);
        ScreenUtil.centralizar(this);
    }

    public String[] getCamposBanco() {
        return this.camposBanco;
    }

    public void setCamposBanco(String[] campos) {
        this.camposBanco = campos;
    }

    public void setVariaveis(String[] variaveis) {
        this.variaveis = variaveis;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            boolean bl = this.ok = o == this.buttonOk;
            if (!this.ok || this.validarExpressao()) {
                this.dispose();
            }
        } else if (o == this.buttonCampoBanco) {
            DialogoLista dl = DialogoLista.novaInstancia(this, "Campos do banco");
            dl.setItens(this.camposBanco);
            dl.setVisible(true);
            if (dl.ok()) {
                this.inserirTexto(dl.getItemSelecionado());
            }
            this.textExpressao.requestFocus();
        } else if (o == this.buttonVariaveis) {
            DialogoLista dl = DialogoLista.novaInstancia(this, "Vari\u00e1veis");
            dl.setItens(this.variaveis);
            dl.setVisible(true);
            if (dl.ok()) {
                this.inserirTexto(dl.getItemSelecionado());
            }
            this.textExpressao.requestFocus();
        } else if (o == this.buttonCampoRelatorio) {
            DialogoLista dl = DialogoLista.novaInstancia(this, "Vari\u00e1veis de relat\u00f3rio");
            dl.setItens(Variaveis.getVariaveis());
            dl.setVisible(true);
            if (dl.ok()) {
                this.inserirTexto(dl.getItemSelecionado());
            }
            this.textExpressao.requestFocus();
        } else if (o instanceof JButton) {
            this.inserirTexto(" " + ((JButton)o).getText().toLowerCase() + " ");
            this.textExpressao.requestFocus();
        }
    }

    public String getExpressao() {
        return this.textExpressao.getText();
    }

    public void setExpressao(String expressao) {
        this.textExpressao.setText(expressao);
    }

    public boolean ok() {
        return this.ok;
    }

    private void iniciar(Object pai) {
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        this.setResizable(false);
        this.setSize(new Dimension(810, 500));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelCentral, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.panelCentral.add((Component)this.scrollExpressao, "Center");
        this.panelCentral.add((Component)this.panelBase, "South");
        this.panelBase.add((Component)this.labelErro, "North");
        this.panelBase.add((Component)this.panelFerramentas, "Center");
        this.textExpressao.setFont(new Font("Monospaced", 0, 13));
        this.textExpressao.setStyledDocument(this.docExpressao);
        this.panelFerramentas.setPreferredSize(new Dimension(10, 140));
        this.panelFerramentas.add(this.panelCampo);
        this.panelFerramentas.add(this.panelLogico);
        this.panelFerramentas.add(this.panelMatematico);
        this.panelFerramentas.add(this.panelRelacional);
        this.panelFerramentas.add(this.panelFuncao);
        this.panelCampo.setBorder(BorderFactory.createTitledBorder("Vari\u00e1vel"));
        this.panelCampo.add(this.buttonCampoBanco);
        this.panelCampo.add(this.buttonVariaveis);
        this.panelCampo.add(this.buttonCampoRelatorio);
        this.panelLogico.setBorder(BorderFactory.createTitledBorder("Op. Logico"));
        this.panelLogico.add(this.buttonE);
        this.panelLogico.add(this.buttonOu);
        this.panelMatematico.setBorder(BorderFactory.createTitledBorder("Op. Matem\u00e1tico"));
        this.panelMatematico.add(this.buttonMais);
        this.panelMatematico.add(this.buttonMenos);
        this.panelMatematico.add(this.buttonMult);
        this.panelMatematico.add(this.buttonDiv);
        this.panelRelacional.setBorder(BorderFactory.createTitledBorder("Op. Relacional"));
        this.panelRelacional.add(this.buttonIgual);
        this.panelRelacional.add(this.buttonDif);
        this.panelRelacional.add(this.buttonMaior);
        this.panelRelacional.add(this.buttonMenor);
        this.panelRelacional.add(this.buttonMaiorIgual);
        this.panelRelacional.add(this.buttonMenorIgual);
        this.panelFuncao.setBorder(BorderFactory.createTitledBorder("Fun\u00e7\u00e3o"));
        JPanel panelTemp = new JPanel(new FlowLayout(0, 2, 1));
        panelTemp.add(this.buttonSe);
        panelTemp.add(this.buttonCopia);
        panelTemp.add(this.buttonVazio);
        panelTemp.add(this.buttonZero);
        panelTemp.add(this.buttonExtenso);
        panelTemp.add(this.buttonTamanho);
        panelTemp.add(this.buttonNumero);
        panelTemp.add(this.buttonData);
        panelTemp.add(this.buttonSomaData);
        this.panelFuncao.add((Component)panelTemp, "North");
        panelTemp = new JPanel(new FlowLayout(0, 2, 1));
        panelTemp.add(this.buttonSomatorio);
        panelTemp.add(this.buttonMedia);
        panelTemp.add(this.buttonContem);
        panelTemp.add(this.buttonCaracter);
        panelTemp.add(this.buttonSomatorioAvancado);
        this.panelFuncao.add((Component)panelTemp, "South");
        this.panelBotoes.setBorder(BorderFactory.createEtchedBorder());
        this.panelBotoes.add(this.buttonOk);
        this.panelBotoes.add(this.buttonCancelar);
        this.labelErro.setForeground(Color.red);
        this.labelErro.setPreferredSize(new Dimension(10, 25));
        Insets margens = new Insets(2, 8, 2, 8);
        this.buttonMais.setMargin(margens);
        this.buttonMenos.setMargin(margens);
        this.buttonMult.setMargin(margens);
        this.buttonDiv.setMargin(margens);
        this.buttonIgual.setMargin(margens);
        this.buttonDif.setMargin(margens);
        this.buttonMaior.setMargin(margens);
        this.buttonMenor.setMargin(margens);
        this.buttonMaiorIgual.setMargin(margens);
        this.buttonMenorIgual.setMargin(margens);
        margens = new Insets(2, 6, 2, 6);
        this.buttonSe.setMargin(margens);
        this.buttonCopia.setMargin(margens);
        this.buttonVazio.setMargin(margens);
        this.buttonZero.setMargin(margens);
        this.buttonExtenso.setMargin(margens);
        this.buttonTamanho.setMargin(margens);
        this.buttonNumero.setMargin(margens);
        this.buttonData.setMargin(margens);
        this.buttonSomaData.setMargin(margens);
        this.buttonSomatorio.setMargin(margens);
        this.buttonMedia.setMargin(margens);
        this.buttonContem.setMargin(margens);
        this.buttonSomatorioAvancado.setMargin(margens);
        this.funcoes.put(this.buttonSe, 0);
        this.funcoes.put(this.buttonCopia, 1);
        this.funcoes.put(this.buttonVazio, 2);
        this.funcoes.put(this.buttonZero, 3);
        this.funcoes.put(this.buttonExtenso, 4);
        this.funcoes.put(this.buttonTamanho, 5);
        this.funcoes.put(this.buttonNumero, 6);
        this.funcoes.put(this.buttonData, 7);
        this.funcoes.put(this.buttonSomaData, 8);
        this.funcoes.put(this.buttonSomatorio, 9);
        this.funcoes.put(this.buttonMedia, 10);
        this.funcoes.put(this.buttonContem, 11);
        this.funcoes.put(this.buttonCaracter, 12);
        this.funcoes.put(this.buttonSomatorioAvancado, 14);
    }

    private void inserirTexto(String texto) {
        if (texto != null && texto.length() > 0) {
            try {
                this.docExpressao.insertString(this.textExpressao.getCaretPosition(), texto, null);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "391");
            }
        }
    }

    private boolean validarExpressao() {
        Sintatico s = new Sintatico();
        try {
            s.analisar(this.textExpressao.getText());
        }
        catch (ExpressaoException e) {
            this.docExpressao.destacarErro(e.pos);
            this.labelErro.setText(" Erro: " + e.getMessage());
            this.textExpressao.requestFocus();
            return false;
        }
        return true;
    }
}

