/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.propriedade;

import jalis.relatorio.gerador.Bordas;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

class ConfiguraBordas
extends JComponent
implements MouseListener {
    private Bordas bordas = new Bordas();

    public ConfiguraBordas() {
        this.addMouseListener(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.black);
        ScreenUtil.desenharRetangulos(g, new Rectangle[]{this.getCaixa(1), this.getCaixa(5), this.getCaixa(3), this.getCaixa(7)});
        g.setColor(Color.white);
        Rectangle area = this.getArea();
        ScreenUtil.pintarRetangulos(g, new Rectangle[]{area});
        if (this.bordas != null) {
            g.setColor(Color.black);
            if (this.bordas.esquerda()) {
                this.pintarChecado(g, this.getCaixa(7));
                g.drawLine(area.x, area.y, area.x, area.y + area.height);
            }
            if (this.bordas.direita()) {
                this.pintarChecado(g, this.getCaixa(3));
                g.drawLine(area.x + area.width, area.y, area.x + area.width, area.y + area.height);
            }
            if (this.bordas.superior()) {
                this.pintarChecado(g, this.getCaixa(1));
                g.drawLine(area.x, area.y, area.x + area.width, area.y);
            }
            if (this.bordas.inferior()) {
                this.pintarChecado(g, this.getCaixa(5));
                g.drawLine(area.x, area.y + area.height, area.x + area.width, area.y + area.height);
            }
        }
    }

    public Bordas getBordas() {
        return this.bordas;
    }

    public void setBordas(Bordas bordas) {
        if (bordas != null) {
            this.bordas = new Bordas(bordas.esquerda(), bordas.direita(), bordas.superior(), bordas.inferior());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.bordas != null) {
            Point p = e.getPoint();
            Rectangle[] r = new Rectangle[]{this.getCaixa(7), this.getCaixa(3), this.getCaixa(1), this.getCaixa(5)};
            if (r[0].contains(p)) {
                this.bordas.setBordas(new boolean[]{!this.bordas.esquerda(), this.bordas.direita(), this.bordas.superior(), this.bordas.inferior()});
            } else if (r[1].contains(p)) {
                this.bordas.setBordas(new boolean[]{this.bordas.esquerda(), !this.bordas.direita(), this.bordas.superior(), this.bordas.inferior()});
            } else if (r[2].contains(p)) {
                this.bordas.setBordas(new boolean[]{this.bordas.esquerda(), this.bordas.direita(), !this.bordas.superior(), this.bordas.inferior()});
            } else if (r[3].contains(p)) {
                this.bordas.setBordas(new boolean[]{this.bordas.esquerda(), this.bordas.direita(), this.bordas.superior(), !this.bordas.inferior()});
            }
            this.repaint();
        }
    }

    private void pintarChecado(Graphics g, Rectangle r) {
        g.fillRect(r.x + 2, r.y + 2, 2, r.height - 4);
        g.drawLine(r.x + 2, r.y + r.height - 2, r.x + r.width - 2, r.y + 3);
        g.drawLine(r.x + 3, r.y + r.height - 2, r.x + r.width - 2, r.y + 4);
    }

    private Rectangle getCaixa(int pos) {
        Dimension d = this.getSize();
        switch (pos) {
            case 1: {
                return new Rectangle(d.width / 2 - 5, 5, 10, 10);
            }
            case 5: {
                return new Rectangle(d.width / 2 - 5, d.height - 15, 10, 10);
            }
            case 3: {
                return new Rectangle(d.width - 15, d.height / 2 - 5, 10, 10);
            }
            case 7: {
                return new Rectangle(5, d.height / 2 - 5, 10, 10);
            }
        }
        return new Rectangle();
    }

    private Rectangle getArea() {
        Dimension d = this.getSize();
        return new Rectangle(20, 20, d.width - 40, d.height - 40);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

