/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.item;

import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.EditorBoolean;
import jalis.relatorio.editor.propriedade.EditorBordas;
import jalis.relatorio.editor.propriedade.EditorCampoBanco;
import jalis.relatorio.editor.propriedade.EditorColor;
import jalis.relatorio.editor.propriedade.EditorFont;
import jalis.util.ArraysUtil;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Texto
extends AbstractItemModelo {
    private String campoBanco;
    private boolean quebrarPalavras;

    public Texto(ModeloPagina modelo) {
        super(modelo);
        this.setRetangulo(new Rectangle(0, 0, 85, 40));
        this.gerarNome("Texto");
        this.campoBanco = "";
    }

    @Override
    public String getTipoItem() {
        return "jalis.relatorio.gerador.item.Texto";
    }

    @Override
    public Object[] getPropriedades() {
        Object[] prop = new Object[]{"fonte", EditorFont.class, "cor da fonte", EditorColor.class, "campo do banco", EditorCampoBanco.class, "bordas", EditorBordas.class, "quebrar palavras", EditorBoolean.class};
        return ArraysUtil.concatenar(super.getPropriedades(), prop);
    }

    @Override
    public void copiarAtributosDe(ItemSelecionavel item) {
        super.copiarAtributosDe(item);
        if (item instanceof Texto) {
            Texto texto = (Texto)item;
            this.setQuebrarPalavras(texto.getQuebrarPalavras());
            this.setCampoDoBanco(texto.getCampoDoBanco());
        }
    }

    public String getCampoDoBanco() {
        return this.campoBanco;
    }

    public void setCampoDoBanco(String campoBanco) {
        this.campoBanco = campoBanco;
    }

    public boolean getQuebrarPalavras() {
        return this.quebrarPalavras;
    }

    public void setQuebrarPalavras(boolean quebrar) {
        this.quebrarPalavras = quebrar;
    }

    @Override
    public void pintar(Graphics g) {
        this.pintarColchetes(g);
        String str = this.campoBanco == null || this.campoBanco.length() == 0 ? "Texto" : this.campoBanco;
        g.setFont(this.fonte);
        this.pintarString(g, StringUtil.getSubstring(str, (int)this.retangulo.width - 6, g.getFontMetrics()));
        if (this.bordas != null) {
            g.setColor(Color.black);
            this.bordas.pintar(g, this.getRetangulo());
        }
    }
}

