/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.item;

import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.EditorAlinhamentoHorizontal;
import jalis.relatorio.editor.propriedade.EditorBordas;
import jalis.relatorio.editor.propriedade.EditorColor;
import jalis.relatorio.editor.propriedade.EditorFont;
import jalis.relatorio.editor.propriedade.EditorString;
import jalis.util.ArraysUtil;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class Rotulo
extends AbstractItemModelo {
    private String texto;

    public Rotulo(ModeloPagina modelo) {
        super(modelo);
        this.gerarNome("Rotulo");
        this.texto = "rotulo";
        this.redimensionar();
    }

    @Override
    public String getTipoItem() {
        return "jalis.relatorio.gerador.item.Rotulo";
    }

    @Override
    public void copiarAtributosDe(ItemSelecionavel item) {
        super.copiarAtributosDe(item);
        if (item instanceof Rotulo) {
            Rotulo tmp = (Rotulo)item;
            this.setTexto(tmp.getTexto());
            this.setAlinhamentoHorizontal(tmp.getAlinhamentoHorizontal());
        }
    }

    @Override
    public Object[] getPropriedades() {
        Object[] prop = new Object[]{"fonte", EditorFont.class, "texto", EditorString.class, "alinhamento horizontal", EditorAlinhamentoHorizontal.class, "cor da fonte", EditorColor.class, "bordas", EditorBordas.class};
        return ArraysUtil.concatenar(prop, super.getPropriedades());
    }

    @Override
    public void setRetangulo(Rectangle retangulo) {
        super.setRetangulo(retangulo);
        this.redimensionar();
    }

    @Override
    public void setRetangulo2D(Rectangle2D.Float retangulo) {
        super.setRetangulo2D(retangulo);
        this.redimensionar();
    }

    @Override
    public void setLargura(float largura) {
        super.setLargura(largura);
        this.redimensionar();
    }

    @Override
    public void setAltura(float altura) {
        super.setAltura(altura);
        this.redimensionar();
    }

    public String getTexto() {
        return this.texto;
    }

    public void setTexto(String texto) {
        this.texto = texto;
        this.redimensionar();
    }

    @Override
    public void setFonte(Font fonte) {
        super.setFonte(fonte);
        this.redimensionar();
    }

    @Override
    public void pintar(Graphics g) {
        this.pintarColchetes(g);
        this.pintarString(g, this.texto);
        if (this.bordas != null) {
            g.setColor(Color.black);
            this.bordas.pintar(g, this.getRetangulo());
        }
    }

    private void redimensionar() {
        Dimension tam = ScreenUtil.getTamanhoString(this.texto, this.fonte);
        tam = new Dimension(tam.width + 6, tam.height);
        this.retangulo.width = Math.max((float)tam.width, this.retangulo.width);
        this.retangulo.height = Math.max((float)tam.height, this.retangulo.height);
    }
}

