/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.item;

import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.EditorAlinhamentoHorizontal;
import jalis.relatorio.editor.propriedade.EditorAlinhamentoVertical;
import jalis.relatorio.editor.propriedade.EditorBoolean;
import jalis.relatorio.editor.propriedade.EditorBordas;
import jalis.relatorio.editor.propriedade.EditorCampoBanco;
import jalis.relatorio.editor.propriedade.EditorCondicao;
import jalis.relatorio.editor.propriedade.EditorExpressao;
import jalis.relatorio.editor.propriedade.EditorImagem;
import jalis.util.ArraysUtil;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;

public class Imagem
extends AbstractItemModelo {
    private String campoBanco;
    private String expressao;
    private int alinVert;
    private boolean estender;
    private ImageIcon imagem;
    private String condicao;

    public Imagem(ModeloPagina modelo) {
        super(modelo);
        this.setRetangulo(new Rectangle(60, 50));
        this.alinHori = 0;
        this.gerarNome("Imagem");
        this.campoBanco = "";
        this.expressao = "";
        this.imagem = null;
        this.estender = false;
    }

    @Override
    public String getTipoItem() {
        return "jalis.relatorio.gerador.item.Imagem";
    }

    @Override
    public void copiarAtributosDe(ItemSelecionavel item) {
        super.copiarAtributosDe(item);
        if (item instanceof Imagem) {
            Imagem tmp = (Imagem)item;
            this.setAlinhamentoHorizontal(tmp.getAlinhamentoHorizontal());
            this.setAlinhamentoVertical(tmp.getAlinhamentoVertical());
            this.setCampoDoBanco(tmp.getCampoDoBanco());
            this.setExpressao(tmp.getExpressao());
            this.setImagem(tmp.getImagem());
            this.setCondicao(tmp.getCondicao());
            this.setEstender(tmp.getEstender());
        }
    }

    @Override
    public Object[] getPropriedades() {
        Object[] prop = new Object[]{"alinhamento horizontal", EditorAlinhamentoHorizontal.class, "alinhamento vertical", EditorAlinhamentoVertical.class, "campo do banco", EditorCampoBanco.class, "expressao", EditorExpressao.class, "imagem", EditorImagem.class, "estender", EditorBoolean.class, "bordas", EditorBordas.class, "condicao", EditorCondicao.class};
        return ArraysUtil.concatenar(super.getPropriedades(), prop);
    }

    @Override
    public void setRetangulo(Rectangle rec) {
        super.setRetangulo(rec);
        this.atualizarTamanho();
    }

    @Override
    public void setRetangulo2D(Rectangle2D.Float retangulo) {
        super.setRetangulo2D(retangulo);
        this.atualizarTamanho();
    }

    @Override
    public void setLargura(float largura) {
        super.setLargura(largura);
        this.atualizarTamanho();
    }

    @Override
    public void setAltura(float altura) {
        super.setAltura(altura);
        this.atualizarTamanho();
    }

    public String getImagem() {
        if (this.imagem != null) {
            return new Base64().encodeAsString(ImagemUtils.imageToByte(this.imagem.getImage()));
        }
        return "";
    }

    public void setImagem(String imagem) {
        if (imagem != null) {
            try {
                if (imagem.length() == 0) {
                    this.imagem = null;
                    this.alinHori = 0;
                } else {
                    this.imagem = new ImageIcon(new Base64().decode(imagem));
                    this.atualizarTamanho();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Imagem: 150");
            }
        }
    }

    public String getCampoDoBanco() {
        return this.campoBanco;
    }

    public void setExpressao(String expressao) {
        this.expressao = expressao;
    }

    public String getExpressao() {
        return this.expressao;
    }

    public void setCampoDoBanco(String campo) {
        this.campoBanco = campo;
    }

    public int getAlinhamentoVertical() {
        return this.alinVert;
    }

    public void setAlinhamentoVertical(int alin) {
        this.alinVert = alin;
    }

    public boolean getEstender() {
        return this.estender;
    }

    public String getCondicao() {
        return this.condicao == null ? "" : (this.condicao.equals("null") ? "" : this.condicao);
    }

    public void setCondicao(String condicao) {
        this.condicao = condicao.equals("null") ? "" : condicao;
    }

    public void setEstender(boolean estender) {
        this.estender = estender;
        this.atualizarTamanho();
    }

    @Override
    public void pintar(Graphics g) {
        Rectangle rec = this.getRetangulo();
        if (this.imagem != null) {
            if (this.estender) {
                g.drawImage(this.imagem.getImage(), rec.x, rec.y, rec.width, rec.height, null);
            } else {
                int x;
                int imgW = this.imagem.getIconWidth();
                int imgH = this.imagem.getIconHeight();
                int n = this.alinHori == 2 ? rec.x : (x = this.alinHori == 4 ? rec.x + rec.width - imgW : rec.x + (rec.width - imgW) / 2);
                int y = this.alinVert == 1 ? rec.y : (this.alinVert == 3 ? rec.y + rec.height - imgH : rec.y + (rec.height - imgH) / 2);
                g.drawImage(this.imagem.getImage(), x, y, this.imagem.getIconWidth(), this.imagem.getIconHeight(), null);
            }
        }
        if (this.imagem == null) {
            this.pintarString(g, StringUtil.getSubstring("Imagem", rec.width - 6, g.getFontMetrics()));
        }
        this.pintarColchetes(g);
        if (this.bordas != null) {
            g.setColor(Color.black);
            this.bordas.pintar(g, rec);
        }
    }

    private void atualizarTamanho() {
        if (this.imagem != null && !this.estender) {
            Rectangle r = this.getRetangulo();
            int w = this.imagem.getIconWidth();
            int h = this.imagem.getIconHeight();
            w = w < r.width ? r.width : w;
            h = h < r.height ? r.height : h;
            this.retangulo.width = w;
            this.retangulo.height = h;
        }
    }
}

