/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.item;

import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.EditorAlinhamentoHorizontal;
import jalis.relatorio.editor.propriedade.EditorAlinhamentoVertical;
import jalis.relatorio.editor.propriedade.EditorColor;
import jalis.relatorio.editor.propriedade.EditorInteiros;
import jalis.relatorio.editor.propriedade.EditorTipoForma;
import jalis.util.ArraysUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class Forma
extends AbstractItemModelo {
    private Color corLinha = Color.black;
    private Color corPreenchimento = Color.white;
    private int tipo;
    private int alinVert;
    private int espessura;

    public Forma(ModeloPagina modelo) {
        super(modelo);
        this.alinHori = 0;
        this.alinVert = 0;
        this.espessura = 1;
        this.setRetangulo(new Rectangle(50, 50));
        this.gerarNome("Forma");
    }

    @Override
    public void copiarAtributosDe(ItemSelecionavel item) {
        super.copiarAtributosDe(item);
        if (item instanceof Forma) {
            Forma tmp = (Forma)item;
            this.setTipo(tmp.getTipo());
            this.setEspessura(tmp.getEspessura());
            this.setCorDaLinha(tmp.getCorDaLinha());
            this.setCorDePreenchimento(tmp.getCorDePreenchimento());
            this.setAlinhamentoHorizontal(tmp.getAlinhamentoHorizontal());
            this.setAlinhamentoVertical(tmp.getAlinhamentoVertical());
        }
    }

    @Override
    public Object[] getPropriedades() {
        Object[] prop = new Object[]{"tipo", EditorTipoForma.class, "cor da linha", EditorColor.class, "espessura", EditorInteiros.class};
        if (this.tipo == 0 || this.tipo == 1) {
            prop = ArraysUtil.concatenar(prop, new Object[]{"cor de preenchimento", EditorColor.class});
        } else if (this.tipo == 2) {
            prop = ArraysUtil.concatenar(prop, new Object[]{"alinhamento vertical", EditorAlinhamentoVertical.class});
        } else if (this.tipo == 3) {
            prop = ArraysUtil.concatenar(prop, new Object[]{"alinhamento horizontal", EditorAlinhamentoHorizontal.class});
        }
        return ArraysUtil.concatenar(super.getPropriedades(), prop);
    }

    @Override
    public String getTipoItem() {
        return "jalis.relatorio.gerador.item.Forma";
    }

    public Color getCorDaLinha() {
        return this.corLinha;
    }

    public void setCorDaLinha(Color cor) {
        this.corLinha = cor;
    }

    public Color getCorDePreenchimento() {
        return this.corPreenchimento;
    }

    public void setCorDePreenchimento(Color cor) {
        this.corPreenchimento = cor;
    }

    public int getTipo() {
        return this.tipo;
    }

    public void setTipo(int tipo) {
        this.tipo = tipo;
    }

    public int getEspessura() {
        return this.espessura;
    }

    public void setEspessura(int espessura) {
        this.espessura = espessura;
    }

    public int getAlinhamentoVertical() {
        return this.alinVert;
    }

    public void setAlinhamentoVertical(int alin) {
        this.alinVert = alin;
    }

    @Override
    public void pintar(Graphics g) {
        Rectangle r = this.getRetangulo();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.corPreenchimento);
        switch (this.tipo) {
            case 0: {
                g2d.fillRect(r.x, r.y, r.width, r.height);
                break;
            }
            case 1: {
                g2d.fillOval(r.x, r.y, r.width, r.height);
            }
        }
        g2d.setColor(this.corLinha);
        g2d.setStroke(new BasicStroke(this.espessura));
        switch (this.tipo) {
            case 0: {
                g2d.drawRect(r.x, r.y, r.width, r.height);
                break;
            }
            case 1: {
                g2d.drawOval(r.x, r.y, r.width, r.height);
                break;
            }
            case 2: {
                int y = this.alinVert == 1 ? 0 : (this.alinVert == 3 ? r.height : r.height / 2);
                g2d.drawLine(r.x, r.y + y, r.x + r.width, r.y + y);
                break;
            }
            case 3: {
                int x = this.alinHori == 2 ? 0 : (this.alinHori == 4 ? r.width : r.width / 2);
                g2d.drawLine(r.x + x, r.y, r.x + x, r.y + r.height);
            }
        }
        g2d.setStroke(new BasicStroke(1.0f));
        this.pintarColchetes(g2d);
    }
}

