/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.item;

import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.EditorAlinhamentoHorizontal;
import jalis.relatorio.editor.propriedade.EditorBoolean;
import jalis.relatorio.editor.propriedade.EditorBordas;
import jalis.relatorio.editor.propriedade.EditorColor;
import jalis.relatorio.editor.propriedade.EditorExpressao;
import jalis.relatorio.editor.propriedade.EditorFont;
import jalis.relatorio.editor.propriedade.EditorMascara;
import jalis.util.ArraysUtil;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Expressao
extends AbstractItemModelo {
    private String expressao;
    private String mascara;
    private boolean quebrarLinhas;
    private boolean quebrarPalavras;

    public Expressao(ModeloPagina modelo) {
        super(modelo);
        this.setRetangulo(new Rectangle(70, 20));
        this.gerarNome("Expressao");
        this.expressao = "";
        this.mascara = "";
    }

    @Override
    public String getTipoItem() {
        return "jalis.relatorio.gerador.item.Expressao";
    }

    @Override
    public void copiarAtributosDe(ItemSelecionavel item) {
        super.copiarAtributosDe(item);
        if (item instanceof Expressao) {
            Expressao tmp = (Expressao)item;
            this.setAlinhamentoHorizontal(tmp.getAlinhamentoHorizontal());
            this.setExpressao(tmp.getExpressao());
            this.setMascara(tmp.getMascara());
        }
    }

    @Override
    public Object[] getPropriedades() {
        Object[] prop = new Object[]{"fonte", EditorFont.class, "cor da fonte", EditorColor.class, "alinhamento horizontal", EditorAlinhamentoHorizontal.class, "expressao", EditorExpressao.class, "bordas", EditorBordas.class, "quebrar linhas", EditorBoolean.class, "m\u00e1scara", EditorMascara.class};
        if (this.quebrarLinhas) {
            prop = ArraysUtil.concatenar(prop, new Object[]{"quebrar palavras", EditorBoolean.class});
        }
        return ArraysUtil.concatenar(super.getPropriedades(), prop);
    }

    public String getExpressao() {
        return this.expressao;
    }

    public void setExpressao(String expressao) {
        if (expressao != null) {
            this.expressao = expressao;
        }
    }

    public boolean getQuebrarLinhas() {
        return this.quebrarLinhas;
    }

    public void setQuebrarLinhas(boolean quebrar) {
        this.quebrarLinhas = quebrar;
    }

    public boolean getQuebrarPalavras() {
        return this.quebrarPalavras;
    }

    public void setMascara(String mascara) {
        if (mascara != null) {
            this.mascara = mascara;
        }
    }

    public String getMascara() {
        return this.mascara;
    }

    public void setQuebrarPalavras(boolean quebrar) {
        this.quebrarPalavras = quebrar;
    }

    @Override
    public void pintar(Graphics g) {
        Rectangle rec = this.getRetangulo();
        this.pintarColchetes(g);
        g.setFont(this.fonte);
        this.pintarString(g, StringUtil.getSubstring("Express\u00e3o", rec.width - 6, g.getFontMetrics()));
        if (this.bordas != null) {
            g.setColor(Color.black);
            this.bordas.pintar(g, rec);
        }
    }
}

