/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.item;

import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.EditorBordas;
import jalis.relatorio.editor.propriedade.EditorExpressao;
import jalis.util.ArraysUtil;
import jalis.util.ImagemUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class CodigoQRCode
extends AbstractItemModelo {
    private String expressao;
    private String valor;

    public CodigoQRCode(ModeloPagina modelo) {
        super(modelo);
        this.setRetangulo(new Rectangle(40, 40));
        this.gerarNome("CodigoQRCode");
        this.expressao = "";
        this.valor = "www.jalis.com.br";
    }

    @Override
    public void pintar(Graphics g) {
        Rectangle rec = this.getRetangulo();
        String textoQrCode = this.expressao.isEmpty() ? this.valor : this.expressao;
        BufferedImage imagemQrCode = ImagemUtils.gerarQrCodeImagem(textoQrCode, rec.width, rec.height);
        if (null != imagemQrCode) {
            int medidaPadrao = rec.width < rec.height ? rec.width : rec.height;
            g.drawImage(imagemQrCode, rec.x, rec.y, medidaPadrao, medidaPadrao, null);
            this.pintarColchetes(g);
            if (this.bordas != null) {
                g.setColor(Color.black);
                this.bordas.pintar(g, rec);
            }
        }
    }

    @Override
    public String getTipoItem() {
        return "jalis.relatorio.gerador.item.CodigoQRCode";
    }

    @Override
    public void copiarAtributosDe(ItemSelecionavel item) {
        super.copiarAtributosDe(item);
        if (item instanceof CodigoQRCode) {
            CodigoQRCode tmp = (CodigoQRCode)item;
            this.setExpressao(tmp.getExpressao());
        }
    }

    @Override
    public Object[] getPropriedades() {
        Object[] prop = new Object[]{"expressao", EditorExpressao.class, "bordas", EditorBordas.class};
        return ArraysUtil.concatenar(super.getPropriedades(), prop);
    }

    public String getExpressao() {
        return this.expressao;
    }

    public void setExpressao(String expressao) {
        if (expressao != null) {
            this.expressao = expressao;
        }
    }
}

