/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.item;

import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.EditorAlinhamentoHorizontal;
import jalis.relatorio.editor.propriedade.EditorBordas;
import jalis.relatorio.editor.propriedade.EditorCampoBanco;
import jalis.relatorio.editor.propriedade.EditorFormatoBarra;
import jalis.relatorio.editor.propriedade.EditorInteiros;
import jalis.relatorio.editor.propriedade.EditorString;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.barras.CodigoBarras25;
import jalis.util.barras.CodigoBarras39;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class CodigoBarras
extends AbstractItemModelo {
    private String valor = "123";
    private int formato;
    private String campoBanco = "";
    private int colZeros = 0;

    public CodigoBarras(ModeloPagina modelo) {
        super(modelo);
        this.setRetangulo(new Rectangle(10, 25));
        this.gerarNome("CodigoBarras");
        this.atualizarTamanho();
    }

    @Override
    public String getTipoItem() {
        return "jalis.relatorio.gerador.item.CodigoBarras";
    }

    @Override
    public void copiarAtributosDe(ItemSelecionavel item) {
        super.copiarAtributosDe(item);
        if (item instanceof CodigoBarras) {
            CodigoBarras tmp = (CodigoBarras)item;
            this.setValorDeExemplo(tmp.getValorDeExemplo());
            this.setFormato(tmp.getFormato());
            this.setCampoDoBanco(tmp.getCampoDoBanco());
            this.setAlinhamentoHorizontal(tmp.getAlinhamentoHorizontal());
            this.setPreencherZero(tmp.getPreencherZero());
        }
    }

    @Override
    public Object[] getPropriedades() {
        Object[] prop = new Object[]{"valor de exemplo", EditorString.class, "formato", EditorFormatoBarra.class, "campo do banco", EditorCampoBanco.class, "alinhamento horizontal", EditorAlinhamentoHorizontal.class, "bordas", EditorBordas.class, "preencher zero", EditorInteiros.class};
        return ArraysUtil.concatenar(super.getPropriedades(), prop);
    }

    @Override
    public void setRetangulo(Rectangle rec) {
        super.setRetangulo(rec);
        this.atualizarTamanho();
    }

    @Override
    public void setLargura(float largura) {
        super.setLargura(largura);
        this.atualizarTamanho();
    }

    @Override
    public void setAltura(float altura) {
        super.setAltura(altura);
        this.atualizarTamanho();
    }

    public int getPreencherZero() {
        return this.colZeros;
    }

    public void setPreencherZero(int coluna) {
        this.colZeros = coluna;
        this.valor = Funcoes.preencheZero(this.valor, coluna);
        this.atualizarTamanho();
    }

    public int getFormato() {
        return this.formato;
    }

    public void setFormato(int formato) {
        this.formato = formato;
        this.atualizarTamanho();
    }

    public String getValorDeExemplo() {
        return this.valor;
    }

    public void setValorDeExemplo(String valor) {
        if (valor == null || valor.length() == 0 || this.formato == 0 && !valor.matches("\\-?\\d+")) {
            return;
        }
        this.valor = Funcoes.preencheZero(valor, this.colZeros);
        this.atualizarTamanho();
    }

    public String getCampoDoBanco() {
        return this.campoBanco;
    }

    public void setCampoDoBanco(String campo) {
        this.campoBanco = campo;
    }

    @Override
    public void pintar(Graphics g) {
        Rectangle r = this.getRetangulo();
        Rectangle[] barras = new Rectangle[]{};
        switch (this.formato) {
            case 0: {
                barras = CodigoBarras25.getBarras(this.valor, r.height);
                break;
            }
            case 1: {
                barras = CodigoBarras39.getBarras(this.valor, r.height);
            }
        }
        if (barras.length > 0) {
            int larg = barras[barras.length - 1].x + barras[barras.length - 1].width;
            int off = 0;
            switch (this.alinHori) {
                case 0: {
                    off = (r.width - larg) / 2;
                    break;
                }
                case 4: {
                    off = r.width - larg;
                }
            }
            g.setColor(Color.black);
            for (int i = 0; i < barras.length; ++i) {
                g.fillRect(r.x + barras[i].x + off, r.y, barras[i].width, barras[i].height + 1);
            }
        }
        this.pintarColchetes(g);
        if (this.bordas != null) {
            g.setColor(Color.black);
            this.bordas.pintar(g, r);
        }
    }

    private void atualizarTamanho() {
        Rectangle r = this.getRetangulo();
        Rectangle[] barras = new Rectangle[]{};
        switch (this.formato) {
            case 0: {
                barras = CodigoBarras25.getBarras(this.valor, 10);
                break;
            }
            case 1: {
                barras = CodigoBarras39.getBarras(this.valor, 10);
            }
        }
        if (barras.length > 0) {
            int w = barras[barras.length - 1].x + barras[barras.length - 1].width;
            int h = r.height;
            w = r.width < w ? w : r.width;
            h = h < 10 ? 10 : h;
            this.retangulo.width = w;
            this.retangulo.height = h;
        }
    }
}

