/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.item;

import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.EditorAlinhamentoHorizontal;
import jalis.relatorio.editor.propriedade.EditorBordas;
import jalis.relatorio.editor.propriedade.EditorCampoBanco;
import jalis.relatorio.editor.propriedade.EditorColor;
import jalis.relatorio.editor.propriedade.EditorFont;
import jalis.relatorio.editor.propriedade.EditorMascara;
import jalis.util.ArraysUtil;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class CampoBanco
extends AbstractItemModelo {
    private String campoBanco;
    private String mascara;

    public CampoBanco(ModeloPagina modelo) {
        super(modelo);
        this.setRetangulo(new Rectangle(0, 0, 85, 20));
        this.gerarNome("CampoBanco");
        this.campoBanco = "";
        this.mascara = "";
    }

    @Override
    public String getTipoItem() {
        return "jalis.relatorio.gerador.item.CampoBanco";
    }

    @Override
    public void copiarAtributosDe(ItemSelecionavel item) {
        super.copiarAtributosDe(item);
        if (item instanceof CampoBanco) {
            CampoBanco tmp = (CampoBanco)item;
            this.setAlinhamentoHorizontal(tmp.getAlinhamentoHorizontal());
            this.setCampoDoBanco(tmp.getCampoDoBanco());
            this.setMascara(tmp.getMascara());
        }
    }

    @Override
    public Object[] getPropriedades() {
        Object[] prop = new Object[]{"alinhamento horizontal", EditorAlinhamentoHorizontal.class, "fonte", EditorFont.class, "cor da fonte", EditorColor.class, "campo do banco", EditorCampoBanco.class, "m\u00e1scara", EditorMascara.class, "bordas", EditorBordas.class};
        return ArraysUtil.concatenar(super.getPropriedades(), prop);
    }

    public String getCampoDoBanco() {
        return this.campoBanco;
    }

    public void setCampoDoBanco(String campo) {
        this.campoBanco = campo;
    }

    public String getMascara() {
        return this.mascara;
    }

    public void setMascara(String mascara) {
        this.mascara = mascara;
    }

    @Override
    public void pintar(Graphics g) {
        this.pintarColchetes(g);
        String str = this.campoBanco == null || this.campoBanco.length() == 0 ? "CampoBanco" : this.campoBanco;
        g.setFont(this.fonte);
        this.pintarString(g, StringUtil.getSubstring(str, (int)this.retangulo.width - 6, g.getFontMetrics()));
        if (this.bordas != null) {
            g.setColor(Color.black);
            this.bordas.pintar(g, this.getRetangulo());
        }
    }
}

