/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.item;

import jalis.relatorio.editor.Constantes;
import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.propriedade.EditorBandaFilha;
import jalis.relatorio.editor.propriedade.EditorBandaRodape;
import jalis.relatorio.editor.propriedade.EditorBoolean;
import jalis.relatorio.editor.propriedade.EditorCampoBanco;
import jalis.relatorio.editor.propriedade.EditorCentimetros;
import jalis.relatorio.editor.propriedade.EditorInteiros;
import jalis.relatorio.editor.propriedade.EditorTipoBanda;
import jalis.relatorio.gerador.item.BandaFactory;
import jalis.util.ArraysUtil;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;

public class Banda
extends AbstractItemModelo {
    private int tipo;
    private String filha;
    private String rodape;
    private String campoChave;
    private int entreColunas = 0;
    private int colunas = 0;
    private ArrayList<Rectangle> posicaoColunas = new ArrayList();
    private boolean quebrarPagina = false;

    public Banda(ModeloPagina modelo) {
        super(modelo);
        this.setRetangulo(new Rectangle(10, 50));
        this.gerarNome("Banda");
        this.tipo = 2;
        this.filha = "";
        this.rodape = "";
        this.campoChave = "";
    }

    @Override
    public String getTipoItem() {
        return "jalis.relatorio.gerador.item.Banda";
    }

    @Override
    public Object[] getPropriedades() {
        Object[] prop = new Object[]{"tipo", EditorTipoBanda.class, "altura centimetros", EditorCentimetros.class};
        if (this.tipo == 1) {
            prop = ArraysUtil.concatenar(prop, new Object[]{"filha", EditorBandaFilha.class, "rodape", EditorBandaRodape.class, "campo chave", EditorCampoBanco.class, "quebrar pagina", EditorBoolean.class});
        }
        if (this.tipo == 2) {
            prop = ArraysUtil.concatenar(prop, new Object[]{"colunas", EditorInteiros.class, "entre colunas", EditorInteiros.class});
        }
        return ArraysUtil.concatenar(super.getPropriedades(), prop);
    }

    public float getAlturaCentimetros() {
        return ScreenUtil.getCentimetros(this.retangulo.height);
    }

    public void setAlturaCentimetros(float altura) {
        this.retangulo.height = ScreenUtil.getPixelsDeCentimetros(altura);
        this.moverItem();
        this.fireStateChanged();
    }

    public void setNomeBanda(String nome) {
        super.setNome(nome);
    }

    @Override
    public void setNome(String novoNome) {
        this.atualizarReferencias(this.nome, novoNome);
        super.setNome(novoNome);
    }

    public int getTipo() {
        return this.tipo;
    }

    public void setTipo(int tipo) {
        this.tipo = tipo;
        if (this.modelo != null) {
            this.modelo.atualizarRetangulos();
        }
    }

    public String getFilha() {
        return this.filha;
    }

    public void setFilha(String filha) {
        if (this.verificarBandaFilha(filha)) {
            this.filha = filha;
        }
    }

    public String getRodape() {
        return this.rodape;
    }

    public void setRodape(String rodape) {
        this.rodape = rodape;
    }

    public String getCampoChave() {
        return this.campoChave;
    }

    public void setCampoChave(String campo) {
        this.campoChave = campo;
    }

    @Override
    public void pintar(Graphics g) {
        Rectangle r = this.getRetangulo();
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.white);
        g2.drawRect(r.x, r.y, r.width, r.height);
        g2.setColor(Constantes.COR_BORDA_BANDA);
        Stroke tmp = g2.getStroke();
        g2.setStroke(Constantes.TRACEJADO);
        g2.drawRect(r.x, r.y, r.width, r.height);
        g2.setStroke(tmp);
        String str = "";
        switch (this.tipo) {
            case 0: {
                str = "Cabe\u00e7alho P\u00e1gina";
                break;
            }
            case 1: {
                str = "Cabe\u00e7alho Grupo";
                break;
            }
            case 2: {
                str = "Detalhe";
                break;
            }
            case 3: {
                str = "Rodap\u00e9 Grupo";
                break;
            }
            case 4: {
                str = "Sum\u00e1rio";
                break;
            }
            case 5: {
                str = "Rodap\u00e9 P\u00e1gina";
            }
        }
        g.setColor(Constantes.COR_TEXTO_BANDA);
        g.setFont(new Font("Arial", 1, 20));
        FontMetrics met = g.getFontMetrics();
        int h = met.getHeight();
        int w = met.stringWidth(str);
        g.drawString(str, r.x + (r.width - w) / 2, r.y + (r.height + h) / 2 - met.getDescent());
        if (this.colunas > 0) {
            for (Rectangle c : this.posicaoColunas) {
                g2.setStroke(Constantes.TRACEJADO);
                g2.setColor(Constantes.COR_BORDA_BANDA);
                g.drawRect(c.x, c.y, c.width, c.height);
                g2.setColor(Constantes.COR_TEXTO_BANDA);
                g.fillRect(c.x + 1, c.y + 1, c.width - 1, c.height - 1);
            }
        }
    }

    private void atualizarReferencias(String antigo, String novo) {
        for (Object o : instancias) {
            if (!(o instanceof Banda) || ((Banda)o).getTipo() != 1) continue;
            Banda banda = (Banda)o;
            if (banda.getFilha() != null && banda.getFilha().equalsIgnoreCase(antigo)) {
                banda.setFilha(novo);
            }
            if (banda.getRodape() == null || !banda.getRodape().equalsIgnoreCase(antigo)) continue;
            banda.setRodape(novo);
        }
    }

    private boolean verificarBandaFilha(String filha) {
        return true;
    }

    public int getEntreColunas() {
        return this.entreColunas;
    }

    public void setEntreColunas(int entreColunas) {
        this.entreColunas = entreColunas;
        this.posicaoColunas = BandaFactory.calcularPosicaoColunas(this.colunas, entreColunas, this.getRetangulo());
        this.moverItem();
        this.fireStateChanged();
    }

    public int getColunas() {
        return this.colunas;
    }

    public void setColunas(int colunas) {
        this.colunas = colunas;
        this.posicaoColunas = BandaFactory.calcularPosicaoColunas(colunas, this.entreColunas, this.getRetangulo());
        this.moverItem();
        this.fireStateChanged();
    }

    public void setQuebrarPagina(boolean quebrar) {
        this.quebrarPagina = quebrar;
    }

    public boolean getQuebrarPagina() {
        return this.quebrarPagina;
    }

    public ArrayList<Rectangle> getPosicaoColunas() {
        return this.posicaoColunas;
    }

    private void calcularPosicaoColunas() {
        if (this.colunas > 0) {
            Rectangle r = this.getRetangulo();
            int cadaColuna = r.width / this.colunas;
            for (int i = 1; i < this.colunas; ++i) {
                int xColuna = r.x + cadaColuna * i - this.entreColunas / 2;
                this.posicaoColunas.add(new Rectangle(xColuna, r.y, this.entreColunas, r.height));
            }
        } else if (this.posicaoColunas.size() > 0) {
            this.posicaoColunas.clear();
        }
    }
}

