/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor.item;

import jalis.comum.ParametrosGerais;
import jalis.relatorio.editor.Constantes;
import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.item.Banda;
import jalis.relatorio.editor.item.ItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.Editavel;
import jalis.relatorio.editor.propriedade.EditorDecimais;
import jalis.relatorio.editor.propriedade.EditorInteiros;
import jalis.relatorio.editor.propriedade.EditorString;
import jalis.relatorio.gerador.Bordas;
import jalis.util.Funcoes;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class AbstractItemModelo
implements ItemModelo,
Editavel {
    private EventListenerList listenerList = new EventListenerList();
    protected String nome;
    protected static ArrayList<AbstractItemModelo> instancias = new ArrayList();
    protected int[] posicao;
    protected Rectangle2D.Float retangulo = new Rectangle2D.Float();
    protected ItemSelecionavel banda;
    protected TreeNode treeNode;
    protected ModeloPagina modelo;
    protected Font fonte;
    protected Color corDaFonte;
    protected int alinHori;
    protected Bordas bordas;

    public AbstractItemModelo(ModeloPagina modelo) {
        instancias.add(this);
        this.modelo = modelo;
        this.nome = "";
        this.posicao = new int[2];
        this.retangulo = new Rectangle2D.Float();
        this.banda = null;
        this.treeNode = new DefaultMutableTreeNode(this);
        this.fonte = new Font(Funcoes.textoVazio(ParametrosGerais.getFontePadrao()) ? "Arial" : ParametrosGerais.getFontePadrao(), 0, 12);
        this.corDaFonte = Color.black;
        this.alinHori = 2;
        this.bordas = new Bordas();
    }

    public abstract String getTipoItem();

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    @Override
    public void copiarAtributosDe(ItemSelecionavel item) {
        if (item instanceof AbstractItemModelo) {
            AbstractItemModelo tmp = (AbstractItemModelo)item;
            this.setFonte(tmp.getFonte());
            this.setRetangulo2D((Rectangle2D.Float)tmp.getRetangulo2D().clone());
            this.setBordas(new Bordas(tmp.getBordas()));
            this.setCorDaFonte(tmp.getCorDaFonte());
        }
    }

    @Override
    public Object[] getPropriedades() {
        return new Object[]{"nome", EditorString.class, "altura", EditorDecimais.class, "largura", EditorDecimais.class, "esquerda", EditorInteiros.class, "topo", EditorInteiros.class};
    }

    @Override
    public Rectangle2D.Float getRetangulo2D() {
        return this.retangulo;
    }

    @Override
    public void setRetangulo2D(Rectangle2D.Float retangulo) {
        this.retangulo = retangulo;
        this.atualizarPosicao();
    }

    @Override
    public Rectangle getRetangulo() {
        return new Rectangle((int)this.retangulo.x, (int)this.retangulo.y, (int)this.retangulo.width, (int)this.retangulo.height);
    }

    @Override
    public void setRetangulo(Rectangle retangulo) {
        this.retangulo = new Rectangle2D.Float(retangulo.x, retangulo.y, retangulo.width, retangulo.height);
        this.atualizarPosicao();
    }

    public int getEsquerda() {
        return this.posicao[0];
    }

    public void setEsquerda(int pos) {
        this.posicao[0] = pos;
        this.moverItem();
        this.fireStateChanged();
    }

    public int getTopo() {
        return this.posicao[1];
    }

    public void setTopo(int pos) {
        this.posicao[1] = pos;
        this.moverItem();
        this.fireStateChanged();
    }

    public float getLargura() {
        return this.retangulo.width;
    }

    public void setLargura(float largura) {
        this.retangulo.width = largura;
        this.moverItem();
        this.fireStateChanged();
    }

    public float getAltura() {
        return this.retangulo.height;
    }

    public void setAltura(float altura) {
        this.retangulo.height = altura;
        this.moverItem();
        this.fireStateChanged();
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        if (!this.contemNome(nome)) {
            this.nome = nome;
            this.fireStateChanged();
        }
    }

    @Override
    public ItemSelecionavel getBanda() {
        return this.banda;
    }

    @Override
    public void setBanda(ItemSelecionavel banda) {
        this.banda = banda;
        this.atualizarPosicao();
    }

    public Bordas getBordas() {
        return this.bordas;
    }

    public void setBordas(Bordas bordas) {
        this.bordas = bordas;
    }

    @Override
    public boolean invalido() {
        return this.banda == null;
    }

    @Override
    public TreeNode getTreeNode() {
        return this.treeNode;
    }

    @Override
    public void atualizarRetangulo() {
        if (this.banda != null) {
            Rectangle2D.Float rec = this.banda.getRetangulo2D();
            this.retangulo.setRect(rec.x + (float)this.posicao[0], rec.y + (float)this.posicao[1], this.retangulo.width, this.retangulo.height);
        }
    }

    public String toString() {
        return this.nome;
    }

    @Override
    public Font getFonte() {
        return this.fonte;
    }

    @Override
    public void setFonte(Font fonte) {
        this.fonte = fonte;
    }

    @Override
    public Color getCorDaFonte() {
        return this.corDaFonte;
    }

    @Override
    public void setCorDaFonte(Color cor) {
        this.corDaFonte = cor;
    }

    @Override
    public boolean redimensionavel() {
        return true;
    }

    @Override
    public void removerInstancia() {
        if (instancias.contains(this)) {
            instancias.remove(this);
        }
    }

    public int getAlinhamentoHorizontal() {
        return this.alinHori;
    }

    public void setAlinhamentoHorizontal(int alin) {
        this.alinHori = alin;
    }

    public static void limparTabelasEstaticas() {
        instancias.clear();
    }

    protected void moverItem() {
        if (this.modelo != null) {
            int me = 20;
            Rectangle recBanda = this.banda == null ? null : this.banda.getRetangulo();
            Point pos = recBanda == null ? new Point(me + this.posicao[0], me + this.posicao[1]) : new Point(recBanda.x + this.posicao[0], recBanda.y + this.posicao[1]);
            this.modelo.moverItem(this, new Rectangle2D.Float(pos.x, pos.y, this.retangulo.width, this.retangulo.height));
        }
    }

    protected void gerarNome(String nomeBase) {
        int numero = 0;
        boolean achou = false;
        block0: while (!achou) {
            achou = true;
            String tmp = nomeBase + ++numero;
            for (AbstractItemModelo item : instancias) {
                if (!item.getNome().equalsIgnoreCase(tmp)) continue;
                achou = false;
                continue block0;
            }
        }
        this.nome = nomeBase + numero;
    }

    protected void pintarColchetes(Graphics g) {
        Rectangle r = this.getRetangulo();
        g.setColor(this.invalido() ? Constantes.COR_ITEM_INVALIDO : Color.black);
        g.drawLine(r.x, r.y, r.x + 3, r.y);
        g.drawLine(r.x, r.y, r.x, r.y + 3);
        g.drawLine(r.x, r.y + r.height - 3, r.x, r.y + r.height);
        g.drawLine(r.x, r.y + r.height, r.x + 3, r.y + r.height);
        g.drawLine(r.x + r.width - 3, r.y, r.x + r.width, r.y);
        g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + 3);
        g.drawLine(r.x + r.width, r.y + r.height - 3, r.x + r.width, r.y + r.height);
        g.drawLine(r.x + r.width - 3, r.y + r.height, r.x + r.width, r.y + r.height);
    }

    protected void pintarString(Graphics g, String str) {
        int x;
        g.setColor(this.invalido() ? Constantes.COR_ITEM_INVALIDO : this.corDaFonte);
        g.setFont(this.fonte);
        FontMetrics met = g.getFontMetrics();
        Rectangle r = this.getRetangulo();
        int h = met.getHeight();
        int w = met.stringWidth(str);
        switch (this.alinHori) {
            case 0: {
                x = r.x + (r.width - w) / 2;
                break;
            }
            case 4: {
                x = r.x + r.width - w - 3;
                break;
            }
            default: {
                x = r.x + 3;
            }
        }
        g.drawString(str, x, r.y + (r.height + h - met.getDescent()) / 2);
    }

    protected void fireStateChanged() {
        for (ChangeListener listener : (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private boolean contemNome(String nome) {
        for (AbstractItemModelo item : instancias) {
            if (!item.getNome().equalsIgnoreCase(nome)) continue;
            return true;
        }
        return false;
    }

    private void atualizarPosicao() {
        if (this.banda != null) {
            Rectangle rec = this.banda.getRetangulo();
            this.posicao[0] = (int)this.retangulo.x - rec.x;
            this.posicao[1] = (int)this.retangulo.y - rec.y;
        } else if (!(this instanceof Banda)) {
            this.posicao[0] = (int)this.retangulo.x - 20;
            this.posicao[1] = (int)this.retangulo.y - 20;
        }
    }
}

