/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor;

import jalis.relatorio.editor.Constantes;
import jalis.relatorio.editor.LinhaGuia;
import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.Pagina;
import jalis.relatorio.editor.PreSelecao;
import jalis.relatorio.editor.SelecaoListener;
import jalis.relatorio.editor.item.Banda;
import jalis.relatorio.editor.item.ItemInvalido;
import jalis.relatorio.editor.item.ItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.Editavel;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Selecao
implements MouseListener,
MouseMotionListener,
ActionListener,
ChangeListener {
    private EventListenerList ouvintes = new EventListenerList();
    private Pagina pagina;
    private ModeloPagina modelo;
    private PreSelecao preSelecao;
    private ArrayList itens;
    private Rectangle2D.Float[][] retangulos;
    private Point ptOffset;
    private boolean arrastou;
    private LinhaGuia linha;
    private JPopupMenu popupMenu;
    private JTree arvore;
    private MouseListener mouseArvore;
    private JMenuItem jMIMoverTopo;
    private JMenuItem jMIMoverCima;
    private JMenuItem jMIMoverBaixo;
    private JMenuItem jMIMoverBase;
    private JMenuItem jMIAlinharEsquerda;
    private JMenuItem jMIAlinharCentro;
    private JMenuItem jMIAlinharDireita;
    private JMenuItem jMIAlinharTopo;
    private JMenuItem jMIAlinharMeio;
    private JMenuItem jMIAlinharBase;
    private JMenuItem jMIDistHori;
    private JMenuItem jMIDistVert;
    private JMenuItem jMIMesmaLargura;
    private JMenuItem jMIMesmaAltura;
    private JMenuItem jMIMesmaFonte;
    private JMenuItem jMIMesmaCorDaFonte;
    private JMenuItem jMIDuplicar;
    private JMenuItem jMIRemover;

    public Selecao(Pagina pagina, PreSelecao preSelecao) {
        this.pagina = pagina;
        this.preSelecao = preSelecao;
        pagina.addMouseListener(this);
        pagina.addMouseMotionListener(this);
        this.modelo = pagina.getModeloArvore();
        this.itens = new ArrayList();
        this.retangulos = new Rectangle2D.Float[][]{new Rectangle2D.Float[0], new Rectangle2D.Float[0]};
        this.ptOffset = new Point();
        this.popupMenu = new JPopupMenu();
        this.jMIMoverTopo = this.novoMenuItem("Mover para o topo");
        this.jMIMoverCima = this.novoMenuItem("Mover para cima");
        this.jMIMoverBaixo = this.novoMenuItem("Mover para baixo");
        this.jMIMoverBase = this.novoMenuItem("Mover para a base");
        this.popupMenu.addSeparator();
        this.jMIAlinharEsquerda = this.novoMenuItem("Alinhar \u00e0 esquerda");
        this.jMIAlinharCentro = this.novoMenuItem("Alinhar ao centro");
        this.jMIAlinharDireita = this.novoMenuItem("Alinhar \u00e0 direita");
        this.popupMenu.addSeparator();
        this.jMIAlinharTopo = this.novoMenuItem("Alinhar ao topo");
        this.jMIAlinharMeio = this.novoMenuItem("Alinhar ao meio");
        this.jMIAlinharBase = this.novoMenuItem("Alinhar \u00e0 base");
        this.popupMenu.addSeparator();
        this.jMIDistHori = this.novoMenuItem("Distribuir horizontalmente");
        this.jMIDistVert = this.novoMenuItem("Distribuir verticalmente");
        this.popupMenu.addSeparator();
        this.jMIMesmaLargura = this.novoMenuItem("Mesma largura");
        this.jMIMesmaAltura = this.novoMenuItem("Mesma altura");
        this.popupMenu.addSeparator();
        this.jMIMesmaFonte = this.novoMenuItem("Mesma fonte");
        this.jMIMesmaCorDaFonte = this.novoMenuItem("Mesma cor da fonte");
        this.popupMenu.addSeparator();
        this.jMIDuplicar = this.novoMenuItem("Duplicar");
        this.popupMenu.addSeparator();
        this.jMIRemover = this.novoMenuItem("Remover");
        this.mouseArvore = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Selecao.this.selecionarItems();
                Selecao.this.repintar();
            }
        };
        this.definirTeclas();
    }

    public Pagina getPagina() {
        return this.pagina;
    }

    public void setArvore(JTree arvore) {
        this.arvore = arvore;
    }

    public MouseListener getMouseListener() {
        return this.mouseArvore;
    }

    public void addSelecaoListener(SelecaoListener l) {
        this.ouvintes.add(SelecaoListener.class, l);
    }

    public void removeSelecaoListener(SelecaoListener l) {
        this.ouvintes.remove(SelecaoListener.class, l);
    }

    public Editavel[] getItensSelecionados() {
        ArrayList array = new ArrayList();
        for (Object o : this.itens) {
            if (!(o instanceof Editavel)) continue;
            array.add(o);
        }
        return array.toArray(new Editavel[array.size()]);
    }

    public ArrayList getItens() {
        return this.itens;
    }

    public void pintar(Graphics g) {
        if (this.itens.size() > 0) {
            g.setColor(Color.blue);
            if (this.arrastou) {
                Graphics2D g2 = (Graphics2D)g;
                Stroke tmp = g2.getStroke();
                g2.setStroke(Constantes.TRACEJADO);
                ScreenUtil.desenharRetangulos(g, this.retangulos[1]);
                g2.setStroke(tmp);
            } else {
                Rectangle[][] caixas = this.getCaixasDeSelecao();
                if (caixas.length == 1) {
                    ScreenUtil.pintarRetangulos(g, caixas[0]);
                } else {
                    for (int i = 0; i < caixas.length; ++i) {
                        if (i == 0) {
                            g.setColor(Constantes.COR_PRIMEIRO_ITEM_SELECIONADO);
                        } else {
                            g.setColor(Constantes.COR_ITEM_SELECIONADO);
                        }
                        ScreenUtil.pintarRetangulos(g, ArraysUtil.subArray(caixas[i], 4, 7));
                    }
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.pagina != null && this.modelo != null) {
            boolean flag;
            Point pt = this.getPontoRelativo(e.getPoint());
            boolean bl = flag = this.validarPontoEmCaixaDeSelecao(pt) || this.validarPontoEmItemSelecionado(e);
            if (flag) {
                this.preSelecao.removerPreSelecao();
            } else {
                LinhaGuia linha = this.pagina.getLinhaGuiaNaPosicao(pt);
                if (linha != null && this.pagina.getExibirLinhasGuias()) {
                    this.pagina.setCursor(linha.horizontal() ? Constantes.REDIMENSIONA_NORTE : Constantes.REDIMENSIONA_LESTE);
                } else {
                    this.pagina.setCursor(Constantes.SETA);
                    ItemSelecionavel item = this.modelo.getItemNoPonto(pt);
                    if (item == null) {
                        this.preSelecao.removerPreSelecao();
                        this.pagina.setToolTipText("");
                    } else if (item != this.preSelecao.itemSelecionado()) {
                        this.preSelecao.preSelecionar(item);
                    }
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.pagina != null && this.modelo != null) {
            Point pt = this.getPontoRelativo(e.getPoint());
            if (e.getButton() == 3) {
                ItemSelecionavel item = this.modelo.getItemNoPonto(pt);
                if (item != null && item != this.pagina) {
                    if (!this.itens.contains(item)) {
                        this.removerSelecao();
                        this.selecionar(item);
                        this.repintar();
                    }
                    this.habilitarDesabilitarPopupMenu();
                    this.popupMenu.show(this.pagina, e.getX(), e.getY());
                }
            } else if (e.getButton() == 1) {
                this.ptOffset = pt;
                Rectangle areaPag = this.pagina.getAreaImprimivel();
                Rectangle recPag = this.pagina.getRetangulo();
                int marg = 20;
                if (this.ptOffset.y < marg && this.ptOffset.x > marg && this.ptOffset.x < marg + recPag.width) {
                    this.linha = new LinhaGuia(this.pagina, 4, this.ptOffset.y);
                    this.pagina.adicionarLinhaGuia(this.linha);
                    this.pagina.setCursor(Constantes.REDIMENSIONA_NORTE);
                } else if (this.ptOffset.x < marg && this.ptOffset.y > marg && this.ptOffset.y < marg + recPag.height) {
                    this.linha = new LinhaGuia(this.pagina, 5, this.ptOffset.x);
                    this.pagina.adicionarLinhaGuia(this.linha);
                    this.pagina.setCursor(Constantes.REDIMENSIONA_LESTE);
                } else if (this.pagina.haItemEmCriacao()) {
                    Class tmp = this.pagina.getItemParaCriar();
                    if (Banda.class.isAssignableFrom(tmp) && areaPag.contains(this.ptOffset) || ItemModelo.class.isAssignableFrom(tmp) && recPag.contains(this.ptOffset)) {
                        this.removerSelecao();
                        this.selecionar(this.modelo.instanciarItem(tmp, this.ptOffset));
                        this.pagina.setItemParaCriar(null);
                        this.repintar();
                    }
                } else {
                    this.arrastou = false;
                    if (this.possivelCursorLinhaGuia(this.pagina.getCursor()) && (this.linha = this.pagina.getLinhaGuiaNaPosicao(this.ptOffset)) != null) {
                        if (e.getClickCount() == 2) {
                            this.pagina.removerLinhaGuia(this.linha);
                            this.linha = null;
                            this.pagina.setCursor(Constantes.SETA);
                        }
                    } else if (!this.cursorDeArraste(this.pagina.getCursor())) {
                        ItemSelecionavel item = this.modelo.getItemNoPonto(this.ptOffset);
                        if (item == null) {
                            this.removerSelecao();
                        } else if (e.isShiftDown() && this.itens.contains(item)) {
                            this.removerSelecao(item);
                        } else {
                            if (!e.isShiftDown()) {
                                this.removerSelecao();
                            }
                            this.preSelecao.removerPreSelecao();
                            this.selecionar(item);
                        }
                        if (!this.validarPontoEmCaixaDeSelecao(this.ptOffset)) {
                            this.validarPontoEmItemSelecionado(e);
                        }
                        this.repintar();
                    }
                    this.retangulos[0] = this.getRetanguloItensSelecionados();
                    this.retangulos[1] = this.getRetanguloItensSelecionados();
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.pagina != null && this.cursorDeArraste(this.pagina.getCursor())) {
            Point pt = this.getPontoRelativo(e.getPoint());
            if (this.linha != null) {
                this.linha.setPosicao(this.linha.horizontal() ? pt.y : pt.x);
            } else {
                Cursor cursor;
                if (!this.arrastou) {
                    this.arrastou = true;
                }
                if ((cursor = this.pagina.getCursor()) == Constantes.ARRASTE) {
                    this.redimensionar(pt.x - this.ptOffset.x, pt.y - this.ptOffset.y, 0, 0);
                } else if (cursor == Constantes.REDIMENSIONA_NORTE) {
                    this.redimensionar(0, pt.y - this.ptOffset.y, 0, this.ptOffset.y - pt.y);
                } else if (cursor == Constantes.REDIMENSIONA_SUL) {
                    this.redimensionar(0, 0, 0, pt.y - this.ptOffset.y);
                } else if (cursor == Constantes.REDIMENSIONA_LESTE) {
                    this.redimensionar(0, 0, pt.x - this.ptOffset.x, 0);
                } else if (cursor == Constantes.REDIMENSIONA_OESTE) {
                    this.redimensionar(pt.x - this.ptOffset.x, 0, this.ptOffset.x - pt.x, 0);
                } else if (cursor == Constantes.REDIMENSIONA_NORDESTE) {
                    this.redimensionar(0, pt.y - this.ptOffset.y, pt.x - this.ptOffset.x, this.ptOffset.y - pt.y);
                } else if (cursor == Constantes.REDIMENSIONA_NOROESTE) {
                    this.redimensionar(pt.x - this.ptOffset.x, pt.y - this.ptOffset.y, this.ptOffset.x - pt.x, this.ptOffset.y - pt.y);
                } else if (cursor == Constantes.REDIMENSIONA_SUDESTE) {
                    this.redimensionar(0, 0, pt.x - this.ptOffset.x, pt.y - this.ptOffset.y);
                } else if (cursor == Constantes.REDIMENSIONA_SUDOESTE) {
                    this.redimensionar(pt.x - this.ptOffset.x, 0, this.ptOffset.x - pt.x, pt.y - this.ptOffset.y);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.pagina != null && this.modelo != null) {
            if (this.linha != null) {
                if (this.linha.getPosicao() < 20) {
                    this.pagina.removerLinhaGuia(this.linha);
                }
            } else if (this.arrastou) {
                for (int i = 0; i < this.retangulos[1].length; ++i) {
                    this.modelo.moverItem((ItemSelecionavel)this.itens.get(i), this.retangulos[1][i]);
                }
                this.modelo.atualizarRetangulos();
                this.arrastou = false;
                this.fireDadosAlterados();
            }
            this.retangulos[1] = new Rectangle2D.Float[0];
            this.linha = null;
            this.repintar();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        Object o = e.getSource();
        ItemSelecionavel item = (ItemSelecionavel)this.itens.get(0);
        Rectangle rec = item.getRetangulo();
        ItemSelecionavel[] tmp = this.itens.toArray(new ItemSelecionavel[this.itens.size()]);
        if (this.modelo != null) {
            Rectangle r;
            if (o == this.jMIMoverTopo) {
                this.modelo.moverParaTopo(item);
            } else if (o == this.jMIMoverCima) {
                this.modelo.moverParaCima(item);
            } else if (o == this.jMIMoverBaixo) {
                this.modelo.moverParaBaixo(item);
            } else if (o == this.jMIMoverBase) {
                this.modelo.moverParaBase(item);
            } else if (o == this.jMIAlinharEsquerda) {
                for (i = 1; i < tmp.length; ++i) {
                    r = tmp[i].getRetangulo();
                    this.modelo.moverItem(tmp[i], new Rectangle2D.Float(rec.x, r.y, r.width, r.height));
                }
            } else if (o == this.jMIAlinharCentro) {
                for (i = 1; i < tmp.length; ++i) {
                    r = tmp[i].getRetangulo();
                    this.modelo.moverItem(tmp[i], new Rectangle2D.Float(rec.x + (rec.width - r.width) / 2, r.y, r.width, r.height));
                }
            } else if (o == this.jMIAlinharDireita) {
                for (i = 1; i < tmp.length; ++i) {
                    r = tmp[i].getRetangulo();
                    this.modelo.moverItem(tmp[i], new Rectangle2D.Float(rec.x + rec.width - r.width, r.y, r.width, r.height));
                }
            } else if (o == this.jMIAlinharTopo) {
                for (i = 1; i < tmp.length; ++i) {
                    r = tmp[i].getRetangulo();
                    this.modelo.moverItem(tmp[i], new Rectangle2D.Float(r.x, rec.y, r.width, r.height));
                }
            } else if (o == this.jMIAlinharMeio) {
                for (i = 1; i < tmp.length; ++i) {
                    r = tmp[i].getRetangulo();
                    this.modelo.moverItem(tmp[i], new Rectangle2D.Float(r.x, rec.y + (rec.height - r.height) / 2, r.width, r.height));
                }
            } else if (o == this.jMIAlinharBase) {
                for (i = 1; i < tmp.length; ++i) {
                    r = tmp[i].getRetangulo();
                    this.modelo.moverItem(tmp[i], new Rectangle2D.Float(r.x, rec.y + rec.height - r.height, r.width, r.height));
                }
            } else if (o == this.jMIDistHori) {
                this.distribuirHorizontalmente();
            } else if (o == this.jMIDistVert) {
                this.distribuirVerticalmente();
            } else if (o == this.jMIMesmaLargura) {
                for (i = 1; i < tmp.length; ++i) {
                    r = tmp[i].getRetangulo();
                    this.modelo.moverItem(tmp[i], new Rectangle2D.Float(r.x, r.y, rec.width, r.height));
                }
            } else if (o == this.jMIMesmaAltura) {
                for (i = 1; i < tmp.length; ++i) {
                    r = tmp[i].getRetangulo();
                    this.modelo.moverItem(tmp[i], new Rectangle2D.Float(r.x, r.y, r.width, rec.height));
                }
            } else if (o == this.jMIDuplicar) {
                this.duplicarItensSelecionados();
            } else if (o == this.jMIRemover) {
                this.removerItensSelecionados();
            }
        }
        if (o == this.jMIMesmaFonte) {
            for (i = 1; i < tmp.length; ++i) {
                tmp[i].setFonte(item.getFonte());
            }
        } else if (o == this.jMIMesmaCorDaFonte) {
            for (i = 1; i < tmp.length; ++i) {
                tmp[i].setCorDaFonte(item.getCorDaFonte());
            }
        }
        if (o != this.jMIRemover) {
            this.fireDadosAlterados();
        }
        this.repintar();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireDadosAlterados();
    }

    public void selecionarPaths() {
        if (this.arvore != null && this.modelo != null) {
            ItemSelecionavel[] tmp = this.itens.toArray(new ItemSelecionavel[this.itens.size()]);
            this.arvore.setSelectionPaths(this.modelo.getTreePath(tmp));
        }
    }

    private void selecionarItems() {
        if (this.arvore != null && this.arvore.getSelectionPaths() != null) {
            TreePath[] paths = this.arvore.getSelectionPaths();
            this.removerSelecao();
            for (int i = 0; i < paths.length; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                Object userObject = node.getUserObject();
                if (userObject instanceof ItemInvalido) {
                    Enumeration<TreeNode> e = node.children();
                    while (e.hasMoreElements()) {
                        this.selecionar(((DefaultMutableTreeNode)e.nextElement()).getUserObject());
                    }
                    continue;
                }
                this.selecionar(userObject);
            }
        }
    }

    private void duplicarItensSelecionados() {
        if (this.haSomenteItensDeBanda()) {
            ItemSelecionavel[] tmp = this.itens.toArray(new ItemSelecionavel[this.itens.size()]);
            this.removerSelecao();
            Arrays.sort(tmp, new Comparator<ItemSelecionavel>(){

                @Override
                public int compare(ItemSelecionavel a, ItemSelecionavel b) {
                    int nb;
                    int na = Selecao.this.modelo.getIndiceItem(a);
                    return na > (nb = Selecao.this.modelo.getIndiceItem(b)) ? 1 : (na < nb ? -1 : 0);
                }
            });
            for (int i = 0; i < tmp.length; ++i) {
                ItemSelecionavel item = this.modelo.instanciarItem(tmp[i].getClass(), new Point());
                if (item == null) continue;
                Rectangle2D.Float rec = tmp[i].getRetangulo2D();
                item.copiarAtributosDe(tmp[i]);
                item.addChangeListener(this);
                this.itens.add(item);
                this.modelo.moverItem(item, new Rectangle2D.Float(rec.x + 10.0f, rec.y - 10.0f, rec.width, rec.height));
            }
            this.selecionarPaths();
            this.fireItemSelecionado();
        }
    }

    private void selecionar(Object item) {
        if (item instanceof ItemSelecionavel && !this.itens.contains(item)) {
            ((ItemSelecionavel)item).addChangeListener(this);
            this.itens.add(item);
            this.selecionarPaths();
            this.fireItemSelecionado();
        }
    }

    private void removerSelecao(Object item) {
        if (item instanceof ItemSelecionavel && this.itens.contains(item)) {
            ((ItemSelecionavel)item).removeChangeListener(this);
            this.itens.remove(item);
            this.selecionarPaths();
            this.fireItemSelecionado();
        }
    }

    private void removerSelecao() {
        for (ItemSelecionavel item : this.itens) {
            item.removeChangeListener(this);
        }
        this.itens.clear();
        if (this.arvore != null) {
            this.arvore.clearSelection();
        }
        this.fireItemSelecionado();
    }

    private void distribuirHorizontalmente() {
        int i;
        ItemSelecionavel[] c = this.itens.toArray(new ItemSelecionavel[this.itens.size()]);
        Arrays.sort(c, new Comparator<ItemSelecionavel>(){

            @Override
            public int compare(ItemSelecionavel a, ItemSelecionavel b) {
                return a.getRetangulo().x < b.getRetangulo().x ? -1 : (a.getRetangulo().x > b.getRetangulo().x ? 1 : 0);
            }
        });
        int w = 0;
        for (i = 1; i < c.length; ++i) {
            w += c[i].getRetangulo().x - c[i - 1].getRetangulo().x - c[i - 1].getRetangulo().width;
        }
        w /= c.length - 1;
        for (i = 1; i < c.length - 1; ++i) {
            Rectangle2D.Float tmp = c[i - 1].getRetangulo2D();
            Rectangle2D.Float rec = c[i].getRetangulo2D();
            this.modelo.moverItem(c[i], new Rectangle2D.Float(tmp.x + tmp.width + (float)w, rec.y, rec.width, rec.height));
        }
    }

    private void distribuirVerticalmente() {
        int i;
        ItemSelecionavel[] c = this.itens.toArray(new ItemSelecionavel[this.itens.size()]);
        Arrays.sort(c, new Comparator<ItemSelecionavel>(){

            @Override
            public int compare(ItemSelecionavel a, ItemSelecionavel b) {
                return a.getRetangulo().y < b.getRetangulo().y ? -1 : (a.getRetangulo().y > b.getRetangulo().y ? 1 : 0);
            }
        });
        int h = 0;
        for (i = 1; i < c.length; ++i) {
            h += c[i].getRetangulo().y - c[i - 1].getRetangulo().y - c[i - 1].getRetangulo().height;
        }
        h /= c.length - 1;
        for (i = 1; i < c.length - 1; ++i) {
            Rectangle2D.Float tmp = c[i - 1].getRetangulo2D();
            Rectangle2D.Float rec = c[i].getRetangulo2D();
            this.modelo.moverItem(c[i], new Rectangle2D.Float(rec.x, tmp.y + tmp.height + (float)h, rec.width, rec.height));
        }
    }

    private boolean validarPontoEmCaixaDeSelecao(Point pt) {
        Rectangle[][] caixas = this.getCaixasDeSelecao();
        if (caixas.length == 1 && this.itens.get(0) != this.pagina) {
            int indice = ScreenUtil.indiceRetanguloContemPonto(caixas[0], pt);
            if (this.itens.get(0) instanceof Banda) {
                if (indice == 0) {
                    this.pagina.setCursor(Constantes.REDIMENSIONA_NORTE);
                } else if (indice == 1) {
                    this.pagina.setCursor(Constantes.REDIMENSIONA_SUL);
                }
                return indice == 0 || indice == 1;
            }
            if (indice > -1) {
                switch (indice) {
                    case 0: {
                        this.pagina.setCursor(Constantes.REDIMENSIONA_NORTE);
                        break;
                    }
                    case 1: {
                        this.pagina.setCursor(Constantes.REDIMENSIONA_SUL);
                        break;
                    }
                    case 2: {
                        this.pagina.setCursor(Constantes.REDIMENSIONA_LESTE);
                        break;
                    }
                    case 3: {
                        this.pagina.setCursor(Constantes.REDIMENSIONA_OESTE);
                        break;
                    }
                    case 4: {
                        this.pagina.setCursor(Constantes.REDIMENSIONA_NORDESTE);
                        break;
                    }
                    case 5: {
                        this.pagina.setCursor(Constantes.REDIMENSIONA_NOROESTE);
                        break;
                    }
                    case 6: {
                        this.pagina.setCursor(Constantes.REDIMENSIONA_SUDESTE);
                        break;
                    }
                    case 7: {
                        this.pagina.setCursor(Constantes.REDIMENSIONA_SUDOESTE);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean validarPontoEmItemSelecionado(MouseEvent e) {
        Point pt = this.getPontoRelativo(e.getPoint());
        ItemSelecionavel item = this.modelo.getItemNoPonto(pt);
        if (item != null && this.itens.contains(item) && item != this.pagina) {
            boolean contemBanda = false;
            for (Object o : this.itens) {
                if (o != this.pagina && !(o instanceof Banda)) continue;
                contemBanda = true;
                break;
            }
            if (!(this.itens.size() != 1 && contemBanda || e.isShiftDown())) {
                this.pagina.setCursor(Constantes.ARRASTE);
                return true;
            }
        }
        return false;
    }

    private Rectangle[][] getCaixasDeSelecao() {
        ArrayList<Rectangle[]> caixas = new ArrayList<Rectangle[]>();
        if (this.itens.size() > 0) {
            for (ItemSelecionavel item : this.itens) {
                caixas.add(ScreenUtil.getCaixasDeSelecao(ScreenUtil.getRetanguloDeSelecao(item.getRetangulo())));
            }
        }
        return (Rectangle[][])caixas.toArray((T[])new Rectangle[caixas.size()][]);
    }

    private Rectangle2D.Float[] getRetanguloItensSelecionados() {
        ArrayList<Rectangle2D.Float> array = new ArrayList<Rectangle2D.Float>();
        if (this.itens.size() > 0) {
            Iterator itr = this.itens.iterator();
            while (itr.hasNext()) {
                array.add(((ItemSelecionavel)itr.next()).getRetangulo2D());
            }
        }
        return array.toArray(new Rectangle2D.Float[array.size()]);
    }

    private boolean cursorDeArraste(Cursor cursor) {
        return cursor == Constantes.ARRASTE || cursor == Constantes.REDIMENSIONA_NORTE || cursor == Constantes.REDIMENSIONA_SUL || cursor == Constantes.REDIMENSIONA_LESTE || cursor == Constantes.REDIMENSIONA_OESTE || cursor == Constantes.REDIMENSIONA_NORDESTE || cursor == Constantes.REDIMENSIONA_NOROESTE || cursor == Constantes.REDIMENSIONA_SUDESTE || cursor == Constantes.REDIMENSIONA_SUDOESTE;
    }

    private boolean possivelCursorLinhaGuia(Cursor cursor) {
        return cursor == Constantes.REDIMENSIONA_NORTE || cursor == Constantes.REDIMENSIONA_LESTE;
    }

    private void redimensionar(int xOffset, int yOffset, int widthOffset, int heightOffset) {
        if (this.retangulos[0].length == this.retangulos[1].length) {
            for (int i = 0; i < this.retangulos[0].length; ++i) {
                Rectangle2D.Float tmp = this.retangulos[1][i];
                this.retangulos[1][i] = new Rectangle2D.Float(this.itens.get(i) instanceof Banda ? this.retangulos[0][i].x : this.retangulos[0][i].x + (float)xOffset, this.retangulos[0][i].y + (float)yOffset, this.retangulos[0][i].width + (float)widthOffset, this.retangulos[0][i].height + (float)heightOffset);
                this.retangulos[1][i] = widthOffset == 0 && heightOffset == 0 ? this.grudarRetangulo(this.retangulos[1][i]) : this.validar(this.retangulos[1][i]);
                this.pagina.repaint(this.multZoom(tmp.x - 5.0f), this.multZoom(tmp.y - 5.0f), this.multZoom(tmp.width + 10.0f), this.multZoom(tmp.height + 10.0f));
                this.pagina.repaint(this.multZoom(this.retangulos[1][i].x - 5.0f), this.multZoom(this.retangulos[1][i].y), this.multZoom(this.retangulos[1][i].width + 10.0f), this.multZoom(this.retangulos[1][i].height + 10.0f));
            }
        }
    }

    private int multZoom(float i) {
        return (int)((double)i * this.pagina.getZoom());
    }

    private Rectangle2D.Float validar(Rectangle2D.Float rec) {
        if (rec.width < 0.0f || rec.height < 0.0f) {
            float x = rec.x;
            float y = rec.y;
            float w = rec.width;
            float h = rec.height;
            if (w < 0.0f) {
                x += w;
                w = Math.abs(w);
            }
            if (h < 0.0f) {
                y += h;
                h = Math.abs(h);
            }
            return new Rectangle2D.Float(x, y, w, h);
        }
        return rec;
    }

    private JMenuItem novoMenuItem(String titulo) {
        JMenuItem item = new JMenuItem(titulo);
        this.popupMenu.add(item);
        item.addActionListener(this);
        return item;
    }

    private void habilitarDesabilitarPopupMenu() {
        boolean maisDeUm = this.itens.size() > 1;
        boolean itemBanda = this.haSomenteItensDeBanda();
        this.jMIMoverTopo.setEnabled(itemBanda && !maisDeUm);
        this.jMIMoverCima.setEnabled(itemBanda && !maisDeUm);
        this.jMIMoverBaixo.setEnabled(itemBanda && !maisDeUm);
        this.jMIMoverBase.setEnabled(itemBanda && !maisDeUm);
        this.jMIAlinharEsquerda.setEnabled(itemBanda && maisDeUm);
        this.jMIAlinharCentro.setEnabled(itemBanda && maisDeUm);
        this.jMIAlinharDireita.setEnabled(itemBanda && maisDeUm);
        this.jMIAlinharTopo.setEnabled(itemBanda && maisDeUm);
        this.jMIAlinharMeio.setEnabled(itemBanda && maisDeUm);
        this.jMIAlinharBase.setEnabled(itemBanda && maisDeUm);
        this.jMIDistHori.setEnabled(itemBanda && maisDeUm);
        this.jMIDistVert.setEnabled(itemBanda && maisDeUm);
        this.jMIMesmaLargura.setEnabled(itemBanda && maisDeUm);
        this.jMIMesmaAltura.setEnabled(itemBanda && maisDeUm);
        this.jMIMesmaFonte.setEnabled(itemBanda && maisDeUm);
        this.jMIMesmaCorDaFonte.setEnabled(itemBanda && maisDeUm);
        this.jMIDuplicar.setEnabled(itemBanda);
        this.jMIRemover.setEnabled(!this.itens.contains(this.pagina));
    }

    private boolean haSomenteItensDeBanda() {
        for (Object o : this.itens) {
            if (o != this.pagina && !(o instanceof Banda)) continue;
            return false;
        }
        return true;
    }

    private void deslocarVerticalmente(int unidades) {
        if (this.haSomenteItensDeBanda() && this.modelo != null) {
            ItemSelecionavel[] tmp = this.itens.toArray(new ItemSelecionavel[this.itens.size()]);
            for (int i = 0; i < tmp.length; ++i) {
                Rectangle2D.Float r = tmp[i].getRetangulo2D();
                this.modelo.moverItem(tmp[i], new Rectangle2D.Float(r.x, r.y + (float)unidades, r.width, r.height));
            }
            this.fireDadosAlterados();
        }
    }

    private void deslocarHorizontalmente(int unidades) {
        if (this.haSomenteItensDeBanda() && this.modelo != null) {
            ItemSelecionavel[] tmp = this.itens.toArray(new ItemSelecionavel[this.itens.size()]);
            for (int i = 0; i < tmp.length; ++i) {
                Rectangle2D.Float r = tmp[i].getRetangulo2D();
                this.modelo.moverItem(tmp[i], new Rectangle2D.Float(r.x + (float)unidades, r.y, r.width, r.height));
            }
            this.fireDadosAlterados();
        }
    }

    private void redimensionarLargura(int unidades) {
        if (this.pagina != null && !this.itens.contains(this.pagina) && this.modelo != null) {
            ItemSelecionavel[] tmp = this.itens.toArray(new ItemSelecionavel[this.itens.size()]);
            for (int i = 0; i < tmp.length; ++i) {
                Rectangle2D.Float r = tmp[i].getRetangulo2D();
                this.modelo.moverItem(tmp[i], new Rectangle2D.Float(r.x, r.y, r.width + (float)unidades, r.height));
            }
            this.fireDadosAlterados();
        }
    }

    private void redimensionarAltura(int unidades) {
        if (this.pagina != null && !this.itens.contains(this.pagina) && this.modelo != null) {
            ItemSelecionavel[] tmp = this.itens.toArray(new ItemSelecionavel[this.itens.size()]);
            for (int i = 0; i < tmp.length; ++i) {
                Rectangle2D.Float r = tmp[i].getRetangulo2D();
                this.modelo.moverItem(tmp[i], new Rectangle2D.Float(r.x, r.y, r.width, r.height + (float)unidades));
            }
            this.fireDadosAlterados();
        }
    }

    private void removerItensSelecionados() {
        if (this.modelo != null) {
            ItemSelecionavel[] tmp = this.itens.toArray(new ItemSelecionavel[this.itens.size()]);
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i] == this.pagina || tmp[i] instanceof Banda && Funcoes.mensagem(null, "Deseja remover a banda " + ((Banda)tmp[i]).getNome() + "?", 4) != 0) continue;
                this.modelo.removerItem(tmp[i]);
                this.itens.remove(tmp[i]);
            }
            this.modelo.atualizarRetangulos();
            this.fireItemSelecionado();
        }
    }

    private Rectangle2D.Float grudarRetangulo(Rectangle2D.Float rec) {
        float x = rec.x;
        float y = rec.y;
        if (this.pagina != null) {
            int i;
            int ima = 5;
            int[] pos = this.pagina.getPosicaoLinhasHorizontais();
            for (i = 0; i < pos.length; ++i) {
                if (!(rec.y >= (float)(pos[i] - ima)) || !(rec.y <= (float)(pos[i] + ima))) continue;
                y = pos[i];
            }
            pos = this.pagina.getPosicaoLinhasVerticais();
            for (i = 0; i < pos.length; ++i) {
                if (!(rec.x >= (float)(pos[i] - ima)) || !(rec.x <= (float)(pos[i] + ima))) continue;
                x = pos[i];
            }
        }
        return new Rectangle2D.Float(x, y, rec.width, rec.height);
    }

    private void definirTeclas() {
        if (this.pagina != null) {
            ActionMap mapaAcao = this.pagina.getActionMap();
            InputMap mapaUm = this.pagina.getInputMap(0);
            InputMap mapaDois = this.pagina.getInputMap(2);
            InputMap mapaTres = this.pagina.getInputMap(1);
            KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
            KeyStroke f2 = KeyStroke.getKeyStroke(113, 0);
            KeyStroke ctrlD = KeyStroke.getKeyStroke(68, 2);
            KeyStroke cima = KeyStroke.getKeyStroke(38, 0);
            KeyStroke baixo = KeyStroke.getKeyStroke(40, 0);
            KeyStroke direita = KeyStroke.getKeyStroke(39, 0);
            KeyStroke esquerda = KeyStroke.getKeyStroke(37, 0);
            KeyStroke ctrlCima = KeyStroke.getKeyStroke(38, 2);
            KeyStroke ctrlBaixo = KeyStroke.getKeyStroke(40, 2);
            KeyStroke ctrlDireita = KeyStroke.getKeyStroke(39, 2);
            KeyStroke ctrlEsquerda = KeyStroke.getKeyStroke(37, 2);
            KeyStroke shiftCima = KeyStroke.getKeyStroke(38, 1);
            KeyStroke shiftBaixo = KeyStroke.getKeyStroke(40, 1);
            KeyStroke shiftDireita = KeyStroke.getKeyStroke(39, 1);
            KeyStroke shiftEsquerda = KeyStroke.getKeyStroke(37, 1);
            KeyStroke ctrlShiftCima = KeyStroke.getKeyStroke(38, 3);
            KeyStroke ctrlShiftBaixo = KeyStroke.getKeyStroke(40, 3);
            KeyStroke ctrlShiftDireita = KeyStroke.getKeyStroke(39, 3);
            KeyStroke ctrlShiftEsquerda = KeyStroke.getKeyStroke(37, 3);
            AbstractAction acaoDelete = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selecao.this.removerItensSelecionados();
                    Selecao.this.repintar();
                }
            };
            AbstractAction acaoF2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Selecao.this.itens.size() == 1) {
                        // empty if block
                    }
                }
            };
            AbstractAction acaoCtrlD = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selecao.this.duplicarItensSelecionados();
                    Selecao.this.repintar();
                }
            };
            AbstractAction acaoCima = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (e.getModifiers()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            Selecao.this.deslocarVerticalmente(-1);
                            break;
                        }
                        case 1: {
                            Selecao.this.redimensionarAltura(-1);
                            break;
                        }
                        case 3: {
                            Selecao.this.deslocarVerticalmente(-10);
                        }
                    }
                    Selecao.this.repintar();
                }
            };
            AbstractAction acaoBaixo = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (e.getModifiers()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            Selecao.this.deslocarVerticalmente(1);
                            break;
                        }
                        case 1: {
                            Selecao.this.redimensionarAltura(1);
                            break;
                        }
                        case 3: {
                            Selecao.this.deslocarVerticalmente(10);
                        }
                    }
                    Selecao.this.repintar();
                }
            };
            AbstractAction acaoDireita = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (e.getModifiers()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            Selecao.this.deslocarHorizontalmente(1);
                            break;
                        }
                        case 1: {
                            Selecao.this.redimensionarLargura(1);
                            break;
                        }
                        case 3: {
                            Selecao.this.deslocarHorizontalmente(10);
                        }
                    }
                    Selecao.this.repintar();
                }
            };
            AbstractAction acaoEsquerda = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (e.getModifiers()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            Selecao.this.deslocarHorizontalmente(-1);
                            break;
                        }
                        case 1: {
                            Selecao.this.redimensionarLargura(-1);
                            break;
                        }
                        case 3: {
                            Selecao.this.deslocarHorizontalmente(-10);
                        }
                    }
                    Selecao.this.repintar();
                }
            };
            mapaUm.put(delete, "delete");
            mapaDois.put(delete, "delete");
            mapaTres.put(delete, "delete");
            mapaUm.put(f2, "f2");
            mapaDois.put(f2, "f2");
            mapaTres.put(f2, "f2");
            mapaUm.put(ctrlD, "ctrl+D");
            mapaDois.put(ctrlD, "ctrl+D");
            mapaTres.put(ctrlD, "ctrl+D");
            mapaUm.put(cima, "cima");
            mapaDois.put(cima, "cima");
            mapaTres.put(cima, "cima");
            mapaUm.put(shiftCima, "cima");
            mapaDois.put(shiftCima, "cima");
            mapaTres.put(shiftCima, "cima");
            mapaUm.put(ctrlCima, "cima");
            mapaDois.put(ctrlCima, "cima");
            mapaTres.put(ctrlCima, "cima");
            mapaUm.put(ctrlShiftCima, "cima");
            mapaDois.put(ctrlShiftCima, "cima");
            mapaTres.put(ctrlShiftCima, "cima");
            mapaUm.put(baixo, "baixo");
            mapaDois.put(baixo, "baixo");
            mapaTres.put(baixo, "baixo");
            mapaUm.put(shiftBaixo, "baixo");
            mapaDois.put(shiftBaixo, "baixo");
            mapaTres.put(shiftBaixo, "baixo");
            mapaUm.put(ctrlBaixo, "baixo");
            mapaDois.put(ctrlBaixo, "baixo");
            mapaTres.put(ctrlBaixo, "baixo");
            mapaUm.put(ctrlShiftBaixo, "baixo");
            mapaDois.put(ctrlShiftBaixo, "baixo");
            mapaTres.put(ctrlShiftBaixo, "baixo");
            mapaUm.put(direita, "direita");
            mapaDois.put(direita, "direita");
            mapaTres.put(direita, "direita");
            mapaUm.put(shiftDireita, "direita");
            mapaDois.put(shiftDireita, "direita");
            mapaTres.put(shiftDireita, "direita");
            mapaUm.put(ctrlDireita, "direita");
            mapaDois.put(ctrlDireita, "direita");
            mapaTres.put(ctrlDireita, "direita");
            mapaUm.put(ctrlShiftDireita, "direita");
            mapaDois.put(ctrlShiftDireita, "direita");
            mapaTres.put(ctrlShiftDireita, "direita");
            mapaUm.put(esquerda, "esquerda");
            mapaDois.put(esquerda, "esquerda");
            mapaTres.put(esquerda, "esquerda");
            mapaUm.put(shiftEsquerda, "esquerda");
            mapaDois.put(shiftEsquerda, "esquerda");
            mapaTres.put(shiftEsquerda, "esquerda");
            mapaUm.put(ctrlEsquerda, "esquerda");
            mapaDois.put(ctrlEsquerda, "esquerda");
            mapaTres.put(ctrlEsquerda, "esquerda");
            mapaUm.put(ctrlShiftEsquerda, "esquerda");
            mapaDois.put(ctrlShiftEsquerda, "esquerda");
            mapaTres.put(ctrlShiftEsquerda, "esquerda");
            mapaAcao.put("delete", acaoDelete);
            mapaAcao.put("f2", acaoF2);
            mapaAcao.put("ctrl+D", acaoCtrlD);
            mapaAcao.put("cima", acaoCima);
            mapaAcao.put("baixo", acaoBaixo);
            mapaAcao.put("direita", acaoDireita);
            mapaAcao.put("esquerda", acaoEsquerda);
        }
    }

    private void fireItemSelecionado() {
        Object[] tmp = this.ouvintes.getListenerList();
        for (int i = 0; i <= tmp.length - 2; i += 2) {
            if (tmp[i] != SelecaoListener.class) continue;
            ((SelecaoListener)tmp[i + 1]).itemSelecionado(new ChangeEvent(this));
        }
    }

    private void fireDadosAlterados() {
        Object[] tmp = this.ouvintes.getListenerList();
        for (int i = 0; i <= tmp.length - 2; i += 2) {
            if (tmp[i] != SelecaoListener.class) continue;
            ((SelecaoListener)tmp[i + 1]).dadosAlterados(new ChangeEvent(this));
        }
    }

    private void repintar() {
        if (this.pagina != null) {
            this.pagina.repaint();
        }
    }

    private Point getPontoRelativo(Point pt) {
        double zoom = this.pagina.getZoom();
        return new Point((int)((double)pt.x / zoom), (int)((double)pt.y / zoom));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

