/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor;

import jalis.relatorio.editor.Constantes;
import jalis.relatorio.editor.LinhaGuia;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;

public class Regua
extends JComponent
implements MouseListener,
MouseMotionListener {
    private int tipo;
    private float[] margens = new float[2];
    private float comprimento;
    private int xyOffset;
    private int margemOffset;
    private double zoom = 1.0;
    private boolean redimensionando = false;
    private ArrayList linhas;
    private boolean exibirLinhasGuias = true;

    public Regua(int tipo) {
        this.tipo = tipo;
        this.linhas = new ArrayList();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
        this.atualizarTamanho();
    }

    public void setExibirLinhasGuias(boolean mostrar) {
        this.exibirLinhasGuias = mostrar;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public void setComprimento(float comprimento) {
        this.comprimento = comprimento;
        this.atualizarTamanho();
    }

    public void setMargens(float a, float b) {
        this.margens[0] = a;
        this.margens[1] = b;
    }

    public float[] getMargens() {
        return this.margens;
    }

    public void adicionarLinhaGuia(LinhaGuia linha) {
        if (this.tipo == 4 && linha.vertical() || this.tipo == 5 && linha.horizontal()) {
            this.linhas.add(linha);
        }
    }

    public void removerLinhaGuia(LinhaGuia linha) {
        if (this.linhas.contains(linha)) {
            this.linhas.remove(linha);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        ((Graphics2D)g).scale(this.zoom, this.zoom);
        Rectangle area = g.getClipBounds();
        g.setColor(Color.lightGray);
        g.fillRect(area.x, area.y, area.width, area.height);
        this.desenharRegua(g);
        this.desenharNumeros(g);
        if (this.exibirLinhasGuias) {
            this.desenharLinhasGuias(g);
        }
    }

    private void atualizarTamanho() {
        int tmp = (int)ScreenUtil.getPixelsDeCentimetros(this.comprimento) + 40;
        if (this.tipo == 4) {
            this.setPreferredSize(new Dimension((int)((double)tmp * this.zoom), (int)(25.0 * this.zoom)));
        } else {
            this.setPreferredSize(new Dimension((int)(25.0 * this.zoom), (int)((double)tmp * this.zoom)));
        }
    }

    private void desenharRegua(Graphics g) {
        int mg1 = (int)ScreenUtil.getPixelsDeCentimetros(this.margens[0]);
        int mg2 = (int)ScreenUtil.getPixelsDeCentimetros(this.margens[1]);
        int comp = (int)ScreenUtil.getPixelsDeCentimetros(this.comprimento);
        int dif = mg1 + mg2;
        if (this.tipo == 4) {
            int h = (int)((double)this.getHeight() / this.zoom - 10.0);
            g.setColor(Color.white);
            g.fillRect(20 + mg1, 5, comp - dif, h);
            g.setColor(Color.gray);
            g.drawRect(20, 5, mg1, h);
            g.drawRect(20 + comp - mg2, 5, mg2, h);
        } else {
            int w = (int)((double)this.getWidth() / this.zoom - 10.0);
            g.setColor(Color.white);
            g.fillRect(5, 20 + mg1, w, comp - dif);
            g.setColor(Color.gray);
            g.drawRect(5, 20, w, mg1);
            g.drawRect(5, 20 + comp - mg2, w, mg2);
        }
    }

    private void desenharNumeros(Graphics g) {
        g.setFont(new Font("SansSerif", 0, 10));
        g.setColor(Color.black);
        FontMetrics fm = g.getFontMetrics();
        int numero = 0;
        int flag = 0;
        int comp = (int)ScreenUtil.getPixelsDeCentimetros(this.comprimento);
        int width = (int)((double)this.getWidth() / this.zoom);
        int height = (int)((double)this.getHeight() / this.zoom);
        double incremento = 14.1732285;
        float i = 20.0f;
        while ((int)i <= 20 + comp) {
            int y;
            int x;
            if (flag % 2 == 0) {
                String str = Integer.toString(numero);
                if (this.tipo == 4) {
                    x = (int)(i - (float)(fm.stringWidth(str) / 2));
                    y = (height + fm.getHeight()) / 2 - 2;
                } else {
                    x = (width - fm.stringWidth(str)) / 2 + 1;
                    y = (int)(i + (float)(fm.getHeight() / 2) - 2.0f);
                }
                g.drawString(Integer.toString(numero), x, y);
                ++numero;
            } else if (this.tipo == 4) {
                y = (height - 3) / 2;
                g.drawLine((int)i, y, (int)i, y + 3);
            } else {
                x = (width - 3) / 2;
                g.drawLine(x, (int)i, x + 3, (int)i);
            }
            ++flag;
            i = (float)((double)i + incremento);
        }
    }

    private void desenharLinhasGuias(Graphics g) {
        block3: {
            int w;
            LinhaGuia[] lns;
            block2: {
                lns = this.linhas.toArray(new LinhaGuia[this.linhas.size()]);
                g.setColor(Color.red);
                int h = (int)((double)this.getHeight() / this.zoom);
                w = (int)((double)this.getWidth() / this.zoom);
                if (this.tipo != 4) break block2;
                for (int i = 0; i < lns.length; ++i) {
                    g.drawLine(lns[i].getPosicao(), 0, lns[i].getPosicao(), h);
                }
                break block3;
            }
            if (this.tipo != 5) break block3;
            for (int i = 0; i < lns.length; ++i) {
                g.drawLine(0, lns[i].getPosicao(), w, lns[i].getPosicao());
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int tmp1 = 20 + (int)ScreenUtil.getPixelsDeCentimetros(this.margens[0]);
        int tmp2 = 20 + (int)ScreenUtil.getPixelsDeCentimetros(this.comprimento - this.margens[1]);
        Point pt = this.getPontoRelativo(e.getPoint());
        if (this.tipo == 4 && e.getY() > 5 && e.getY() < this.getHeight() - 5) {
            if (pt.x > tmp1 - 2 && pt.x < tmp1 + 2) {
                this.setCursor(Constantes.REDIMENSIONA_OESTE);
            } else if (pt.x > tmp2 - 2 && pt.x < tmp2 + 2) {
                this.setCursor(Constantes.REDIMENSIONA_LESTE);
            } else {
                this.setCursor(Constantes.SETA);
            }
        } else if (this.tipo == 5 && pt.x > 5 && pt.x < this.getWidth() - 5) {
            if (pt.y > tmp1 - 2 && pt.y < tmp1 + 2) {
                this.setCursor(Constantes.REDIMENSIONA_NORTE);
            } else if (pt.y > tmp2 - 2 && pt.y < tmp2 + 2) {
                this.setCursor(Constantes.REDIMENSIONA_SUL);
            } else {
                this.setCursor(Constantes.SETA);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point pt = this.getPontoRelativo(e.getPoint());
        if (this.tipo == 4) {
            if (this.getCursor() == Constantes.REDIMENSIONA_LESTE || this.getCursor() == Constantes.REDIMENSIONA_OESTE) {
                this.redimensionando = true;
                this.xyOffset = pt.x;
                this.margemOffset = (int)ScreenUtil.getPixelsDeCentimetros(this.margens[this.getCursor() == Constantes.REDIMENSIONA_OESTE ? 0 : 1]);
            }
        } else if (this.tipo == 5 && (this.getCursor() == Constantes.REDIMENSIONA_NORTE || this.getCursor() == Constantes.REDIMENSIONA_SUL)) {
            this.redimensionando = true;
            this.xyOffset = pt.y;
            this.margemOffset = (int)ScreenUtil.getPixelsDeCentimetros(this.margens[this.getCursor() == Constantes.REDIMENSIONA_NORTE ? 0 : 1]);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.redimensionando) {
            int tmp;
            int comp = (int)ScreenUtil.getPixelsDeCentimetros(this.comprimento);
            int mg1 = (int)ScreenUtil.getPixelsDeCentimetros(this.margens[0]);
            int mg2 = (int)ScreenUtil.getPixelsDeCentimetros(this.margens[1]);
            Point pt = this.getPontoRelativo(e.getPoint());
            if (this.getCursor() == Constantes.REDIMENSIONA_OESTE) {
                int tmp2 = this.margemOffset + pt.x - this.xyOffset;
                if (tmp2 >= 0 && comp - mg2 - tmp2 >= 10) {
                    this.margens[0] = ScreenUtil.getCentimetros(tmp2);
                    this.fireActionPerformed(0);
                }
            } else if (this.getCursor() == Constantes.REDIMENSIONA_LESTE) {
                int tmp3 = this.margemOffset - pt.x + this.xyOffset;
                if (tmp3 >= 0 && comp - mg1 - tmp3 >= 10) {
                    this.margens[1] = ScreenUtil.getCentimetros(tmp3);
                    this.fireActionPerformed(1);
                }
            } else if (this.getCursor() == Constantes.REDIMENSIONA_NORTE) {
                int tmp4 = this.margemOffset + pt.y - this.xyOffset;
                if (tmp4 >= 0 && comp - mg2 - tmp4 >= 10) {
                    this.margens[0] = ScreenUtil.getCentimetros(tmp4);
                    this.fireActionPerformed(2);
                }
            } else if (this.getCursor() == Constantes.REDIMENSIONA_SUL && (tmp = this.margemOffset - pt.y + this.xyOffset) >= 0 && comp - mg1 - tmp >= 10) {
                this.margens[1] = ScreenUtil.getCentimetros(tmp);
                this.fireActionPerformed(3);
            }
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.redimensionando = false;
    }

    private Point getPontoRelativo(Point pt) {
        int x = (int)((double)pt.x / this.zoom);
        int y = (int)((double)pt.y / this.zoom);
        return new Point(x, y);
    }

    private void fireActionPerformed(int margem) {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = 0; i <= ouvintes.length - 2; i += 2) {
            if (ouvintes[i] != ActionListener.class) continue;
            ActionListener acao = (ActionListener)ouvintes[i + 1];
            acao.actionPerformed(new ActionEvent(this, margem, ""));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

