/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor;

import jalis.relatorio.editor.Pagina;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class PreSelecao {
    private ItemSelecionavel item;
    private Pagina pagina;

    public PreSelecao(Pagina pagina) {
        this.pagina = pagina;
    }

    public void preSelecionar(ItemSelecionavel item) {
        if (this.item != item && this.pagina != null) {
            this.removerPreSelecao();
            this.item = item;
            this.pagina.repaint(ScreenUtil.getRetanguloDeSelecao(item.getRetangulo()));
        }
    }

    public void removerPreSelecao() {
        if (this.item != null) {
            Rectangle rec = ScreenUtil.getRetanguloDeSelecao(this.item.getRetangulo());
            this.item = null;
            this.pagina.repaint(rec);
        }
    }

    public ItemSelecionavel itemSelecionado() {
        return this.item;
    }

    public void pintar(Graphics g) {
        Rectangle r;
        if (this.item != null && !(r = ScreenUtil.getRetanguloDeSelecao(this.item.getRetangulo())).isEmpty()) {
            g.setColor(Color.red);
            g.fillRect(r.x, r.y, 5, 5);
            g.fillRect(r.x + r.width - 5, r.y, 5, 5);
            g.fillRect(r.x, r.y + r.height - 5, 5, 5);
            g.fillRect(r.x + r.width - 5, r.y + r.height - 5, 5, 5);
        }
    }
}

