/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.relatorio.editor.Constantes;
import jalis.relatorio.editor.FormatoPagina;
import jalis.relatorio.editor.LinhaGuia;
import jalis.relatorio.editor.ModeloArvore;
import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.PreSelecao;
import jalis.relatorio.editor.Regua;
import jalis.relatorio.editor.Selecao;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.propriedade.Editavel;
import jalis.relatorio.editor.propriedade.EditorBoolean;
import jalis.relatorio.editor.propriedade.EditorCentimetros;
import jalis.relatorio.editor.propriedade.EditorFormatoPagina;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class Pagina
extends JComponent
implements ActionListener,
ItemSelecionavel,
Editavel,
Scrollable {
    private final Regua reguaHoriz = new Regua(4);
    private final Regua reguaVerti = new Regua(5);
    private float[] margens = new float[]{1.5f, 1.5f, 1.5f, 1.5f};
    private String[] campos = new String[0];
    private String[] variaveis = new String[0];
    private double zoom = 1.0;
    private FormatoPagina formato = new FormatoPagina();
    private ModeloPagina modelo;
    private PreSelecao preSelecao;
    private Selecao selecao;
    private ArrayList linhas;
    private Class itemEmCriacao;
    private boolean exibirLinhasGuias = true;
    private boolean forcarRetrato = false;
    private Map<Integer, List<Componente>> itens;

    public Pagina() {
        this.reguaHoriz.setComprimento(this.formato.getTamanho()[0]);
        this.reguaHoriz.setMargens(this.margens[0], this.margens[1]);
        this.reguaHoriz.addActionListener(this);
        this.reguaVerti.setComprimento(this.formato.getTamanho()[1]);
        this.reguaVerti.setMargens(this.margens[2], this.margens[3]);
        this.reguaVerti.addActionListener(this);
        this.modelo = new ModeloArvore(new DefaultMutableTreeNode(this));
        this.modelo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Pagina.this.selecao.selecionarPaths();
            }
        });
        this.preSelecao = new PreSelecao(this);
        this.selecao = new Selecao(this, this.preSelecao);
        this.linhas = new ArrayList();
        this.itemEmCriacao = null;
        this.atualizarTamanho();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public double getZoom() {
        return this.zoom;
    }

    public boolean getExibirLinhasGuias() {
        return this.exibirLinhasGuias;
    }

    public void setExibirLinhasGuias(boolean mostrar) {
        this.exibirLinhasGuias = mostrar;
        this.reguaHoriz.setExibirLinhasGuias(mostrar);
        this.reguaVerti.setExibirLinhasGuias(mostrar);
        this.repintarScrollPane();
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
        this.reguaHoriz.setZoom(zoom);
        this.reguaVerti.setZoom(zoom);
        this.atualizarTamanho();
    }

    public Regua getReguaHorizontal() {
        return this.reguaHoriz;
    }

    public Regua getReguaVertical() {
        return this.reguaVerti;
    }

    public ModeloArvore getModeloArvore() {
        return (ModeloArvore)this.modelo;
    }

    public Selecao getComponenteSelecao() {
        return this.selecao;
    }

    public String[] getCamposDoBanco() {
        return this.campos;
    }

    public void setCamposDoBanco(String[] campos) {
        this.campos = campos;
    }

    public String[] getVariaveis() {
        return this.variaveis;
    }

    public void setVariaveis(String[] variaveis) {
        this.variaveis = variaveis;
    }

    public List<Componente> getComponentes() {
        ArrayList<Componente> retorno = new ArrayList<Componente>();
        for (Integer pagina : this.itens.keySet()) {
            retorno.addAll((Collection<Componente>)this.itens.get(pagina));
        }
        return retorno;
    }

    @Override
    public Object[] getPropriedades() {
        return new Object[]{"altura", EditorCentimetros.class, "largura", EditorCentimetros.class, "margem esquerda", EditorCentimetros.class, "margem direita", EditorCentimetros.class, "margem superior", EditorCentimetros.class, "margem inferior", EditorCentimetros.class, "for\u00e7ar retrato", EditorBoolean.class, "formato", EditorFormatoPagina.class};
    }

    public void adicionarLinhaGuia(LinhaGuia linha) {
        if (linha.horizontal()) {
            this.reguaVerti.adicionarLinhaGuia(linha);
        } else if (linha.vertical()) {
            this.reguaHoriz.adicionarLinhaGuia(linha);
        }
        this.linhas.add(linha);
    }

    public void removerLinhaGuia(LinhaGuia linha) {
        if (linha.horizontal()) {
            this.reguaVerti.removerLinhaGuia(linha);
        } else if (linha.vertical()) {
            this.reguaHoriz.removerLinhaGuia(linha);
        }
        if (this.linhas.contains(linha)) {
            this.linhas.remove(linha);
        }
    }

    public LinhaGuia[] getLinhasGuias() {
        return this.linhas.toArray(new LinhaGuia[this.linhas.size()]);
    }

    public LinhaGuia[] getLinhasHorizontais() {
        ArrayList<LinhaGuia> lns = new ArrayList<LinhaGuia>();
        for (LinhaGuia linha : this.linhas) {
            if (!linha.horizontal()) continue;
            lns.add(linha);
        }
        return lns.toArray(new LinhaGuia[lns.size()]);
    }

    public LinhaGuia[] getLinhasVerticais() {
        ArrayList<LinhaGuia> lns = new ArrayList<LinhaGuia>();
        for (LinhaGuia linha : this.linhas) {
            if (!linha.vertical()) continue;
            lns.add(linha);
        }
        return lns.toArray(new LinhaGuia[lns.size()]);
    }

    public int[] getPosicaoLinhasHorizontais() {
        LinhaGuia[] lns = this.getLinhasHorizontais();
        int[] pos = new int[lns.length];
        for (int i = 0; i < lns.length; ++i) {
            pos[i] = lns[i].getPosicao();
        }
        return pos;
    }

    public int[] getPosicaoLinhasVerticais() {
        LinhaGuia[] lns = this.getLinhasVerticais();
        int[] pos = new int[lns.length];
        for (int i = 0; i < lns.length; ++i) {
            pos[i] = lns[i].getPosicao();
        }
        return pos;
    }

    public LinhaGuia getLinhaGuiaNaPosicao(Point pt) {
        int prox = 3;
        for (LinhaGuia ln : this.linhas) {
            int pos = ln.getPosicao();
            if ((!ln.horizontal() || pt.y < pos - prox || pt.y > pos + prox) && (!ln.vertical() || pt.x < pos - prox || pt.x > pos + prox)) continue;
            return ln;
        }
        return null;
    }

    public void setLargura(float largura) {
        this.formato.setTamanho(new float[]{largura, this.formato.getTamanho()[1]});
        this.atualizarTamanho();
    }

    public float getLargura() {
        return this.formato.getTamanho()[0];
    }

    public void setAltura(float altura) {
        this.formato.setTamanho(new float[]{this.formato.getTamanho()[0], altura});
        this.atualizarTamanho();
    }

    public float getAltura() {
        return this.formato.getTamanho()[1];
    }

    public MediaSizeName getFormato() {
        return this.formato.getFormato();
    }

    public void setFormato(MediaSizeName formato) {
        this.formato.setFormato(formato);
        this.atualizarTamanho();
    }

    public boolean getForcarRetrato() {
        return this.forcarRetrato;
    }

    public void setForcarRetrato(boolean b) {
        this.forcarRetrato = b;
        this.atualizarTamanho();
    }

    public void setMargemEsquerda(float margem) {
        this.margens[0] = margem;
        this.reguaHoriz.setMargens(this.margens[0], this.margens[1]);
        this.modelo.atualizarRetangulos();
        this.repintarScrollPane();
    }

    public float getMargemEsquerda() {
        return this.margens[0];
    }

    public void setMargemDireita(float margem) {
        this.margens[1] = margem;
        this.reguaHoriz.setMargens(this.margens[0], this.margens[1]);
        this.modelo.atualizarRetangulos();
        this.repintarScrollPane();
    }

    public float getMargemDireita() {
        return this.margens[1];
    }

    public void setMargemSuperior(float margem) {
        this.margens[2] = margem;
        this.reguaVerti.setMargens(this.margens[2], this.margens[3]);
        this.modelo.atualizarRetangulos();
        this.repintarScrollPane();
    }

    public float getMargemSuperior() {
        return this.margens[2];
    }

    public void setMargemInferior(float margem) {
        this.margens[3] = margem;
        this.reguaVerti.setMargens(this.margens[2], this.margens[3]);
        this.modelo.atualizarRetangulos();
        this.repintarScrollPane();
    }

    public float getMargemInferior() {
        return this.margens[3];
    }

    public int[] getMargensEmPixels() {
        return new int[]{(int)ScreenUtil.getPixelsDeCentimetros(this.margens[0]), (int)ScreenUtil.getPixelsDeCentimetros(this.margens[1]), (int)ScreenUtil.getPixelsDeCentimetros(this.margens[2]), (int)ScreenUtil.getPixelsDeCentimetros(this.margens[3])};
    }

    public int[] getTamanhoEmPixels() {
        return new int[]{(int)ScreenUtil.getPixelsDeCentimetros(this.formato.getTamanho()[0]), (int)ScreenUtil.getPixelsDeCentimetros(this.formato.getTamanho()[1])};
    }

    public boolean haItemEmCriacao() {
        return this.itemEmCriacao != null;
    }

    public Class getItemParaCriar() {
        return this.itemEmCriacao;
    }

    public void setItemParaCriar(Class item) {
        this.itemEmCriacao = item;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int[] tam = this.getTamanhoEmPixels();
        int[] marg = this.getMargensEmPixels();
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.zoom, this.zoom);
        double incremento = 14.1732285;
        int flag = 0;
        g2.setColor(Color.white);
        g2.fillRect(20, 20, tam[0], tam[1]);
        double i = 20.0;
        while ((int)i < tam[0]) {
            g2.setColor(flag % 2 == 0 ? Constantes.COR_LINHA_UM_CENTIMETRO : Constantes.COR_LINHA_MEIO_CENTIMETRO);
            g2.drawLine((int)i, 20, (int)i, 20 + tam[1]);
            ++flag;
            i += incremento;
        }
        flag = 0;
        i = 20.0;
        while ((int)i < tam[1]) {
            g2.setColor(flag % 2 == 0 ? Constantes.COR_LINHA_UM_CENTIMETRO : Constantes.COR_LINHA_MEIO_CENTIMETRO);
            g2.drawLine(20, (int)i, 20 + tam[0], (int)i);
            ++flag;
            i += incremento;
        }
        g2.setColor(Color.black);
        g2.drawRect(20, 20, tam[0], tam[1]);
        g2.setColor(Color.gray);
        g2.fillRect(20 + tam[0] + 1, 24, 3, tam[1]);
        g2.fillRect(24, 20 + tam[1] + 1, tam[0], 3);
        Stroke tmp = g2.getStroke();
        g2.setStroke(Constantes.TRACEJADO);
        g2.setColor(Color.blue);
        g2.drawRect(20 + marg[0], 20 + marg[2], tam[0] - marg[0] - marg[1], tam[1] - marg[2] - marg[3]);
        g2.setStroke(tmp);
        if (this.exibirLinhasGuias) {
            int i2;
            g2.setColor(Color.red);
            int[] lns = this.getPosicaoLinhasHorizontais();
            int w = (int)((double)this.getWidth() / this.zoom);
            int h = (int)((double)this.getHeight() / this.zoom);
            for (i2 = 0; i2 < lns.length; ++i2) {
                g2.drawLine(0, lns[i2], w, lns[i2]);
            }
            lns = this.getPosicaoLinhasVerticais();
            for (i2 = 0; i2 < lns.length; ++i2) {
                g2.drawLine(lns[i2], 0, lns[i2], h);
            }
        }
        this.modelo.repintar(g);
        this.preSelecao.pintar(g);
        this.selecao.pintar(g);
    }

    @Override
    public Rectangle getRetangulo() {
        int[] tam = this.getTamanhoEmPixels();
        return new Rectangle(20, 20, tam[0], tam[1]);
    }

    @Override
    public Rectangle2D.Float getRetangulo2D() {
        Rectangle rec = this.getRetangulo();
        return new Rectangle2D.Float(rec.x, rec.y, rec.width, rec.height);
    }

    public Rectangle getAreaImprimivel() {
        int[] tam = this.getTamanhoEmPixels();
        int[] marg = this.getMargensEmPixels();
        int tmp = 20;
        return new Rectangle(tmp + marg[0], tmp + marg[2], tam[0] - marg[0] - marg[1], tam[1] - marg[2] - marg[3]);
    }

    @Override
    public boolean redimensionavel() {
        return false;
    }

    @Override
    public String toString() {
        return "p\u00e1gina";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o instanceof Regua) {
            Regua regua = (Regua)o;
            switch (e.getID()) {
                case 0: {
                    this.margens[0] = regua.getMargens()[0];
                    break;
                }
                case 1: {
                    this.margens[1] = regua.getMargens()[1];
                    break;
                }
                case 2: {
                    this.margens[2] = regua.getMargens()[0];
                    break;
                }
                case 3: {
                    this.margens[3] = regua.getMargens()[1];
                }
            }
            this.modelo.atualizarRetangulos();
            this.repaint();
            this.fireStateChanged();
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 200;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 25;
    }

    private void repintarScrollPane() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (c instanceof JViewport) {
                JViewport view = (JViewport)c;
                view.repaint();
                continue;
            }
            if (!(c instanceof JScrollPane)) continue;
            JScrollPane scroll = (JScrollPane)c;
            scroll.getColumnHeader().repaint();
            scroll.getRowHeader().repaint();
            break;
        }
    }

    private void atualizarTamanho() {
        int[] tam = this.getTamanhoEmPixels();
        Dimension dim = new Dimension(tam[0] + 40, tam[1] + 40);
        this.setPreferredSize(new Dimension((int)((double)dim.width * this.zoom), (int)((double)dim.height * this.zoom)));
        this.setSize(new Dimension((int)((double)dim.width * this.zoom), (int)((double)dim.height * this.zoom)));
        this.reguaHoriz.setComprimento(this.formato.getTamanho()[0]);
        this.reguaVerti.setComprimento(this.formato.getTamanho()[1]);
        if (this.modelo != null) {
            this.modelo.atualizarRetangulos();
            this.modelo.revalidarItens();
        }
        this.repintarScrollPane();
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = 0; i <= ouvintes.length - 2; i += 2) {
            if (ouvintes[i] != ChangeListener.class) continue;
            ((ChangeListener)ouvintes[i + 1]).stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public Font getFonte() {
        return null;
    }

    @Override
    public void setFonte(Font fonte) {
    }

    @Override
    public Color getCorDaFonte() {
        return null;
    }

    @Override
    public void setCorDaFonte(Color cor) {
    }

    @Override
    public void setRetangulo(Rectangle retangulo) {
    }

    @Override
    public void setRetangulo2D(Rectangle2D.Float retangulo) {
    }

    @Override
    public void copiarAtributosDe(ItemSelecionavel item) {
    }
}

