/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor;

import jalis.relatorio.editor.Constantes;
import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.Pagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.item.Banda;
import jalis.relatorio.editor.item.ItemInvalido;
import jalis.relatorio.editor.item.ItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ModeloArvore
extends DefaultTreeModel
implements ModeloPagina {
    private MutableTreeNode noInvalido = (MutableTreeNode)new ItemInvalido().getTreeNode();
    private JTree arvore;

    public ModeloArvore(TreeNode root) {
        super(root);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    @Override
    public ItemSelecionavel getItemNoPonto(Point ponto) {
        ItemSelecionavel item = null;
        DefaultMutableTreeNode[] nos = this.getTodosOsNos();
        for (int i = 0; i < nos.length; ++i) {
            ItemSelecionavel tmp;
            if (nos[i] == this.noInvalido || !(tmp = (ItemSelecionavel)nos[i].getUserObject()).getRetangulo().contains(ponto) || item != null && !this.menor(tmp.getRetangulo(), item.getRetangulo())) continue;
            item = tmp;
        }
        return item;
    }

    @Override
    public ItemSelecionavel getBandaNoPonto(Point ponto) {
        DefaultMutableTreeNode[] nos = this.getTodosOsNos();
        for (int i = 0; i < nos.length; ++i) {
            ItemSelecionavel item;
            if (nos[i] == this.noInvalido || !((item = (ItemSelecionavel)nos[i].getUserObject()) instanceof Banda) || !item.getRetangulo().contains(ponto)) continue;
            return item;
        }
        return null;
    }

    @Override
    public void moverItem(ItemSelecionavel item, Rectangle2D.Float retangulo) {
        if (item instanceof ItemModelo && retangulo != null) {
            ItemModelo bandaNoLocal = (ItemModelo)this.getBandaNoPonto(new Point((int)retangulo.x, (int)retangulo.y));
            DefaultMutableTreeNode raiz = (DefaultMutableTreeNode)this.root;
            DefaultMutableTreeNode noDoItem = (DefaultMutableTreeNode)((ItemModelo)item).getTreeNode();
            if (item instanceof Banda) {
                Banda banda = (Banda)item;
                if (bandaNoLocal != item && noDoItem.getParent() != null) {
                    this.removeNodeFromParent(noDoItem);
                }
                if (bandaNoLocal == null) {
                    int indice = raiz.getIndex(this.noInvalido);
                    this.insertNodeInto(noDoItem, raiz, indice > -1 ? indice : raiz.getChildCount());
                } else if (bandaNoLocal != item) {
                    this.insertNodeInto(noDoItem, raiz, raiz.getIndex(bandaNoLocal.getTreeNode()) + 1);
                }
                banda.setRetangulo2D(retangulo);
                this.atualizarRetangulos();
                this.revalidarItens();
            } else if (item instanceof ItemModelo) {
                ((ItemModelo)item).setRetangulo2D(retangulo);
                this.validarItem(item);
                this.insereRemoveNoInvalido();
            }
            this.expandirTodosOsNos();
            this.fireStateChanged();
        }
    }

    @Override
    public ItemSelecionavel instanciarItem(Class tipo, Point ponto) {
        ItemModelo item = null;
        if (ItemModelo.class.isAssignableFrom(tipo) && tipo != Pagina.class) {
            try {
                Constructor constructor = tipo.getConstructor(ModeloPagina.class);
                if (constructor != null) {
                    item = (ItemModelo)constructor.newInstance(this);
                    Rectangle2D.Float rec = item.getRetangulo2D();
                    this.moverItem(item, new Rectangle2D.Float(ponto.x, ponto.y, rec.width, rec.height));
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ModeloArvore: 164");
            }
        }
        return item;
    }

    @Override
    public ItemSelecionavel[] getBandas() {
        ArrayList<Object> bandas = new ArrayList<Object>();
        if (this.root != null) {
            Enumeration<? extends TreeNode> e = this.root.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode no = (DefaultMutableTreeNode)e.nextElement();
                if (no == this.noInvalido) continue;
                bandas.add(no.getUserObject());
            }
        }
        return bandas.toArray(new ItemModelo[bandas.size()]);
    }

    @Override
    public ItemSelecionavel[] getItensBanda(ItemSelecionavel banda) {
        TreeNode noBanda;
        ArrayList<Object> itens = new ArrayList<Object>();
        if (banda instanceof ItemModelo && (noBanda = ((ItemModelo)banda).getTreeNode()) != null) {
            Enumeration<? extends TreeNode> e = noBanda.children();
            while (e.hasMoreElements()) {
                itens.add(((DefaultMutableTreeNode)e.nextElement()).getUserObject());
            }
        }
        return itens.toArray(new ItemModelo[itens.size()]);
    }

    @Override
    public void atualizarRetangulos() {
        if (this.root != null && ((DefaultMutableTreeNode)this.root).getUserObject() instanceof Pagina) {
            DefaultMutableTreeNode raiz = (DefaultMutableTreeNode)this.root;
            ItemSelecionavel[] bandas = this.getBandas();
            if (bandas.length > 0) {
                int i;
                if (this.noInvalido.getParent() != null) {
                    this.removeNodeFromParent(this.noInvalido);
                }
                ArrayList[] arr = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
                block8: for (i = 0; i < bandas.length; ++i) {
                    Banda bd = (Banda)bandas[i];
                    DefaultMutableTreeNode no = (DefaultMutableTreeNode)bd.getTreeNode();
                    if (no.getParent() != null) {
                        this.removeNodeFromParent(no);
                    }
                    switch (bd.getTipo()) {
                        case 0: {
                            arr[0].add(no);
                            continue block8;
                        }
                        case 1: {
                            arr[1].add(no);
                            continue block8;
                        }
                        case 2: {
                            arr[2].add(no);
                            continue block8;
                        }
                        case 3: {
                            arr[3].add(no);
                            continue block8;
                        }
                        case 4: {
                            arr[4].add(no);
                            continue block8;
                        }
                        case 5: {
                            arr[5].add(no);
                        }
                    }
                }
                for (i = 0; i < arr.length; ++i) {
                    Iterator itr = arr[i].iterator();
                    while (itr.hasNext()) {
                        this.insertNodeInto((MutableTreeNode)itr.next(), raiz, raiz.getChildCount());
                    }
                }
                this.insereRemoveNoInvalido();
                this.expandirTodosOsNos();
            }
            Pagina pag = (Pagina)((DefaultMutableTreeNode)this.root).getUserObject();
            int[] marg = pag.getMargensEmPixels();
            int[] tam = pag.getTamanhoEmPixels();
            int x = 20 + marg[0];
            int y = 20 + marg[2];
            int w = tam[0] - marg[0] - marg[1];
            int h = tam[1] - marg[2] - marg[3];
            Enumeration<? extends TreeNode> e = this.root.children();
            while (e.hasMoreElements()) {
                Object o = ((DefaultMutableTreeNode)e.nextElement()).getUserObject();
                if (!(o instanceof Banda)) continue;
                ItemModelo banda = (ItemModelo)o;
                float height = banda.getRetangulo2D().height;
                banda.setRetangulo2D(new Rectangle2D.Float(x, y, w, (int)height > h ? (float)h : height));
                y = (int)((float)y + height);
                h = (int)((float)h - height);
                ItemModelo[] itens = (ItemModelo[])this.getItensBanda(banda);
                for (int i = 0; i < itens.length; ++i) {
                    itens[i].atualizarRetangulo();
                }
            }
        }
    }

    @Override
    public void repintar(Graphics g) {
        int i;
        ItemModelo[] bandas = (ItemModelo[])this.getBandas();
        for (i = 0; i < bandas.length; ++i) {
            bandas[i].pintar(g);
        }
        this.pintarConexoesBanda(g, bandas);
        for (i = 0; i < bandas.length; ++i) {
            ItemModelo[] itens = (ItemModelo[])this.getItensBanda(bandas[i]);
            for (int j = 0; j < itens.length; ++j) {
                itens[j].pintar(g);
            }
        }
        if (this.haItensInvalidos()) {
            Enumeration<? extends TreeNode> e = this.noInvalido.children();
            while (e.hasMoreElements()) {
                ItemModelo item = (ItemModelo)((DefaultMutableTreeNode)e.nextElement()).getUserObject();
                item.pintar(g);
            }
        }
    }

    public void setArvore(JTree arvore) {
        this.arvore = arvore;
    }

    @Override
    public TreePath[] getTreePath(ItemSelecionavel[] itens) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (int i = 0; i < itens.length; ++i) {
            if (itens[i] instanceof Pagina) {
                paths.add(new TreePath(this.root));
                continue;
            }
            if (!(itens[i] instanceof ItemModelo)) continue;
            paths.add(new TreePath(this.getPathToRoot(((ItemModelo)itens[i]).getTreeNode())));
        }
        return paths.toArray(new TreePath[paths.size()]);
    }

    @Override
    public void moverParaTopo(ItemSelecionavel item) {
        DefaultMutableTreeNode noDoItem;
        DefaultMutableTreeNode pai;
        if (!(item instanceof Banda) && item instanceof ItemModelo && ((ItemModelo)item).getTreeNode().getParent() != null && (pai = (DefaultMutableTreeNode)(noDoItem = (DefaultMutableTreeNode)((ItemModelo)item).getTreeNode()).getParent()).getIndex(noDoItem) < pai.getIndex(pai.getLastChild())) {
            this.removeNodeFromParent(noDoItem);
            this.insertNodeInto(noDoItem, pai, pai.getChildCount());
        }
    }

    @Override
    public void moverParaCima(ItemSelecionavel item) {
        DefaultMutableTreeNode noDoItem;
        DefaultMutableTreeNode pai;
        int indice;
        if (!(item instanceof Banda) && item instanceof ItemModelo && ((ItemModelo)item).getTreeNode().getParent() != null && (indice = (pai = (DefaultMutableTreeNode)(noDoItem = (DefaultMutableTreeNode)((ItemModelo)item).getTreeNode()).getParent()).getIndex(noDoItem)) < pai.getIndex(pai.getLastChild())) {
            this.removeNodeFromParent(noDoItem);
            this.insertNodeInto(noDoItem, pai, indice + 1);
        }
    }

    @Override
    public void moverParaBaixo(ItemSelecionavel item) {
        DefaultMutableTreeNode noDoItem;
        DefaultMutableTreeNode pai;
        int indice;
        if (!(item instanceof Banda) && item instanceof ItemModelo && ((ItemModelo)item).getTreeNode().getParent() != null && (indice = (pai = (DefaultMutableTreeNode)(noDoItem = (DefaultMutableTreeNode)((ItemModelo)item).getTreeNode()).getParent()).getIndex(noDoItem)) > pai.getIndex(pai.getFirstChild())) {
            this.removeNodeFromParent(noDoItem);
            this.insertNodeInto(noDoItem, pai, indice - 1);
        }
    }

    @Override
    public void moverParaBase(ItemSelecionavel item) {
        DefaultMutableTreeNode noDoItem;
        DefaultMutableTreeNode pai;
        if (!(item instanceof Banda) && item instanceof ItemModelo && ((ItemModelo)item).getTreeNode().getParent() != null && (pai = (DefaultMutableTreeNode)(noDoItem = (DefaultMutableTreeNode)((ItemModelo)item).getTreeNode()).getParent()).getIndex(noDoItem) > pai.getIndex(pai.getFirstChild())) {
            this.removeNodeFromParent(noDoItem);
            this.insertNodeInto(noDoItem, pai, 0);
        }
    }

    @Override
    public int getIndiceItem(ItemSelecionavel item) {
        if (item instanceof AbstractItemModelo && !(item instanceof Banda)) {
            DefaultMutableTreeNode noDoItem = (DefaultMutableTreeNode)((ItemModelo)item).getTreeNode();
            DefaultMutableTreeNode pai = (DefaultMutableTreeNode)noDoItem.getParent();
            return pai.getIndex(noDoItem);
        }
        return -1;
    }

    @Override
    public void removerItem(ItemSelecionavel item) {
        if (item instanceof ItemModelo && ((ItemModelo)item).getTreeNode().getParent() != null) {
            ItemModelo itemModelo = (ItemModelo)item;
            itemModelo.removerInstancia();
            this.removeNodeFromParent((MutableTreeNode)itemModelo.getTreeNode());
            this.insereRemoveNoInvalido();
        }
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        super.nodeStructureChanged(node);
        this.expandirTodosOsNos();
    }

    @Override
    public void revalidarItens() {
        DefaultMutableTreeNode[] nos = this.getTodosOsNos();
        for (int i = 0; i < nos.length; ++i) {
            if (nos[i] == this.root || nos[i] == this.noInvalido) continue;
            this.validarItem((ItemSelecionavel)nos[i].getUserObject());
        }
        this.insereRemoveNoInvalido();
    }

    @Override
    public boolean vazio() {
        return this.root == null || !this.root.children().hasMoreElements();
    }

    private void expandirTodosOsNos() {
        if (this.arvore != null && this.arvore.getModel() == this) {
            this.arvore.expandPath(new TreePath(this.root));
            Enumeration<? extends TreeNode> e = this.root.children();
            while (e.hasMoreElements()) {
                TreePath path = new TreePath(this.getPathToRoot(e.nextElement()));
                this.arvore.expandPath(path);
            }
        }
    }

    private DefaultMutableTreeNode[] getTodosOsNos() {
        ArrayList array = new ArrayList();
        this.preencherArray(this.root, array);
        return array.toArray(new DefaultMutableTreeNode[array.size()]);
    }

    private void preencherArray(TreeNode no, ArrayList array) {
        if (no == null || array == null) {
            return;
        }
        array.add(no);
        Enumeration<? extends TreeNode> e = no.children();
        while (e.hasMoreElements()) {
            this.preencherArray(e.nextElement(), array);
        }
    }

    private void validarItem(ItemSelecionavel item) {
        if (item instanceof ItemModelo && !(item instanceof Banda)) {
            ItemModelo itemModelo = (ItemModelo)item;
            ItemModelo banda = (ItemModelo)this.getBandaNoPonto(itemModelo.getRetangulo().getLocation());
            MutableTreeNode noDoItem = (MutableTreeNode)itemModelo.getTreeNode();
            Rectangle rec = null;
            if (banda != null) {
                Banda b;
                rec = banda.getRetangulo();
                if (banda instanceof Banda && (b = (Banda)banda).getTipo() == 2 && b.getColunas() > 0) {
                    int tamanhoColunas = rec.width / b.getColunas();
                    int widthColuna = rec.x + tamanhoColunas - b.getEntreColunas() / 2;
                    rec = new Rectangle(rec.x, rec.y, widthColuna, rec.height);
                }
            }
            if (banda == null || rec == null || !rec.contains(itemModelo.getRetangulo())) {
                if (noDoItem.getParent() != null) {
                    this.removeNodeFromParent(noDoItem);
                }
                this.insertNodeInto(noDoItem, this.noInvalido, this.noInvalido.getChildCount());
                itemModelo.setBanda(null);
            } else if (banda != itemModelo.getBanda() && banda != null) {
                if (noDoItem.getParent() != null) {
                    this.removeNodeFromParent(noDoItem);
                }
                MutableTreeNode pai = (MutableTreeNode)banda.getTreeNode();
                this.insertNodeInto(noDoItem, pai, pai.getChildCount());
                itemModelo.setBanda(banda);
            }
        }
    }

    private void insereRemoveNoInvalido() {
        if (this.haItensInvalidos() && this.noInvalido.getParent() == null) {
            this.insertNodeInto(this.noInvalido, (MutableTreeNode)this.root, this.root.getChildCount());
        } else if (!this.haItensInvalidos() && this.noInvalido.getParent() != null) {
            this.removeNodeFromParent(this.noInvalido);
        }
    }

    private boolean haItensInvalidos() {
        return this.noInvalido.getChildCount() > 0;
    }

    private boolean menor(Rectangle a, Rectangle b) {
        return a.width + a.height < b.width + b.height;
    }

    private void pintarConexoesBanda(Graphics g, ItemModelo[] bandas) {
        int nivelFilho = 5;
        int nivelRodape = 5;
        Stroke tmp = ((Graphics2D)g).getStroke();
        ((Graphics2D)g).setStroke(Constantes.TRACEJADO);
        for (int i = bandas.length - 1; i >= 0; --i) {
            int yB;
            int yA;
            int x;
            Rectangle recB;
            if (!(bandas[i] instanceof Banda) || ((Banda)bandas[i]).getTipo() != 1) continue;
            Rectangle recA = bandas[i].getRetangulo();
            ItemModelo item = this.bandaComNome(bandas, ((Banda)bandas[i]).getFilha());
            if (item != null) {
                g.setColor(Color.orange);
                recB = item.getRetangulo();
                x = recA.x - 3;
                yA = recA.y + recA.height / 2 + 3;
                yB = recB.y + recB.height / 2 - 3;
                g.drawLine(x - nivelFilho, yA, x, yA);
                g.drawLine(x - nivelFilho, yB, x, yB);
                g.drawLine(x - nivelFilho, yA, x - nivelFilho, yB);
                g.fillPolygon(new int[]{x - 3, x + 2, x - 3}, new int[]{yB - 4, yB, yB + 4}, 3);
                nivelFilho += 5;
            }
            if ((item = this.bandaComNome(bandas, ((Banda)bandas[i]).getRodape())) == null) continue;
            g.setColor(Color.blue);
            recB = item.getRetangulo();
            x = recA.x + recA.width + 3;
            yA = recA.y + recA.height / 2 + 3;
            yB = recB.y + recB.height / 2 - 3;
            g.drawLine(x, yA, x + nivelRodape, yA);
            g.drawLine(x, yB, x + nivelRodape, yB);
            g.drawLine(x + nivelRodape, yA, x + nivelRodape, yB);
            g.fillPolygon(new int[]{x + 3, x - 2, x + 3}, new int[]{yB - 4, yB, yB + 4}, 3);
            nivelRodape += 5;
        }
        ((Graphics2D)g).setStroke(tmp);
    }

    private ItemModelo bandaComNome(ItemModelo[] bandas, String nome) {
        for (int i = 0; i < bandas.length; ++i) {
            if (!(bandas[i] instanceof Banda) || !((Banda)bandas[i]).getNome().equalsIgnoreCase(nome)) continue;
            return bandas[i];
        }
        return null;
    }

    private void fireStateChanged() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = 0; i <= ouvintes.length - 2; i += 2) {
            if (ouvintes[i] != ChangeListener.class) continue;
            ((ChangeListener)ouvintes[i + 1]).stateChanged(new ChangeEvent(this));
        }
    }
}

