/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor;

import jalis.relatorio.editor.Pagina;
import jalis.relatorio.editor.Regua;

public class LinhaGuia {
    private Pagina pagina;
    private int orientacao;
    private int posicao;

    public LinhaGuia(Pagina pagina, int orientacao, int posicao) {
        this.pagina = pagina;
        this.orientacao = orientacao;
        this.posicao = posicao;
    }

    public int getPosicao() {
        return this.posicao;
    }

    public void setPosicao(int posicao) {
        if (this.pagina != null) {
            double zoom = this.pagina.getZoom();
            int a = (int)((double)this.posicao * zoom) - 1;
            int n = (int)((double)posicao * zoom) - 1;
            int w = 4;
            if (this.orientacao == 4) {
                Regua regua = this.pagina.getReguaVertical();
                regua.repaint(0, a, regua.getWidth(), w);
                regua.repaint(0, n, regua.getWidth(), w);
                this.pagina.repaint(0, a, this.pagina.getWidth(), w);
                this.pagina.repaint(0, n, this.pagina.getWidth(), w);
            } else if (this.orientacao == 5) {
                Regua regua = this.pagina.getReguaHorizontal();
                regua.repaint(a, 0, w, regua.getHeight());
                regua.repaint(n, 0, w, regua.getHeight());
                this.pagina.repaint(a, 0, w, this.pagina.getHeight());
                this.pagina.repaint(n, 0, w, this.pagina.getHeight());
            }
        }
        this.posicao = posicao;
    }

    public boolean horizontal() {
        return this.orientacao == 4;
    }

    public boolean vertical() {
        return this.orientacao == 5;
    }

    public int getOrientacao() {
        return this.orientacao;
    }
}

